<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


class Captura_ajax extends Builder_Controller {

	function __construct()
	{
		  parent::__construct();
		  $this->load->model('cad_model'); 
		  $this->load->library('newsletter/newsletter');
	}
	
	public function pre_cadastro()
    {
        $this->load->library('form_validation');
        
        $data = $this->input->post();
        
        if($data['origem_captura'] == 'avaliacao_nao'){
            
            $this->form_validation->set_rules('mensagem', 'Mensagem', 'required|trim');
            
            if ($this->form_validation->run() != FALSE) 
            {
                $insert['datetime_captura'] = date("Y-m-d H:i:s");
                $insert['mensagem'] = $data['mensagem'];
                $this->cad_model->insertCaptura($insert);
                
                $json = ['valid' => true,'msg' => "Sucesso!",'cap' => $data]; 
            }else{
                $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
            }   
            
            echo json_encode($json);
            die();
            
        }
        
        $this->form_validation->set_rules('nome', 'Nome', 'required|trim');
        $this->form_validation->set_rules('email', 'E-mail', 'required|trim|valid_email');
        $this->form_validation->set_rules('cep', 'CEP', 'required|trim');
        
		
		if ($this->form_validation->run() != FALSE) 
        {
            $data = $this->input->post();
            
            $cap = $this->cad_model->getCaptura([['email', $data['email']],['status_captura', 0],['origem_captura','avaliacao']]);
            
            if($cap == null)
            {
                $data['datetime_captura'] = date("Y-m-d H:i:s");
                
                $end = $this->buscar_cep($data['cep']);
                
                $data['endereco'] = $end['endereco'];
                $data['bairro']   = $end['bairro']  ;
                $data['cidade']   = $end['cidade']  ;
                $data['estado']   = $end['uf']  ;
                
                if($this->cad_model->insertCaptura($data)){
                    
                    $json = ['valid' => true,'msg' => "Sucesso!",'cap' => $data]; 
                }
                else{    
                    $json = ['valid' => false,'erro' => 3,'msg' => "Erro!"];
                }
            }else{
                $json = ['valid' => true ,'cap' => $cap ,'msg' => "E-mail já cadastrado!"];
            }
        }else{
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
    }
    
    
    public function atualiza_captura()
    {
        
        //``id_captura`, `nome`, `email`, `cep`, `origem_captura`, `datetime_captura`, `ultima_atualizacao`, `status_captura`, `tipo_captura`, `tipo_imovel`, `andar`, `quartos`, `vaga`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `valor_avaliacao`, `sugestao_avaliacao`, `mensagem`
        
        $this->load->library('form_validation');
        $this->form_validation->set_rules('tipo_imovel', 'tipo de imóvel', 'required|trim');
        $this->form_validation->set_rules('quartos', 'quartos', 'required|trim');
        $this->form_validation->set_rules('numero', 'numero', 'required|trim');
        $this->form_validation->set_rules('complemento', 'complemento', 'required|trim');
		
		if ($this->form_validation->run() != FALSE) 
        {
            $data = $this->input->post();
            
            $id_captura = $data['id_captura'];
            $key_captura = $id_captura.$this->gerar_senha(7,false,true,true,false);
            $update = [
                'key_captura'     => $key_captura,
                'status_captura'  => 1,
                'tipo_imovel'     => $data['tipo_imovel'],
                'andar'           => $data['andar'],
                'quartos'         => $data['quartos'],
                'vaga'            => $data['vaga'],
                'banheiros'       => $data['banheiros'],
                'area_total'      => $data['area_total'],
                'numero'          => $data['numero'],
                'complemento'     => $data['complemento'],
                ];
            
            
            if($id_captura != null)
            {
                if($this->cad_model->updateCaptura($id_captura,$update)){
                    
                    $cap = $this->cad_model->getCaptura([['id_captura', $id_captura]]);
                    
                    $dt = [
                            'nome'         => strtok($cap->nome, " "),
                            'linkcustom'   => base_url().'avaliacao/resultado/'.$key_captura,
                        ];
                    $this->newsletter->envia($cap->email, [32,6], $dt);
                    
                    $json = ['valid' => true,'msg' => "Sucesso!",'redirect' => base_url().'avaliacao/confirmacao/'.$key_captura, 'cap' => $update]; 
                }
                else{    
                    $json = ['valid' => false,'erro' => 3,'msg' => "Erro!"];
                }
            }else{
                $json = ['valid' => false,'erro' => 2,'msg' => "Erro!"];
            }
        }else{
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
    }
    
    
    public function buscar_cep($cep)
	{
	    $vazio = [
                    'latitude' => '',
                    'cep' => '',
                    'endereco' => '',
                    'bairro' => '',
                    'cidade' => '',
                    'estado' => ''
                ];
	    
	    if($cep == NULL || $cep == '')
           return $vazio;
	    
        $cep = preg_replace("/[^0-9]/", "", $cep);
        
        $end = $this->cad_model->getEndereco($cep);
        
        if (empty($end))
            return $vazio;
        else{
            $end = (array)$end;
            $end['latitude'] = '';
            $end['endereco'] = $end['logradouro'];
            return $end;
        }
	}
	
	private function gerar_senha($tamanho = 6, $maiusculas = true, $minusculas = true, $numeros = true, $simbolos = false)
    {
        $ma = "ABCDEFGHIJKLMNOPQRSTUVYXWZ"; // $ma contem as letras maiúsculas
        $mi = "abcdefghijklmnopqrstuvyxwz"; // $mi contem as letras minusculas
        $nu = "0123456789"; // $nu contem os números
        $si = "!@#$%¨&*()_+="; // $si contem os símbolos
        
        $senha = '';
        
        if ($maiusculas){
            // se $maiusculas for "true", a variável $ma é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($ma);
        }
        
        if ($minusculas){
            // se $minusculas for "true", a variável $mi é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($mi);
        }
        
        if ($numeros){
            // se $numeros for "true", a variável $nu é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($nu);
        }
        
        if ($simbolos){
            // se $simbolos for "true", a variável $si é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($si);
        }
        
        // retorna a senha embaralhada com "str_shuffle" com o tamanho definido pela variável $tamanho
        return substr(str_shuffle($senha),0,$tamanho);
    }
	
	
	
	
	
	
}