<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Get_ajax extends Builder_Controller {

	function __construct()
	{
        parent::__construct();
        $this->load->model('cad_model');
	}
	
	public function valid_login()
	{
	    $post = $this->input->post();
	    if ($post['ref']??false)
	         $this->session->set_userdata('ref_redirect', $post['ref']);
	    
	    $this->session->set_userdata('redirect_login_face_modal', true);
	    
        echo json_encode(['valid'=> $this->tank_auth->is_logged_in()]);
	}
   
    public function buscar_cep()
	{
	    
	    if ($this->input->post()) 
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('cep', 'Cep', 'required');
            if ($this->form_validation->run() != FALSE) 
            {
                $cep = preg_replace("/[^0-9]/", "", $this->input->post('cep'));
	            $end = $this->cad_model->getEndereco($cep);
	            
	            if (empty($end)) 
                {
                    $json = array(
                        'valid' => false,
                        'error' => 'Cep não encontrado' 
                    );
                    echo json_encode($json);
                }
                else
                {
            	    $end->valid = true;
                    echo json_encode((array)$end);
                }
	        }
            else
            {
                $json = array(
                    'valid' => false,
                    'error' => 'Preenchimento obrigatório'
                );
                echo json_encode($json);
            }
        }
        else
        {
            $json = array(
                'valid' => false,
                'error' => 'metodo invalido'
            );
            echo json_encode($json);
        }
	    
	    die();
	    
	    
	    if ($this->input->post()) 
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('cep', 'Cep', 'required');
            if ($this->form_validation->run() != FALSE) 
            {
                $cep = $this->input->post('cep');
        	    try
                {
                    $loginUrl = 'http://www.buscacep.correios.com.br/sistemas/buscacep/resultadoBuscaCepEndereco.cfm';
                    $postfields = array(
                        'relaxation' => $cep,
                        'tipoCEP' => 'ALL',
                        'semelhante' => 'N'
                    );
                    //init curl
                    $ch = curl_init();
                    //Set the URL to work with
                    curl_setopt($ch, CURLOPT_URL, $loginUrl);
                    curl_setopt($ch, CURLOPT_REFERER, "http://www.buscacep.correios.com.br/sistemas/buscacep/");
                    // ENABLE HTTP POST
                    curl_setopt($ch, CURLOPT_POST, TRUE);
                    //Set the post parameters
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $postfields);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_VERBOSE, TRUE);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
                    //execute the request (the login)
                    $response = curl_exec($ch); //curl_exec($ch);
                    
                    curl_close($ch);
                    $dom = new DOMDocument();
                    //print_r(html_entity_decode($response)); die();
                    @$dom->loadHTML($response);
                    $xpath = new DomXPath($dom);
                    $class = 'tmptabela';
                    //$divs = $xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' $class ')]");
                    $divs = $xpath->query("//*[contains(@class, 'tmptabela')]//tr[2]//td");
        
                    $array = array();
                    foreach ($divs as $div){
                        $array[] = $div->nodeValue;
                    }
                                
                    if (count($array) == 0) 
                    {
                        $json = array(
                            'valid' => false,
                            'error' => 'Cep não encontrado'
                        );
                        echo json_encode($json);
                    }
                    else
                    {
                        $logradouro = trim($array[0]);
                        $bairro = trim($array[1]);
                        if($bairro == 'Setor de Habitações Individuais Sul') $bairro = 'Lago Sul';
                        if($bairro == 'Setor de Habitações Individuais Norte') $bairro = 'Lago Norte';
                        $pseudo_adress = explode("/", $array[2]);
                        $cidade = trim($pseudo_adress[0]);
                        $uf = trim($pseudo_adress[1]);
                        $json = array(
                            'valid' => true,
                            'cep' => $cep,
                            'logradouro' => $logradouro,
                            'bairro' => $bairro,
                            'cidade' => $cidade,
                            'uf' => $uf
                        );
                        echo json_encode($json);
                        exit();
                    }
                }
                catch(Exception $e) 
                {
                    trigger_error(sprintf('Curl failed with error #%d: %s', $e->getCode() , $e->getMessage()) , E_USER_ERROR);
                }
            }
            else
            {
                $json = array(
                    'valid' => false,
                    'error' => 'Preenchimento obrigatorio'
                );
                echo json_encode($json);
            }
        }
        else
        {
            $json = array(
                'valid' => false,
                'error' => 'metodo invalido'
            );
            echo json_encode($json);
        }
	}
}