<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Login_ajax extends Builder_Controller {

	function __construct()
	{
		parent::__construct();
	} 
	
    public function checkCaptcha()
    {
        echo json_encode(['valid' => $this->session->gcaptcha]);
    }
		
	public function index()
	{
	    $post = $this->input->post();
	    if(!empty($post))
	    {
	        $data['logado'] = FALSE;
    	
        	$this->load->library('form_validation');
    		
    		if(isset($post['email']))
    		    $this->form_validation->set_rules('email', 'Email', 'required|trim');
    		if(isset($post['username']))
    		    $this->form_validation->set_rules('username', 'Login', 'required|trim');
    		$this->form_validation->set_rules('password', 'Senha', 'required|trim');
    		$this->form_validation->set_rules('lembrar', 'Lembrar', 'integer');
    		
    		if($this->session->gcaptcha == true){
    		    $this->form_validation->set_rules('g-recaptcha-response', 'recaptcha', 'required');
    		    
    		    if(!$this->check_google_captcha($post['g-recaptcha-response'])){
    		        echo json_encode(array(
                        'valid' => false,
                        'reset' => true,
					    'msg'   => 'Ops! Captcha incorreto, favor tentar novamente.'
                        )
                    );
                    die();
    		    }
    		}
    		
    		if ($this->form_validation->run() !== FALSE)
    		{	
    			$email   = $post['email']??null;
    			
    			$senha   = $post['password'];
    			$lembrar = 0;
    			$this->load->model('sistema/usuario_model');
    			
    			$porEmail = false;
    			$porUsername = false;
    			if(isset($post['email'])){
    				$login = $post['email'];
    				$porEmail = true;
    				$result = $this->usuario_model->consulta_email($email);
    			}
                elseif(isset($post['username']))
                {
                    $login = $post['username'];
                    $porUsername = true;
                    $result = true;
                }
                else
                {
                   $result = FALSE;
                }
                
                
    			if($result === FALSE )
    			{
    			    $this->session->set_userdata('gcaptcha', true);
    			    
    			    
                    echo json_encode(array(
                        'valid' => false,
					    'msg'   => 'Ops! Email e/ou senha incorreto(s). Tente novamente.'
                        )
                    );
    			}
    			else
    			{
    			    $result = $this->tank_auth->login($login, $senha, $lembrar, $porUsername, $porEmail, false);
    			 
        		    if($result === TRUE )
        			{
        			    $intencoes_busca = $this->session->intencoes_busca;
                        foreach (($intencoes_busca??[]) as $intencao){
                            $intencao['id_cadastro'] = $this->session->id_cadastro;
                            $this->cad_model->setIntencaoBusca($intencao);
                        }
                        $this->session->unset_userdata('intencoes_busca');
        			    
        			    $botaoCadImovel = $this->session->botaoCadImovel;
        			    
        			    if($botaoCadImovel === true){
        			         $this->session->unset_userdata('botaoCadImovel');
        			         $redirect = base_url("cadastro/imovel");
        			    }
        			    else{
        			        if(($post['modal']??false) == 'true' || ($post['login_externo']??false) == 'true')
        			        {
        			            $redirect = $this->session->ref_redirect;
        			        }
        			        else
        			        {
        			            $redirect = base_url('minha-conta');
        			            //$redirect = $this->refRedirect();
        			        }
        			    }
        			    
                    	echo json_encode(array(
                            'valid' => true,
    						'redirect' => $redirect
                        ));
        			}
        			else
        			{
        			    
        			    $this->session->set_userdata('gcaptcha', true);
        			    
        			    
        			    $errors = $this->tank_auth->get_error_message();
        			    
        			    if (isset($errors['not_activated'])) // not activated user
        			    {		
        			    	echo json_encode(array(
                                'valid' => false,
        					    'msg'   => 'Acesso negado. A sua conta ainda não foi ativada.'
                            ));
        			    }
        			    
        			    elseif (isset($errors['banned']) && $errors['banned'] !== NULL) // banned
        			    {
        			    	echo json_encode(array(
                                'valid' => false,
        					    'msg'   => 'Não foi possível realizar o acesso! Entre em contato com o suporte ;)'
                            ));
        			    }
        			    
        			    elseif (isset($errors['password_changed'])) // password_changed
        			    {
        			    	echo json_encode(array(
                                'valid' => false,
        					    'msg'   => 'Acesso incorreto. Solicitação de alteração de senha.'
                            ));
        			    }			    
        			    else 
        			    {	
        			        echo json_encode(array(
                                'valid' => false,
        					    'msg'   => 'Ops! Login e/ou senha incorreto(s). Tente novamente.'
                                )
                            );
        			    }
        			} 
    			}
    		}
    		else
    		{
    		    
    		    echo json_encode(array(
                        'valid' => false,
					    'msg'   => 'Erro.',
					    'erros_form' => validation_errors()
                        )
                    );
    		    $data['erros_form'] = validation_errors();
    		}
	    }
	}
	
	
public function check_google_captcha($response) 
{
    $url = 'https://www.google.com/recaptcha/api/siteverify';
    // init curl
    $ch = curl_init();
    
    $secret = $this->db->where('name','captcha_private_key')->get('sys_config')->row()->value;
    
    //Set the URL to work with
    curl_setopt($ch, CURLOPT_URL, $url);
    // ENABLE HTTP POST
    curl_setopt($ch, CURLOPT_POST, TRUE);
    //Set the post parameters
    curl_setopt($ch, CURLOPT_POSTFIELDS, 'secret=' . $secret . '&response=' . $response);
    //Handle cookies for the login
    curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie-google.txt');
    //curl_setopt($ch,CURLOPT_USERAGENT,'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17');
    curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
    curl_setopt($ch, CURLOPT_VERBOSE, TRUE);
    
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    //Setting CURLOPT_RETURNTRANSFER variable to 1 will force cURL
    //not to print out the results of its query.
    //Instead, it will return the results as a string return value
    //from curl_exec() instead of the usual TRUE/FALSE.
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    //execute the request (the login)
    $response = curl_exec($ch);
    //the login is now done and you can continue to get the
    //protected content.
    
    curl_close($ch);
    
    
    $res = json_decode($response);
    
    return $res->success??FALSE;
}
	
	
	public function bk_index()
	{
	    $post = $this->input->post();
	    if(!empty($post))
	    {
	        $data['logado'] = FALSE;
    	
        	$this->load->library('form_validation');
    		
    		$this->form_validation->set_rules('email', 'Email', 'required|trim');
    		$this->form_validation->set_rules('password', 'Senha', 'required|trim');
    		$this->form_validation->set_rules('lembrar', 'Lembrar', 'integer');
    		
    		if ($this->form_validation->run() !== FALSE)
    		{	
    			$email   = $post['email'];
    			$senha   = $post['password'];
    			$lembrar = 0;
    			$this->load->model('sistema/usuario_model');
    			
    			$result = $this->usuario_model->consulta_email($email);
                
    			if($result === FALSE )
    			{
                    echo json_encode(array(
                        'valid' => false,
					    'msg'   => 'Ops! Email e/ou senha incorreto(s). Tente novamente.'
                        )
                    );
    			}
    			else
    			{
    			    $result = $this->tank_auth->login($username, $senha, $lembrar, true, false, false);
    			 
        		    if($result === TRUE )
        			{
        			    $intencoes_busca = $this->session->intencoes_busca;
                        foreach (($intencoes_busca??[]) as $intencao){
                            $intencao['id_cadastro'] = $this->session->id_cadastro;
                            $this->cad_model->setIntencaoBusca($intencao);
                        }
                        $this->session->unset_userdata('intencoes_busca');
        			    
        			    $botaoCadImovel = $this->session->botaoCadImovel;
        			    
        			    if($botaoCadImovel === true){
        			         $this->session->unset_userdata('botaoCadImovel');
        			         $redirect = base_url("cadastro/imovel");
        			    }
        			    else{
        			        if(($post['modal']??false) == 'true')
        			        {
        			            $redirect = $this->session->ref_redirect;
        			        }
        			        else
        			        {
        			            $redirect = base_url('minha-conta');
        			            //$redirect = $this->refRedirect();
        			        }
        			    }
        			    
                    	echo json_encode(array(
                            'valid' => true,
    						'redirect' => $redirect
                        ));
        			}
        			else
        			{
        			    $errors = $this->tank_auth->get_error_message();
        			    
        			    if (isset($errors['not_activated'])) // not activated user
        			    {		
        			    	echo json_encode(array(
                                'valid' => false,
        					    'msg'   => 'Acesso negado. A sua conta ainda não foi ativada.'
                            ));
        			    }
        			    
        			    elseif (isset($errors['banned']) && $errors['banned'] !== NULL) // banned
        			    {
        			    	echo json_encode(array(
                                'valid' => false,
        					    'msg'   => 'Não foi possível realizar o acesso! Entre em contato com o suporte ;)'
                            ));
        			    }
        			    
        			    elseif (isset($errors['password_changed'])) // password_changed
        			    {
        			    	echo json_encode(array(
                                'valid' => false,
        					    'msg'   => 'Acesso incorreto. Solicitação de alteração de senha.'
                            ));
        			    }			    
        			    else 
        			    {	
        			        echo json_encode(array(
                                'valid' => false,
        					    'msg'   => 'Ops! Email e/ou senha incorreto(s). Tente novamente.'
                                )
                            );
        			    }
        			} 
    			}
    		}
    		else
    		{
    		    $data['erros_form'] = validation_errors();
    		}
	    }
	}
	
	private function valida_sessao()
	{
	    
	    $verifica_user_logado = $this->tank_auth->is_logged_in();
	   
        if($verifica_user_logado == TRUE)
        {
            redirect();
        }
	}
	
	public function esqueci_a_senha() 
    {
        //$data['result_cadastro'] = $this->session->flashdata('result_cadastro'); //result da ativacao do cadastro da nova senha
        
        if ($this->input->post() == TRUE) 
        {
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules('email', 'E-mail do responsável', 'required|valid_email|trim');
            
            if ($this->form_validation->run() != FALSE) 
            {
                $email = $this->input->post('email');
                
                $this->load->model('sistema/usuario_model');
                
                $result_email = $this->usuario_model->get_usuario_by_email($email);
                
                
                if ($result_email !== NULL) 
                {   
                    /*if ($result_email->new_password_key == NULL) 
                    {*/
                        $id_cadastro = $result_email->id_cadastro;
                        $nome = $this->altera_nome($result_email->nome);
                        $new_password_key = md5(rand() . microtime());
                        
                        $result_new_password = $this->usuario_model->update_new_password_key($email, $new_password_key);
                        
                        if ($result_new_password === TRUE) 
                        {
                            $this->send_message_by_email($nome, $id_cadastro, $email, $new_password_key);
                        } 
                        else
                        {
                            echo json_encode(array(
                                'valid' => false,
                                'msg' => 'O e-mail de confirmação para troca de senha não pode ser enviado. Por favor, tente novamente mais tarde.'
                            ));
                        }
                    /*} 
                    else
                    {
                        echo json_encode(array(
                            'valid' => false,
                            'msg' => 'Uma mensagem para cadastro de nova senha foi enviada para o seu e-mail. Se você não recebeu a nossa mensagem verifique na sua caixa de spam ou no lixo eletrônico e marque o nosso contato como confiável.
'
                        ));
                    }*/
                } 
                else
                {
                    echo json_encode(array(
                        'valid' => false,
                        'msg' => 'O e-mail informado não foi encontrado em nosso banco de dados. Favor inserir o seu e-mail no campo acima ou realizar o seu cadastro para ter acesso ao Comdono.'
                    ));
                }
            } 
            else
            {
                echo json_encode(array(
                    'valid' => false,
                    'msg' => 'Por favor, insira um email válido.'
                ));
            }
        }
    }
    
    public function send_message_by_email($nome, $id_cadastro, $email, $new_password_key) 
    {
        //$this->load->library('email');
        
        $url = base_url() . "comdono/login/new_password/" . $id_cadastro . $new_password_key;
        
        $data = array(
            'nome' => $nome,
            'url' => $url,
            'key_concat' => $id_cadastro . $new_password_key
        );
        
        $this->load->library('newsletter/newsletter');
        
        
        $message = "<p>Pronto! Uma mensagem foi encaminhada para <strong>$email</strong> com as instruções para recuperar sua senha.</p><p>Caso não tenha recebido, verifique a caixa de spam e o lixo eletrônico.</p><hr>";
        
        /*$message = "<p class='text-center'>Uma mensagem de solicitação foi encaminhada para<br/><b> $email </b><br/> 
    	Clique no link da mensagem para cadastrar nova senha ou, caso não tenha recebido a mensagem, entre em contato conosco.</p>";*/
        
        if ($this->newsletter->enviar_email_campanha($email, 16, $data)) 
        {
            echo json_encode(array(
                'valid' => true,
                'msg' => $message,
            ));
        } 
        else
        {
            echo json_encode(array(
                'valid' => false,
                'msg' => 'O email de confirmação para a troca da senha não pode ser enviado. Por favor, tente novamente mais tarde.'
            ));
        }
    }
	
	public function atualizar_senha() 
    {
        
        if ($this->input->post() == TRUE) 
        {
            
            $this->load->library('form_validation');
            
            //$this->form_validation->set_rules('nova_senha', 'Senha', 'required|trim');
            $this->form_validation->set_rules('nova_senha', 'Senha', 'required|trim|min_length[8]|matches[conf_nova_senha]');
            $this->form_validation->set_rules('conf_nova_senha', 'Confirmar Senha', 'required|trim');
            
            if ($this->form_validation->run() != FALSE) 
            {
                //$auth = new Tank_auth();
                $senha = $this->input->post('nova_senha');
                //$password = $auth->password_hash($senha);
                $password = $this->password_hash($senha);
                
                
                $modal_senha = $this->session->userdata('troca_senha');
                $key = $modal_senha->id_cadastro . $modal_senha->new_password_key;
                
                //$result = FALSE;
                $this->load->model('sistema/usuario_model');
                $result = $this->usuario_model->definir_nova_senha($password, $key);

                if ($result === TRUE) 
                {
                    echo json_encode(array(
                        'valid' => true,
                        'msg' => 'A sua senha foi atualizada com sucesso.'
                    ));
                    $this->session->unset_userdata('troca_senha');
                } 
                else
                {
                    echo json_encode(array(
                        'valid' => false,
                        'msg' => 'A senha não pode ser atualizada. Favor tentar novamente ou entre em contato conosco.'
                    ));
                }
            } 
            else
            {
                echo json_encode(array(
                    'valid' => false,
                    'msg' => validation_errors(),
                ));
            }
        }
        /*'*/
    }
	
    private function password_hash($senha) 
    {
        // Hash password using phpass
        $hasher = new PasswordHash($this->config->item('phpass_hash_strength', 'tank_auth') , $this->config->item('phpass_hash_portable', 'tank_auth'));
        $senha = $hasher->HashPassword($senha);
        
        return $senha;
    }
    
    private function altera_nome($str){
        $nome = explode(' ', $str);
        $first = array_shift($nome);
        $last = array_pop($nome);
        $nome_novo = trim($first." ".$last);
        
        return $nome_novo;
    }
	
	
 }