<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


class Notification {
    
    private static $CI;
    
    function __construct() 
    {
        self::$CI =& get_instance();
    } 
    
    static function cad_model()
    {
        return self::$CI->cad_model;
    } 
    
    static function admin_model()
    {
        return self::$CI->admin_model;
    }
    
    static function empreendimentoDiretoresParceiro($ID, $id_parceiro, $UUID, $data = [])
    {
        $msg = self::cad_model()->getMsgNtf(['uuid_msg', $UUID]);
        
        $parceiro = self::admin_model()->getParceiroEmpreendimento([['id_empreendimento',$ID],['inc_parceiro.id_parceiro', $id_parceiro]]);
        if($parceiro != null)
        {
            $membros = self::cad_model()->getMembros(
                [
                    [
                        [['tipo', 2],['id_rel', $parceiro->id_parceiro]],
                        [['tipo', 3],['id_rel', $ID],['id_perfil', 2]]
                    ],
                ]);
            
            $agrupados = [];
            foreach ($membros as $membro)
                $agrupados[$membro->id_cadastro][$membro->tipo] = $membro->id_rel;
            
            foreach ($agrupados as $id_cadastro => $array){
                if(count($array) == 2)
                    self::notifica($msg, $ID, $id_cadastro, $data);
            }
        }
        
    }
    
    static function empreendimentoFuncao($ID, $id_funcao, $UUID, $data = [])
    {
        $msg = self::cad_model()->getMsgNtf(['uuid_msg', $UUID]);
        $membros = self::cad_model()->inArrayJson('id_empreendimentos',$ID)->getMembros(['id_funcao', $id_funcao]);
        
        foreach ($membros as $membro)
            self::notifica($msg, $ID, $membro->id_cadastro, $data); 
    }
    
    static function empreendimentoMembro($ID, $id_cadastro, $UUID, $data = [])
    {
        $msg = self::cad_model()->getMsgNtf(['uuid_msg', $UUID]);
        
        self::notifica($msg, $ID, $id_cadastro, $data);
    }
    
    static function notifica($msg, $ID, $id_cadastro, $data)
    {
        $insert = (array)$msg;
        $insert['href'] = $insert['href'].$ID;
        $insert = array_merge($insert, $data);
        $insert['tipo'] = 'incorporadora';
        $insert['id_cadastro'] = $id_cadastro;
        
        $insert['subject'] = strip_tags($msg->text).' '.diaMes(date("Y-m-d H:i:s"));
        $insert['from_titulo'] = 'Comdono';
        $insert['mensagem'] = $msg->text;
        $insert['campanha'] = 'Notificação';
        
        
        self::cad_model()->insertNotificacao($insert);
        
        self::push($id_cadastro, $insert);
        
        self::sms($id_cadastro, $insert);
        
        self::email($id_cadastro, $insert);
    }
   
    function envia($email, $ids, $dados = null) 
    {
        return $this->enviar_email_campanha($email, $ids, $dados);
    }
    
    static function getAll() 
    {
        $notifications = [];
        $result = self::$CI->cad_model->getNotifications();
        
        foreach($result  as $not)
        {
            $key = $not->id_rel.$not->name_id.$not->tipo;
            $contador[$key][] = '';
            $not->cont = count($contador[$key]);
            $notifications[$key] = $not;
        }
        return $notifications;
    }
    
    static function get($where = []) 
    {
        return self::$CI->cad_model->getNotifications();
    }
    
    static function editChat($arrayWhere,$data)
    {
        return self::$CI->cad_model->updateNotification($arrayWhere,$data);
    }
    
    static function addChatMsg($res)
	{
        $ids = [
            $res->id_cartorio,
            $res->id_dono,
            $res->id_interessado
            ];
        $refs = [
            'minha_conta/cartorio/negociacoes/'.$res->id_imovel.'/'.$res->id_chat,
            'minha_conta/minhas_vendas/negociacoes/'.$res->id_imovel.'/'.$res->id_chat,
            'minha_conta/minhas_compras/negociacoes/'.$res->id_imovel.'/'.$res->id_chat,
            ];
            
        $notification = [
            'id_rel' =>          $res->id_chat,
            'name_id' =>         'id_chat',
            'tipo' =>            'chat',
            'text' =>            'Mensagem Chat '.$res->id_chat,
            'class_spam_cont' => 'contNotfChat_'.$res->id_chat,
                    ];
            
        $id_send = self::$CI->session->id_cadastro;
                    
	    foreach($ids as $k=>$id_cad)
	    {
	        if(!(in_array($id_cad,[0,$id_send]))){
	            
	            $notification['id_cadastro'] = $id_cad;
	            $notification['cont'] = 0;
	            $notification['href'] = $refs[$k];
	            
	            self::$CI->cad_model->insertNotification($notification);
	        }
	        
	    }
	    
	}
	static function addChatSolicitacao($res)
	{
        $notification = [
            'id_rel' =>          0,
            'name_id' =>         'id_chat',
            'tipo' =>            'ini_chat',
            'text' =>            'Nova Solicitação',
            'class_spam_cont' => '',
                    ];
            
        $notification['id_cadastro'] = $res->id_dono;
	    $notification['cont'] = 0;
	    $notification['href'] = 'minha_conta/resumo';
	            
	    self::$CI->cad_model->insertNotification($notification);
	}
	
	static function push($id_cadastro, $notf){
        
        $notf = (object)$notf;
        $title = 'Comdono';
        $message = strip_tags($notf->text);
        $img = NULL;
        
        //$title = "Um Interessado Iniciou o Chat";
        //$message = "Abre o chat meu filho";
        if($img == NULL){
            $icon = getenv('S3_IMAGES').'/modules/comdono/ico/ico-dono.png';
        }else{
            $icon = $img;
        }
            
        $url = base_url($notf->href);
        
        $ids = json_decode(self::cad_model()->get_push_key($id_cadastro), TRUE);
        
        if($ids != NULL){
            $subscribers = [];
            
            foreach($ids as $id){
                $subscribers[] = $id;
            }
        }else{
            return FALSE;
        }
        
        $curlUrl = "https://api.pushalert.co/rest/v1/send";
        
        //POST variables
        if($title != NULL && $message != NULL){
            $post_vars = array(
            	"icon" => $icon,
            	"title" => $title,
            	"message" => $message,
            	"url" => $url,
            	"subscribers" => json_encode($subscribers)
            );
        }else{
            return FALSE;
        }
        
        $output = self::curl($curlUrl, $post_vars);
        
        if($output["success"]) {
        	return TRUE; 
        } else {
        	return FALSE;
        }
    	
    }
    
    static function email($id_cadastro, $notf){
        
        
        if(getenv('BASE_URL') == "https://dev.comdono.com/")
        {
            //return true;
        }
        
        $membro = self::cad_model()->get_cadastro([],$id_cadastro);
        
        self::$CI->load->library('newsletter/newsletter');
        
        return self::$CI->newsletter->envia($membro->email??'', 1, $notf);
        
    }
    
    
    static function sms($id_cadastro, $notf){
        
        
        if(getenv('BASE_URL') == "https://dev.comdono.com/" || getenv('BASE_URL') == "https://dev.crm.comdono.com/")
        {
            return true;
        }
        
        $membro = self::cad_model()->get_cadastro([],$id_cadastro);
        
        self::$CI->load->helper('comdono/comtele_sms');
        
        if(isset($membro->telefone))
            $result = send_sms("Comdono",strip_tags($notf['text']), [$membro->telefone]);
        
    }
    
    static function curl($curlUrl, $post_vars){
        $headers = Array();
    	$headers[] = "Authorization: api_key=8cb6f5226937ade3a7c91a0d64b9e392";
    
    	$ch = curl_init();
    	curl_setopt($ch, CURLOPT_URL, $curlUrl);
    	curl_setopt($ch, CURLOPT_POST, true);
    	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_vars));
    	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    
    	$result = curl_exec($ch);
    
    	$output = json_decode($result, true);
    	
    	return $output;
    }
    
    
}