<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


class PushAlert {
    
    private $apiKey = "8cb6f5226937ade3a7c91a0d64b9e392";
    
    function __construct() 
    {
        $this->CI =& get_instance();
    }
    
    //RECEBE ARRAY    
    function envia_interessado_chat($id_cadastro, $link = NULL){
        
        $textos = $this->faz_textos(rand(1,3));
        $icon = getenv('S3_IMAGES').'/modules/comdono/ico/ico-dono.png';
        $url = $link ?? base_url().'minha_conta/minhas_vendas/negociacoes';
        
        $ids = json_decode($this->CI->cad_model->get_push_key($id_cadastro), TRUE);
        
        if($ids != NULL){
            $subscribers = [];
            
            foreach($ids as $id){
                $subscribers[] = $id;
            }
        }else{
            return FALSE;
        }
        
        $curlUrl = "https://api.pushalert.co/rest/v1/send";
        
        //POST variables
        $post_vars = array(
        	"icon" => $icon,
        	"title" => $textos['title'],
        	"message" => $textos['msg'],
        	"url" => $url,
        	"subscribers" => json_encode($subscribers)
        );
        $output = $this->curl($curlUrl, $post_vars);
        
        if($output["success"]) {
        	return TRUE; 
        } else {
        	return FALSE;
        }
    	
    }
    
    function faz_textos($i, $nome = ''){
        switch($i){
            case 1:
                $title = 'Oba! Tem alguém interessado no seu imóvel!';
                $msg = 'Corra já para o chat para ver quem é';
            break;
            
            case 2:
                $title = 'Já temos um interessado para o seu imóvel!';
                $msg = 'Conheça mais sobre ele no chat Comdono';
            break;
            
            case 3:
                $title = 'Adivinha só? Tem gente querendo falar com o dono!';
                $msg = 'Entre no chat para conversar com o comprador';
            break;
            
            case 4:
                $title = $nome.' te mandou uma mensagem no chat Comdono!';
                $msg = 'Clique para responder';
            break;
            
            case 5:
                $title = 'Pronto para começar a negociação do imóvel?';
                $msg = 'Responda a mensagem de '.$nome.' no chat Comdono!';
            break;
            
            case 6:
                $title = 'Mensagem nova para você no chat Comdono!';
                $msg = $nome.' quer conversar sobre o imóvel';
            break;
            
            case 7:
                $title = $nome.' quer conversar com você no chat Comdono!';
                $msg = 'Entre já e comece a negociação';
            break;
            
            case 8:
                $title = 'A negociação do seu imóvel já começou!';
                $msg = 'Entre no chat para responder a mensagem de '.$nome;
            break;
        }
        
        return ['title' => $title, 'msg' => $msg];
    }
    
    function push_tag($id_cadastro, $tag = null){
        if($tag != NULL){
            $push = $this->CI->cad_model->get_push($tag);
            
            if($id_cadastro != NULL && $id_cadastro > 0){
                return $this->push_custom($id_cadastro, $push->titulo, $push->texto, $push->img);
            }else{
                return FALSE;
            }
        }else{
            return FALSE;
        }
    }
    
    function push_custom($id_cadastro, $title, $message, $img = NULL){
        
        //$title = "Um Interessado Iniciou o Chat";
        //$message = "Abre o chat meu filho";
        if($img == NULL){
            $icon = getenv('S3_IMAGES').'/modules/comdono/ico/ico-dono.png';
        }else{
            $icon = $img;
        }
            
        $url = base_url();
        
        $ids = json_decode($this->CI->cad_model->get_push_key($id_cadastro), TRUE);
        
        if($ids != NULL){
            $subscribers = [];
            
            foreach($ids as $id){
                $subscribers[] = $id;
            }
        }else{
            return FALSE;
        }
        
        $curlUrl = "https://api.pushalert.co/rest/v1/send";
        
        //POST variables
        if($title != NULL && $message != NULL){
            $post_vars = array(
            	"icon" => $icon,
            	"title" => $title,
            	"message" => $message,
            	"url" => $url,
            	"subscribers" => json_encode($subscribers)
            );
        }else{
            return FALSE;
        }
        
        $output = $this->curl($curlUrl, $post_vars);
        
        if($output["success"]) {
        	return TRUE; 
        } else {
        	return FALSE;
        }
    	
    }
    
    function envia_notificacao_chat($id_cadastro, $nome, $link = NULL){
        
        $textos = $this->faz_textos(rand(4,8), $nome);
        $icon = getenv('S3_IMAGES').'/modules/comdono/ico/ico-dono.png';
        $url = $link??base_url();
        
        $ids = json_decode($this->CI->cad_model->get_push_key($id_cadastro), TRUE);
        
        if($ids != NULL){
            $subscribers = [];
            
            foreach($ids as $id){
                $subscribers[] = $id;
            }
        }else{
            return FALSE;
        }
        
        $curlUrl = "https://api.pushalert.co/rest/v1/send";
        
        //POST variables
        $post_vars = array(
        	"icon" => $icon,
        	"title" => $textos['title'],
        	"message" => $textos['msg'],
        	"url" => $url,
        	"subscribers" => json_encode($subscribers)
        );
        $output = $this->curl($curlUrl, $post_vars);
        
        if($output["success"]) {
        	return TRUE; 
        } else {
        	return FALSE;
        }
    }
    
    function curl($curlUrl, $post_vars){
        $headers = Array();
    	$headers[] = "Authorization: api_key=".$this->apiKey;
    
    	$ch = curl_init();
    	curl_setopt($ch, CURLOPT_URL, $curlUrl);
    	curl_setopt($ch, CURLOPT_POST, true);
    	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_vars));
    	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    
    	$result = curl_exec($ch);
    
    	$output = json_decode($result, true);
    	
    	return $output;
    }
}