<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Busca_model extends Cad_model
{
    function __construct() {
        parent::__construct();
    }
    
    function config_default_campanhas()
    {
        //$perfil = $this->session->perfil??0;
        
        //if($perfil == 1)
        //    $this->db->where('status >=', 2);
        //else
        $this->db->where('status', 3);
        
        $this->db->where('lixeira', 0);
        
        $this->db->where('val_pretendido >', 0);
        
        
        
        //$this->db->where('data_validade >= ', date("Y-m-d"));
        //$this->db->where('data_inicio <= ', date("Y-m-d"));
    }
    
    function getImoveis($where = [], $like = [], $or_where = [], $or_like = [], $order_by = [], $config = true) 
    {
        $this->db->select('*, a.id_imovel as id_imovel, a.id_cadastro as id_cadastro');
        if($config)
            $this->config_default_campanhas();
        $this->where($where, $or_where);
        $this->like($like, $or_like);
        $this->order_by($order_by);
        
        $this->db->order_by('val_pretendido', 'ASC');
        //$this->db->join('cad_img as b', 'b.id_imovel = a.id_imovel','left');
        
        $query = $this->db->get('cad_imovel as a');
        // echo( $this->db->last_query());
        if ($query->num_rows() > 0)
        {
            $result = $query->result();
            $imoveis = [];
            $imagens = [];
            
            foreach($result as $obj)
            {
                //$obj->val_pretendido += $obj->val_public_total;
                $id = $obj->id_imovel;
                $imoveis[$id] = self::mGetImovel($obj);
                if( true)
                //if( $obj->id_img??'' == '')
                    //$imagens[$id] = [];
                    $imagens[$id] = $this->db->where('id_imovel', $id)->order_by('priority', 'ASC')->limit(3)->get('cad_img')->result();
                else 
                     $imagens[$id][] = self::mGetImagem($obj);
                
                $imoveis[$id]->imagens = $imagens[$id];
            }
            return $imoveis;
        }
            
        return [];
    }
    
    function getImovel($where = [], $like = [], $or_where = [], $or_like = [], $order_by = [], $config = true) 
    {
        $this->db->select('*, a.id_imovel as id_imovel, a.id_cadastro as id_cadastro');
        if($config)
            $this->config_default_campanhas();
        $this->where($where, $or_where);
        $this->like($like, $or_like);
        $this->order_by($order_by);
        $this->db->order_by('priority', 'ASC');
        $this->db->join('cad_img as b', 'b.id_imovel = a.id_imovel','left');
        $query = $this->db->get('cad_imovel as a');
        //echo( $this->db->last_query());
        if ($query->num_rows() > 0)
        {
            $result = $query->result();
            $imagens = [];
            
            foreach($result as $obj)
            {
                $id = $obj->id_imovel;
                //$obj->val_pretendido += $obj->val_public_total;
                $imovel = self::mGetImovel($obj);
                if( $obj->id_img == '')
                    $imagens[$id] = [];
                else 
                     $imagens[$id][] = self::mGetImagem($obj);
                
                $imovel->imagens = $imagens[$id];
            }
            return $imovel;
        }
        return null;
    }
    
    function getImovelById($id_imovel)
    {
        if($id_imovel > 0)
            return $this->getImovel([['a.id_imovel',$id_imovel]]);
        return null;
    }
    
    function getLancamentoById($id_imovel)
    {
        if($id_imovel > 0)
            return $this->getImovel([['a.id_imovel',$id_imovel]],[],[],[],[],false);
        return null; 
    }
    
    function adminGetImovelById($id_imovel)
    {
        $imovel = null;
        $perfil = $this->session->perfil??0;
        if($id_imovel > 0 && $perfil > 0)
            $imovel =  $this->getImovel([['a.id_imovel',$id_imovel]],[],[],[],[],false);
        if($imovel == null)
            $imovel =  $this->getImovel([['a.id_imovel',$id_imovel],['a.id_cadastro',$this->session->id_cadastro]],[],[],[],[],false);
        return $imovel;
    }
    
    ////////////////QI CLUB EXEMPLO
    function select_campanhas($where = null, $like = null, $or_where = null, $or_like = null, $order_by = null) 
    {
        $this->config_default_campanhas();
        $this->where($where, $or_where);
        $this->like($like, $or_like);
        $this->order_by($order_by);
        $this->db->join('qi_categorias', 'qi_categorias.id_categoria = qi_campanhas.id_categoria');
        $this->db->join('qi_estados', 'qi_estados.id_uf = qi_campanhas.id_estado');
        $query = $this->db->get($this->tb_campanha);
        if ($query->num_rows() > 0) 
        {
            $return = $query->result();
            $return = $this->add_galeria_nas_campanhas($return);
            $return = $this->add_itens_nas_campanhas($return);
            $return = $this->add_key_anunciante_e_anunciante_nas_campanhas($return);
            return $return;
        }
        return null;
    }
    
    
    //favoritos
    function get_favoritos()
    {
        $id_cadastro = $this->session->id_cadastro;
        if($id_cadastro == null)
            return [];
        
        $this->db->where('id_cadastro',$id_cadastro);
	    $query = $this->db->get('cad_favoritos');
	    if ($query->num_rows() > 0)
	    {
	        $result = $query->result();
	        $favoritos = [];
	        foreach($result as $obj)
            {
                $id = $obj->id_imovel;
                $favoritos[$id] = $obj;
                
            }
            return $favoritos;
        }
	    return [];
    }
    
}