<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Site_model extends CI_Model
{
    public function get_faqs() {
        $this->db->join('faq_categorias', 'faq_perguntas_respostas.id_cat = faq_categorias.id_cat', 'left');
        $query = $this->db->get('faq_perguntas_respostas');
        
        if ($query->num_rows() > 0) 
        {
            $result = $query->result();
            $cat = [];
            $perguntas = [];
            
            foreach($result as $obj)
            {
                $id = $obj->id_cat;
                $cat[$id] = ($obj);
                if( $obj->id_perg == '')
                    $perguntas[$id] = [];
                else 
                     $perguntas[$id][] = ($obj);
                
                $cat[$id]->perguntas = $perguntas[$id];
            }
            return $cat;
        }
        return NULL;
    }
    
    public function get_resposta($pergunta)
	{
        $this->db->where('id_perg', $pergunta);
            
	    $query = $this->db->get('faq_perguntas_respostas');
	    if ($query->num_rows() > 0)
			return $query->row();
		return null;
	}
	
	public function get_sitemap()
	{
	    $query = $this->db->get('cad_sitemap');
	    if ($query->num_rows() > 0)
			return $query->result();
		return null;
	}
	
	public function get_conteudos() {
        $this->db->join('des_categorias', 'des_conteudos.id_cat = des_categorias.id_cat', 'left');
        $query = $this->db->get('des_conteudos');
        
        if ($query->num_rows() > 0) 
        {
            $result = $query->result();
            $cat = [];
            $conteudos = [];
            
            foreach($result as $obj)
            {
                $id = $obj->id_cat;
                $cat[$id] = ($obj);
                if( $obj->id_conteudo == '')
                    $conteudos[$id] = [];
                else 
                     $conteudos[$id][] = ($obj);
                
                $cat[$id]->conteudos = $conteudos[$id];
            }
            return $cat;
        }
        return NULL;
    }
    
    public function get_conteudo($titulo)
	{
        $this->db->where('id_conteudo', $titulo);
            
	    $query = $this->db->get('des_conteudos');
	    if ($query->num_rows() > 0)
			return $query->row();
		return null;
	}
}