<!--inicio etapa-2 -->
<div class="etapa-2" data-title="Etapa 2 - Você já está quase lá">
    <!--inicio step-3 -->
    <div class="step">
        <div class="row">
            <div class="col-lg-6 pr-40">
                <div class="container-info">
                    <div class="content-title">
                        <?php if($textTitulo??false){
                            e("<h2>$textTitulo</h2>");
                        } else { ?>
                            <h2>Cadastro<span>de imóvel</span></h2>
                        <?php } ?>
                    </div>
                    
                    <p>Ao incluir o CEP, não esqueça de verificar se o endereço está com todas as informações. A localização é muito importante para quem busca um imóvel.</p>
                    <p>Caso não saiba o CEP do imóvel <a href="http://www.buscacep.correios.com.br/sistemas/buscacep/buscaCepEndereco.cfm" target="_blank">clique aqui.</a></p>
                    <div class="box-dica">
                        <div class="title">
                            <div class="ico"><img src="<?php e(base_url("assets/img/comdono/ico/ico-info-blue2.png"))?>" class="img-fluid"></div>
                            <div class="txt">#dicacomdono</div>
                        </div>
                        <p>O complemento é um elemento obrigatório e ajudará a filtrar melhor seu empreendimento nas buscas. Ele pode conter, por exemplo, o nome do condomínio, edifício ou residencial. Veja o exemplo abaixo:</p>
                        <p class="m-0"><strong>CEP:</strong> 70737-530</p>
                        <p class="m-0"><strong>Endereço:</strong> CLN 305 Bloco C</p>
                        <p class="m-0"><strong>Complemento:</strong> Copa Network</p>
                        <p class="m-0"><strong>Número:</strong> 305</p>
                        <p class="m-0"><strong>Bairro:</strong> Asa Norte</p>
                        <p class="m-0"><strong>Cidade:</strong> Brasília</p>
                        <p class="m-0"><strong>Estado:</strong> Distrito Federal</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 pl-40">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="content-subtitle">
                            <h3>Localização do imóvel</h3>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-3 col-md-3">
                        <div class="form-group">
                            <label for="cep">CEP*</label>
                            <input type="text" name="cep" class="form-control" id="cep" value="<?php e($imovel->cep); ?>">
                            <span class="info-cep"></span>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6">
                        <div class="form-group">
                            <label for="dn_endereco">Endereço*</label>
                            <input type="text" name="endereco" class="form-control" id="endereco" value="<?php e($imovel->endereco); ?>" readonly="readonly">
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3">
                        <div class="form-group">
                            <label for="end_numero">Número*</label>
                            <input type="text" name="numero" class="form-control" id="end_numero" value="<?php e($imovel->numero); ?>">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-6 col-md-6">
                        <div class="form-group">
                            <label for="end_complemento">Complemento*</label>
                            <input type="text" name="complemento" class="form-control" id="end_complemento" value="<?php e($imovel->complemento); ?>">
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6">
                        <div class="form-group">
                            <label for="bairro">Bairro*</label>
                            <input type="text" name="bairro" class="form-control" id="bairro" value="<?php e($imovel->bairro); ?>" readonly="readonly">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-6 col-md-6">
                        <div class="form-group">
                            <label for="dn_cidade">Cidade*</label>
                            <input type="text" name="cidade" class="form-control" id="dn_end_complemento" value="<?php e($imovel->cidade); ?>" readonly="readonly">
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6">
                        <div class="form-group">
                            <label for="dn_estado">Estado*</label>
                            <input type="text" name="estado" class="form-control" id="dn_estado" value="<?php e($imovel->estado); ?>" readonly="readonly">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--inicio step-4 -->
    <div class="step">
        <div class="row">
            <div class="col-lg-6 pr-40">
                <div class="container-info">
                    <div class="content-title">
                        <h2>Cadastro<span>de imóvel</span></h2>
                    </div>
                    <div class="box-dica">
                        <div class="title">
                            <div class="ico"><img src="<?php e(base_url("assets/img/comdono/ico/ico-info-blue2.png"))?>" class="img-fluid"></div>
                            <div class="txt">#dicacomdono</div>
                        </div>
                        <p>Existe uma margem de erro no GPS. Certifique-se de que o localizador do mapa ao lado está no endereço exato. Caso não esteja, você deverá movimentá-lo até a localização correta, <strong>como mostra o exemplo abaixo.</strong></p>
                        <div class="content-img">
                            <img src="<?php e(base_url("assets/img/comdono/gif/localizacao.gif")); ?>">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 pl-40">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="content-subtitle">
                            <h3>Seu imóvel no mapa</h3>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group m-0">
                            <input type="hidden" name="longitude" value="<?php e($imovel->longitude); ?>" >
                            <input type="hidden" name="latitude" value="<?php e($imovel->latitude); ?>" >
                            <input type="hidden" name="bairro_lat" value="<?php e($imovel->bairro_lat); ?>" >
                            <input type="hidden" name="bairro_long" value="<?php e($imovel->bairro_long); ?>" >
                            <input type="hidden" name="quadra_lat" value="<?php e($imovel->quadra_lat); ?>" >
                            <input type="hidden" name="quadra_long" value="<?php e($imovel->quadra_long); ?>" >
                            <input type="hidden" name="conjunto_lat" value="<?php e($imovel->conjunto_lat); ?>" >
                            <input type="hidden" name="conjunto_long" value="<?php e($imovel->conjunto_long); ?>" >
                            
                            <input type="hidden" class="confirma_local" name="confirma_local" value="true" >
                            
                            <input type="hidden" id="pac-input" class="controls" type="text" placeholder="">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="container-maps">
                                        <div id="map"></div>
                                        <div class="d-none">
                                            <div class="popup-confirmacao" id="popup-confirmacao">
                                                <div class="txt">O Pin está na localização correta?</div>
                                                <div class="row no-margin">
                                                    <div class="col-lg-6">
                                                        <button type="button" class="btn btn-primary confirmar-localizacao" >Confirmar</button>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <button type="button" class="btn btn-danger cancelar-localizacao" >Cancelar</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="container-info-mapa bg-green">
                                       Indique a localização de seu imóvel.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--inicio step-5 -->
    <div class="step">
        <div class="row">
            <div class="col-lg-6 pr-40">
                <div class="container-info">
                    <div class="content-title">
                        <h2>Cadastro<span>de imóvel</span></h2>
                    </div>
                    <p>Chegou a hora de inserir detalhes sobre o imóvel. Tenha a Certidão de Matrícula atualizada (de inteiro teor) em mãos para facilitar o preenchimento dos dados.</p>
                    <p>Com o número de matrícula é possível conferir as informações e histórico relativos ao imóvel que está à venda, bem como se o vendedor é realmente o responsável legal</p>
                    <div class="box-dica">
                        <div class="title">
                            <div class="ico"><img src="<?php e(base_url("assets/img/comdono/ico/ico-info-blue2.png"))?>" class="img-fluid"></div>
                            <div class="txt">#dicacomdono</div>
                        </div>
                        <p class="m-0">Caso não tenha o número de matrícula, faça o pedido online por meio do  <a href="https://cartorioregistrodeimoveis.com.br/" target="_blank">Cartório 24 Horas.</a></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 pl-40">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="content-subtitle">
                            <h3>Detalhes do Imóvel</h3>
                            <h3 class="cardsUnidades" ><?php e((count($imoveis_rel) > 0)? '<span class="countUnidades">'.(count($imoveis_rel)+1).'</span> Unidades':'');   ?></h3>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div id="accordion">
                            <div class="card <?php e(!empty($imoveis_rel) ? "":"border-none"); ?>">
                                <?php if(!empty($imoveis_rel)){ ?>
                                <div class="card-header unidade-show">
                                    <div class="row">
                                        <div class="col-10">
                                            <a class="card-link" data-toggle="collapse" href="#collapseOne">Unidade <?php e($imovel->complemento); ?></a>
                                        </div>
                                        <div class="col-2">
                                            <a data-toggle="collapse" class="icon-collapse f-right" href="#collapseOne" aria-expanded="true">
                                                <i class="fa" aria-hidden="true"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                                <div id="collapseOne" class="collapse show" data-parent="#accordion">
                                    <div class="card-body <?php e(!empty($imoveis_rel) ? "":"p-0"); ?>">
                                        <div class="row card-body-100">
                                            <div class="col col-md-12">
                                                <div class="form-group" >
                                                    <label for="tipo_imovel">Tipo de Imóvel*</label>
                                                    <select name="tipo_imovel" id="tipo_imovel" class="form-control tipo_imovel">
                                                        <option value="">Selecione</option>
                                                        <?php
                                                            foreach ($tiposImovel as $grupo=>$options)
                                                            {
                                                                echo("<optgroup label='$grupo'>");
                                                                foreach ($options as $value=>$text)
                                                                {
                                                                    $selected = '';
                                                                    if($value == $imovel->tipo_imovel)
                                                                        $selected = 'selected';
                                                                    echo("<option value='$value' $selected >$text</option>");
                                                                }
                                                                echo("</optgroup>");
                                                            }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row card-body-100">
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="area_privativa">Área privativa em m²*</label>
                                                    <input type="number" name="area_privativa" class="form-control " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" id="area_privativa" value="<?php e($imovel->area_privativa); ?>">
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="area_total">Área total em m²*</label>
                                                    <input type="number" name="area_total" class="form-control area_total" id="area_total" value="<?php e($imovel->area_total); ?>">
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="posicao_sol">Posição do sol</label>
                                                    <select name="posicao_sol" id="posicao_sol" class="form-control " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="">
                                                        <option value="">Selecione</option>
                                                        <option value="Nascente" <?php e($imovel->posicao_sol == "Nascente" ? "selected" : ""); ?>>Nascente</option>
                                                        <option value="Poente" <?php e($imovel->posicao_sol == "Poente" ? "selected" : ""); ?>>Poente</option>
                                                        <option value="Neutra" <?php e($imovel->posicao_sol == "Neutra" ? "selected" : ""); ?>>Neutra</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="andar">Andar*</label>
                                                    <input type="number" name="andar" class="form-control " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" id="andar" value="<?php e($imovel->andar == "" ? "1" : $imovel->andar); ?>">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="quartos">Quarto(s)*</label>
                                                    <input type="number" name="quartos" class="form-control " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" id="quartos" value="<?php e(($imovel->quartos == "" || $imovel->quartos == "0") ? "1" : $imovel->quartos); ?>" min="0" max="36">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="suites">Suíte(s)*</label>
                                                    <input type="number" name="suites" class="form-control " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" id="suites" value="<?php e($imovel->suites == "" ? "1" : $imovel->suites); ?>" min="0" max="36">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="banheiros">Banheiro(s)*</label>
                                                    <input type="number" name="banheiros" class="form-control " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" id="banheiros" value="<?php e(($imovel->banheiros == "" || $imovel->banheiros == "0") ? "1" : $imovel->banheiros); ?>" min="0" max="36">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="vaga">Vaga(s)*</label>
                                                    <input type="number" name="vaga" class="form-control " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" id="vaga" value="<?php e($imovel->vaga == "" ? "1" : $imovel->vaga); ?>" min="0" max="10">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row card-body-100">
                                            <div class="col-12 col-md-4 pr-0">
                                                <div class="form-group">
                                                    <label>Seu imóvel é de canto?</label>
                                                    <div class="container-input-radio">
                                                        <div class="custom-control custom-radio custom-control-inline">
                                                            <input type="radio" id="imovel_canto_sim" name="imovel_canto" class="custom-control-input " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" value="Sim"<?php e($imovel->imovel_canto == "Sim" ? "checked" : ""); ?>>
                                                            <label class="custom-control-label" for="imovel_canto_sim">Sim</label>
                                                        </div>
                                                        <div class="custom-control custom-radio custom-control-inline">
                                                            <input type="radio" id="imovel_canto_nao" name="imovel_canto" class="custom-control-input " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" value="Não"<?php e($imovel->imovel_canto == "Não" ? "checked" : ""); ?>>
                                                            <label class="custom-control-label" for="imovel_canto_nao">Não</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-8">
                                                <div class="form-group">
                                                    <label for="num_matricula">Número da matrícula registrada</label>
                                                    <input type="text" name="num_matricula" class="form-control " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" id="num_matricula" value="<?php e($imovel->num_matricula); ?>">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row card-body-100">
                                            <div class="col">
                                                <div class="content-subtitle">
                                                    <h3 class="m-10">Informe os valores</h3>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row card-body-100">
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="val_pretendido">Imóvel*</label></label>
                                                    <input type="text" name="val_pretendido" class="form-control maskMoney val_pretendido" id="val_pretendido" value="<?php e($imovel->val_pretendido); ?>">
                                                </div>
                                            </div>
                                            <div class="col-6 col-md-4">
                                                 <div class="form-group">
                                                    <label for="val_condominio">Condomínio/mês</label></label>
                                                    <input type="text" name="val_condominio" class="form-control maskMoney" id="val_condominio" value="<?php e($imovel->val_condominio); ?>">
                                                </div>
                                            </div>
                                            <div class="col-6 col-md-4">
                                                 <div class="form-group">
                                                    <label for="val_iptu">IPTU/ano</label></label>
                                                    <input type="text" name="val_iptu" class="form-control maskMoney" id="val_iptu" value="<?php e($imovel->val_iptu); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        
                            <?php $i = 1; foreach($imoveis_rel as $card) { ?>
                        
                            <div class="card cardsUnidades">
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-8">
                                            <a class="card-link collapsed" data-toggle="collapse" href="#collapse_<?php e($i); ?>">Unidade <?php e($card->complemento); ?></a>
                                        </div>
                                        <div class="col-3 p-0">
                                            <div class="container-button text-right">
                                                <button type="button" class="btn btn-remover btnRemoverUnidade"><i class="fa fa-times" aria-hidden="true"></i></button>
                                                <button type="button" class="btn btn-remover actRemoverUnidade d-none" data-id_imovel="<?php e($card->id_imovel);?>" >Remover?</button>
                                            </div>
                                        </div>
                                        <div class="col-1">
                                            <a data-toggle="collapse" class="icon-collapse f-right collapsed" href="#collapse_<?php e($i); ?>" aria-expanded="false"> 
                                                <i class="fa" aria-hidden="true"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div id="collapse_<?php e($i); ?>" class="collapse" data-parent="#accordion">
                                    <div class="card-body">
                                        <div class="row card-body-100">
                                            <div class="col">
                                                <div class="form-group" >
                                                    <label for="tipo_imovel">Tipo de Imóvel*</label>
                                                    <select id="tipo_imovel_<?php e($i);?>" class="form-control tipo_imovel_<?php e($i);?> autoSave"  data-id_imovel="<?php e($card->id_imovel);?>" data-name="tipo_imovel"  >
                                                        <option value="">Selecione</option>
                                                        <?php
                                                            foreach ($tiposImovel as $grupo=>$options)
                                                            {
                                                                echo("<optgroup label='$grupo'>");
                                                                foreach ($options as $value=>$text)
                                                                {
                                                                    $selected = '';
                                                                    if($value == $card->tipo_imovel)
                                                                        $selected = 'selected';
                                                                    echo("<option value='$value' $selected >$text</option>");
                                                                }
                                                                echo("</optgroup>");
                                                            }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row card-body-100">
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="area_privativa_<?php e($i); ?>">Área privativa em m²*</label>
                                                    <input type="text" class="form-control autoSave" data-id_imovel="<?php e($card->id_imovel);?>" data-name="area_privativa" id="area_privativa_<?php e($i); ?>" value="<?php e($card->area_privativa); ?>">
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="area_total_<?php e($i); ?>">Área total em m²</label>
                                                    <input type="text" class="form-control area_total autoSave" data-id_imovel="<?php e($card->id_imovel);?>" data-name="area_total" id="area_total_<?php e($i); ?>" value="<?php e($card->area_total); ?>">
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="posicao_sol_<?php e($i); ?>">Posição do sol</label>
                                                    <select  class="form-control autoSave" data-id_imovel="<?php e($card->id_imovel);?>" data-name="posicao_sol" id="posicao_sol_<?php e($i); ?>" >
                                                        <option value="">Selecione</option>
                                                        <option value="Nascente" <?php e($card->posicao_sol == "Nascente" ? "selected" : ""); ?>>Nascente</option>
                                                        <option value="Poente" <?php e($card->posicao_sol == "Poente" ? "selected" : ""); ?>>Poente</option>
                                                        <option value="Neutra" <?php e($card->posicao_sol == "Neutra" ? "selected" : ""); ?>>Neutra</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="andar_<?php e($i); ?>">Andar*</label>
                                                    <input type="number"  class="form-control autoSave" data-id_imovel="<?php e($card->id_imovel);?>" data-name="andar" id="andar_<?php e($i); ?>" value="<?php e($card->andar == "" ? "1" : $card->andar); ?>" min="1" max="36">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="quartos_<?php e($i); ?>">Quarto(s)*</label>
                                                    <input type="number"  class="form-control autoSave" data-id_imovel="<?php e($card->id_imovel);?>" data-name="quartos" id="quartos_<?php e($i); ?>" value="<?php e(($card->quartos == "" || $card->quartos == "0") ? "1" : $card->quartos); ?>" min="1" max="36">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="suites_<?php e($i); ?>">Suíte(s)*</label>
                                                    <input type="number" class="form-control autoSave" data-id_imovel="<?php e($card->id_imovel);?>" data-name="suites" id="suites_<?php e($i); ?>" value="<?php e($card->suites == "" ? "1" : $card->suites); ?>" min="1" max="36">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="banheiros_<?php e($i); ?>">Banheiro(s)*</label>
                                                    <input type="number" class="form-control autoSave" data-id_imovel="<?php e($card->id_imovel);?>" data-name="banheiros" id="banheiros_<?php e($i); ?>" value="<?php e(($card->banheiros == "" || $card->banheiros == "0") ? "1" : $card->banheiros); ?>" min="1" max="36">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="vaga_<?php e($i); ?>">Vaga(s)*</label>
                                                    <input type="number" class="form-control autoSave" data-id_imovel="<?php e($card->id_imovel);?>" data-name="vaga" id="vaga_<?php e($i); ?>" value="<?php e($card->vaga == "" ? "1" : $card->vaga); ?>" min="1" max="36">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row card-body-100">
                                            <div class="col-12 col-md-4 pr-0">
                                                <div class="form-group">
                                                    <label>Seu imóvel é de canto?</label>
                                                    <div class="container-input-radio">
                                                        <div class="custom-control custom-radio custom-control-inline">
                                                            <input type="radio" id="imovel_canto_sim_<?php e($i);?>"  class="custom-control-input autoSave" data-id_imovel="<?php e($card->id_imovel);?>" data-name="imovel_canto" value="Sim"<?php e($card->imovel_canto == "Sim" ? "checked" : ""); ?>>
                                                            <label class="custom-control-label" for="imovel_canto_sim_<?php e($i);?>">Sim</label>
                                                        </div>
                                                        <div class="custom-control custom-radio custom-control-inline">
                                                            <input type="radio" id="imovel_canto_nao_<?php e($i);?>" class="custom-control-input autoSave" data-id_imovel="<?php e($card->id_imovel);?>" data-name="imovel_canto" value="Não"<?php e($card->imovel_canto == "Não" ? "checked" : ""); ?>>
                                                            <label class="custom-control-label" for="imovel_canto_nao_<?php e($i);?>">Não</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-8">
                                                <div class="form-group">
                                                    <label for="num_matricula_<?php e($i);?>">Número da matrícula registrada</label>
                                                    <input type="text"  class="form-control autoSave" data-id_imovel="<?php e($card->id_imovel);?>" data-name="num_matricula" id="num_matricula_<?php e($i);?>" value="<?php e($card->num_matricula); ?>">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row card-body-100">
                                            <div class="col">
                                                <div class="content-subtitle">
                                                    <h3 class="m-10">Informe os valores</h3>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row card-body-100">
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="val_pretendido_<?php e($i); ?>">Imóvel*</label></label>
                                                    <input type="text"  class="form-control maskMoney val_pretendido autoSave" data-id_imovel="<?php e($card->id_imovel);?>" data-name="val_pretendido" id="val_pretendido_<?php e($i); ?>" value="<?php e($card->val_pretendido); ?>">
                                                </div>
                                            </div>
                                            <div class="col-6 col-md-4">
                                                 <div class="form-group">
                                                    <label for="val_condominio_<?php e($i); ?>">Condomínio/mês</label></label>
                                                    <input type="text"  class="form-control maskMoney autoSave" data-id_imovel="<?php e($card->id_imovel);?>" data-name="val_condominio" id="val_condominio_<?php e($i); ?>" value="<?php e($card->val_condominio); ?>">
                                                </div>
                                            </div>
                                            <div class="col-6 col-md-4">
                                                 <div class="form-group">
                                                    <label for="val_iptu_<?php e($i); ?>">IPTU/ano</label></label>
                                                    <input type="text"  class="form-control maskMoney autoSave" data-id_imovel="<?php e($card->id_imovel);?>" data-name="val_iptu" id="val_iptu_<?php e($i); ?>" value="<?php e($card->val_iptu); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php $i++; } ?>
                        </div>
                        <div class="form-group">
                            <div class="content-subtitle">
                                <h3 class="m-10"><?php e(($imovel->lancamento == "Sim" && $imovel->doc_perfil == "cnpj") ? "Incluir Memorial de incorporação" : "Documento do imóvel"); ?></h3>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="docPropSim <?php e(($imovel->lancamento == "Sim" && $imovel->doc_perfil == "cnpj") ? "d-block" : "d-none"); ?>">
                                    <p>Anexe abaixo o Alvará de Construção ou o Memorial de Incorporação do empreendimento. O upload do documento oferece maior segurança e é uma forma de garantir que apenas o responsável legal do imóvel faça a venda.</p> 
                                </div>
                                <div class="docPropNao <?php e(($imovel->lancamento == "Sim" && $imovel->doc_perfil == "cnpj") ? "d-none" : "d-block"); ?>">
                                    <p>Anexe abaixo o IPTU do imóvel. O upload do documento oferece maior segurança e é uma forma de garantir que apenas o dono do imóvel faça a venda.</p>
                                    <p>Caso não tenha o IPTU em mãos e o imóvel seja registrado no Distrito Federal, <a href="http://www.fazenda.df.gov.br/area.cfm?id_area=1539" target="_blank">clique aqui</a>.</p>
                                </div>
                            </div>
                            <div class="col-lg-12 mt-15 mb-30">
                                <div id="doc_propriedade_div" class="container-file custom-file container-doc-file">
                                    <input type="file" name="doc_propriedade" class="custom-file-input" id="doc_propriedade" data-value="<?php echo $imovel->doc_propriedade; ?>" value="">
                                    <label class="custom-file-label label-doc-file" for="customFile">
                                        <div class="row d-flex justify-content-center">
                                            <div class="col-lg-3 p-0">
                                                <div class="container-box-doc text-right <?php echo $imovel->doc_propriedade != "" ? "d-block" : "d-none"; ?>">
                                                    <div class="divDoc">
                                                        <?php 
                                                            if ($imovel->doc_propriedade != ""){
                                                                
                                                            $pdf = explode(".",$imovel->doc_propriedade);
                                                            
                                                            if (end($pdf) == "pdf"){
                                                        ?>
                                                        <img src="<?php e(base_url('themes/comdono/img/ico-file-pdf.png')); ?>">
                                                        
                                                        <?php } else { ?>
                                                        <img src="<?php e(base_url().'themes/comdono/img/ico-file-img.png'); ?>">
                                                        
                                                        <?php } } ?>
                                                    </div>
                                                </div>
                                                <div class="container-doc-load text-right d-none">
                                                    <i class="fa fa-circle-o-notch fa-spin"></i>
                                                </div>
                                                <div class="box-icons-doc text-right <?php echo $imovel->doc_propriedade != "" ? "d-none" : "d-block"; ?>">
                                                    <div class="ico arrow">
                								        <i class="material-icons">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                               <path fill="none" d="M0 0h24v24H0V0z"></path>
                                                               <path d="M4 12l1.41 1.41L11 7.83V20h2V7.83l5.58 5.59L20 12l-8-8-8 8z"></path>
                                                            </svg>
                                                        </i>
                								    </div>
                								    <div class="ico space">
                								        <i class="material-icons">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                               <path fill="none" d="M0 0h24v24H0V0z"></path>
                                                               <path d="M18 9v4H6V9H4v6h16V9h-2z"></path>
                                                            </svg>
                                                        </i>
                								    </div>
                                                </div>
        								    </div>
        								    <div class="col-lg-7 p-0">
        								        <div class="text">
        								            Clique ou arraste e solte <span>o documento</span>
        								        </div>
        								    </div>
    								    </div>
                                    </label>
                                </div>
                                <div class="container-remover">
                                    <div class="row d-flex justify-content-center">
                                        <div class="col-lg-3 p-0">
                                            <div class="box-act-remover-doc <?php echo $imovel->doc_propriedade != "" ? "d-block" : "d-none"; ?>">
                                                <a href="javascript:;" class="act-text act-remover-doc">Remover</a> 
                                                <a href="javascript:;" class="act-text act-pergunta-doc act-remover_doc" style="display: none;">Remover?</a>
                                            </div>
                                        </div><div class="col-lg-7 p-0"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--inicio step-6-->
    <div class="step">
        <div class="row">
            <div class="col-lg-6 pr-40">
                <div class="container-info">
                    <div class="content-title">
                        <h2>Cadastro<span>de imóvel</span></h2>
                    </div>
                    <div class="content-subtitle">
                        <h3>Nossa proposta pra você</h3>
                    </div>
                    
                    <p>A COMDONO é uma plataforma de marketing digital e cobra uma taxa de publicidade pré-fixada, que é calculada em cima do valor de venda.</p>
                    <p>Mas pode ficar tranquilo! O valor só será cobrado caso você venda o imóvel utilizando nossos serviços.</p>

                    <div class="row container-valor-pretendido boxValPretendido">
                        <div class="col-md-6 col-lg-6 bg-grey">
                            <div class="form-group">
                                <div class="text">Você recebe</div>
                                <input type="text" name="val_pretendido2" class="form-control maskMoney val_pretendido2" id="val_pretendido2" value="<?php e($imovel->val_pretendido-$imovel->val_public_total); ?>" readonly="readonly">
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-6 bg-green">
                            <div class="form-group">
                                <div class="text">Valor do anúncio</div>
                                <input type="text" name="val_public_total2" class="form-control maskMoney val_public_total2" id="val_public_total2" value="<?php e($imovel->val_pretendido); ?>" readonly="readonly">
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group form-inline m-0">
                        <label>Valor do anúncio por m²:</label>
                        <input type="hidden" name="val_public_total_metro" class="input-proposta form-control  val_public_total_metro" id="val_public_total_metro" value="<?php e($imovel->val_public_total_metro); ?>" readonly="readonly">
                        <input type="text" name="val_public_total_metro_html" class="input-proposta form-control maskMoney val_public_total_metro_html" id="val_public_total_metro_html" value="<?php e($imovel->val_public_total_metro); ?>" readonly="readonly">
                    </div>
                    <div class="form-group form-inline">
                        <label>Valor COMDONO:</label>
                        <input type="hidden" name="val_public_total" class="input-proposta form-control  val_public_total" id="val_public_total" value="<?php e($imovel->val_public_total); ?>" readonly="readonly">
                        <input type="text" name="val_public_total_html" class="input-proposta form-control maskMoney val_public_total_html" id="val_public_total_html" value="<?php e($imovel->val_public_total); ?>" readonly="readonly">
                    </div>
                </div>
            </div>
            <div class="col-lg-6 pl-40">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="content-subtitle">
                            <h3>Condições comerciais</h3>
                        </div>
                    </div>
                </div>
                <div class="form-group mb-30">
                    <label class="mb-10">Leia com atenção as condições comerciais e não se esqueça de marcar o box abaixo antes de continuar o cadastro.</label>
                    <div class="box-informativo border-termos">
                        <div class="container-texto mb-60">
                            <p>A minuta do COMDONO será enviada por e-mail e discutida pessoalmente em nossa sede.</p>
                            <p><strong>Endereço:</strong></p>
                            <p>CLN 305 Bloco C 1º Andar - ASA Norte - Brasília - DF</p>
                        </div>
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" name="chk_termo" class="custom-control-input" id="chk_termo" <?php e($imovel->chk_termo == "on" ? "checked" : ""); ?>>
                                <label class="custom-control-label" for="chk_termo">
                                    Li, aceito e concordo com os termos comerciais*
                                </label>
                            </div>
                        </div>
                    </div>
                    <div id="content-error" <?php e(($imovel->chk_termo == "on") ? "style='display: block;'" : "style='display: none;'"); ?>></div>
                </div>
            </div>
        </div>
    </div>
    <!--inicio step-7 -->
    <div class="step">
        <div class="row">
            <div class="col-lg-6 pr-40">
                <?php $texto = "Um imóvel perfeito para chamar de seu! Com <strong>três quartos</strong> e <strong>dois banheiros</strong>, este imóvel é ideal para quem busca um lar para a família. Tenha todo o conforto de <strong>dois andares bem distribuídos, amplos e com iluminação natural</strong>. <strong>Sente-se na varanda</strong> e aproveite a tranquilidade e calmaria desta localização."; ?>
                <div class="container-info">
                    <div class="content-title">
                        <h2>Cadastro<span>de imóvel</span></h2>
                    </div>
                    <p>A descrição é o lugar onde você pode agregar valor ao imóvel que deseja vender. Aproveite para contar um pouco sobre o que há no comércio ao redor e curiosidades sobre a vizinhança. Que tal fazer uma descrição mais personalizada contando da sua experiência neste imóvel?</p>
                    <p>Exemplo</p>
                    <p class="text-justify"><i><?php e($texto); ?></i></p>
                </div>
                <div class="form-group mb-20">
                    <label for="caracteristicas_imovel">Descreva seu imóvel abaixo</label>
                    <textarea class="form-control textminieditor" name="caracteristicas" rows="3"><?php e($imovel->caracteristicas); ?></textarea>
                </div>
            </div>
            <div class="col-lg-6 pl-40">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="content-subtitle">
                            <h3>Detalhes do imóvel</h3>
                        </div>
                    </div>
                </div>
                <div class="row container-detalhes-imovel">
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="cobertura_privativa" class="custom-control-input" id="cobertura_privativa" <?php e($imovel->cobertura_privativa == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="cobertura_privativa">Cobertura Privativa</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="ar_condicionado" class="custom-control-input" id="ar_condicionado" <?php e($imovel->ar_condicionado == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="ar_condicionado">Ar Condicionado</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="armarios_planejados" class="custom-control-input" id="armarios_planejados" <?php e($imovel->armarios_planejados == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="armarios_planejados">Armários Planejados</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="armarios_embutidos_quarto" class="custom-control-input" id="armarios_embutidos_quarto" <?php e($imovel->armarios_embutidos_quarto == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="armarios_embutidos_quarto">Armários Embutidos no Quarto</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="armarios_cozinha" class="custom-control-input" id="armarios_cozinha" <?php e($imovel->armarios_cozinha == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="armarios_cozinha">Armários de Cozinha</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="armarios_banheiro" class="custom-control-input" id="armarios_banheiro" <?php e($imovel->armarios_banheiro == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="armarios_banheiro">Armários no Banheiro</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="box_blindex" class="custom-control-input" id="box_blindex" <?php e($imovel->box_blindex == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="box_blindex">Box Blindex</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="quarto_servico" class="custom-control-input" id="quarto_servico" <?php e($imovel->quarto_servico == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="quarto_servico">Quarto de Serviço</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="quarto_extra_reversivel" class="custom-control-input" id="quarto_extra_reversivel" <?php e($imovel->quarto_extra_reversivel == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="quarto_extra_reversivel">Quarto Extra Reversível</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="varanda" class="custom-control-input" id="varanda" <?php e($imovel->varanda == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="varanda">Varanda Gourmet</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="dce" class="custom-control-input" id="dce" <?php e($imovel->dce == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="dce">DCE</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6"></div>
                </div>
                
                <div class="row box-detalhes-condominio">
                    <div class="col-lg-12">
                        <div class="content-subtitle">
                            <h3 class="mb-20 mt-20">Detalhes do condomínio</h3>
                        </div>
                    </div>
                </div>
                <div class="row container-detalhes-imovel box-detalhes-condominio">
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="academia" class="custom-control-input" id="academia" <?php e($imovel->academia == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="academia">Academia</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="churrasqueira" class="custom-control-input" id="churrasqueira" <?php e($imovel->churrasqueira == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="churrasqueira">Churrasqueira</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="elevador" class="custom-control-input" id="elevador" <?php e($imovel->elevador == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="elevador">Elevador</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="espaco_gourmet" class="custom-control-input" id="espaco_gourmet" <?php e($imovel->espaco_gourmet == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="espaco_gourmet">Espaço Gourmet</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="lavanderia" class="custom-control-input" id="lavanderia" <?php e($imovel->lavanderia == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="lavanderia">Lavanderia</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="piscina" class="custom-control-input" id="piscina" <?php e($imovel->piscina == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="piscina">Piscina</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="playground" class="custom-control-input" id="playground" <?php e($imovel->playground == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="playground">Playground</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="quadra_esportiva" class="custom-control-input" id="quadra_esportiva" <?php e($imovel->quadra_esportiva == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="quadra_esportiva">Quadra esportiva</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="salao_festa" class="custom-control-input" id="salao_festa" <?php e($imovel->salao_festa == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="salao_festa">Salão de Festas</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="sauna" class="custom-control-input" id="sauna" <?php e($imovel->sauna == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="sauna">Sauna</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="cobertura" class="custom-control-input" id="cobertura" <?php e($imovel->cobertura == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="cobertura">Cobertura</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="estacionamento_rotativo" class="custom-control-input" id="estacionamento_rotativo" <?php e($imovel->estacionamento_rotativo == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="estacionamento_rotativo">Estacionamento Rotativo</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="wifi" class="custom-control-input" id="wifi" <?php e($imovel->wifi == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="wifi">Wi-fi</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="porteiro_24h" class="custom-control-input" id="porteiro_24h" <?php e($imovel->porteiro_24h == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="porteiro_24h">Porteiro 24h</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="acessibilidade" class="custom-control-input" id="acessibilidade" <?php e($imovel->acessibilidade == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="acessibilidade">Acessibilidade</label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><!--fim etapa-2 -->