<!--inicio etapa-1 -->
<div class="etapa-1" data-title="Etapa 1 - Começando pelo básico">
    <!--inicio step-1 -->
    
    <div class="step" <?php e($step == 1 ? "style='display: block'":""); ?> >
        <div class="row">
            <div class="col-lg-6 pr-40">
                <div class="container-info">
                    <div class="content-title">
                        <?php if($textTitulo??false){
                            e("<h2>$textTitulo</h2>");
                        } else { ?>
                            <h2>Cadastro<span>de imóvel</span></h2>
                        <?php } ?>
                    </div>
                    <p>Chegou a hora de inserir detalhes sobre o imóvel. Tenha a Certidão de Matrícula atualizada (de inteiro teor) em mãos para facilitar o preenchimento dos dados.</p>
                    <p>Com o número de matrícula é possível conferir as informações e histórico relativos ao imóvel que está à venda, bem como se o vendedor é realmente o responsável legal</p>
                    <div class="box-dica">
                        <div class="title">
                            <div class="ico"><img src="<?php e(base_url("assets/img/comdono/ico/ico-info-blue2.png"))?>" class="img-fluid"></div>
                            <div class="txt">#dicacomdono</div>
                        </div>
                        <p class="m-0">Caso não tenha o número de matrícula, faça o pedido online por meio do  <a href="https://cartorioregistrodeimoveis.com.br/" target="_blank">Cartório 24 Horas.</a></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 pl-40">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="content-subtitle">
                            <h3>Detalhes do Imóvel</h3>
                            <h3 class="cardsUnidades" ><?php e((count($imoveis_rel) > 0)? '<span class="countUnidades">'.(count($imoveis_rel)+1).'</span> Unidades':'');   ?></h3>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div id="accordion">
                            <div class="card <?php e(!empty($imoveis_rel) ? "":"border-none"); ?>">
                                <?php if(!empty($imoveis_rel)){ ?>
                                <div class="card-header unidade-show">
                                    <div class="row">
                                        <div class="col-10">
                                            <a class="card-link" data-toggle="collapse" href="#collapseOne">Unidade <?php e($imovel->complemento); ?></a>
                                        </div>
                                        <div class="col-2">
                                            <a data-toggle="collapse" class="icon-collapse f-right" href="#collapseOne" aria-expanded="true">
                                                <i class="fa" aria-hidden="true"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                                <div id="collapseOne" class="collapse show" data-parent="#accordion">
                                    <div class="card-body <?php e(!empty($imoveis_rel) ? "":"p-0"); ?>">
                                        <div class="row card-body-100">
                                            <div class="col">
                                                <div class="form-group" >
                                                    <label for="tipo_imovel">Tipo de Imóvel*</label>
                                                    <select name="tipo_imovel" id="tipo_imovel" class="form-control tipo_imovel">
                                                        <option value="">Selecione</option>
                                                        <?php
                                                            foreach ($tiposImovel as $grupo=>$options)
                                                            {
                                                                echo("<optgroup label='$grupo'>");
                                                                foreach ($options as $value=>$text)
                                                                {
                                                                    $selected = '';
                                                                    if($value == $imovel->tipo_imovel)
                                                                        $selected = 'selected';
                                                                    echo("<option value='$value' $selected >$text</option>");
                                                                }
                                                                echo("</optgroup>");
                                                            }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row card-body-100">
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="area_privativa">Área privativa em m²*</label>
                                                    <input type="text" name="area_privativa" class="form-control " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" id="area_privativa" value="<?php e($imovel->area_privativa); ?>">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="area_total">Área total em m²*</label>
                                                    <input type="text" name="area_total" class="form-control area_total" id="area_total" value="<?php e($imovel->area_total); ?>">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="posicao_sol">Posição do sol</label>
                                                    <select name="posicao_sol" id="posicao_sol" class="form-control " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="">
                                                        <option value="">Selecione</option>
                                                        <option value="Nascente" <?php e($imovel->posicao_sol == "Nascente" ? "selected" : ""); ?>>Nascente</option>
                                                        <option value="Poente" <?php e($imovel->posicao_sol == "Poente" ? "selected" : ""); ?>>Poente</option>
                                                        <option value="Neutra" <?php e($imovel->posicao_sol == "Neutra" ? "selected" : ""); ?>>Neutra</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="andar">Andar*</label>
                                                    <input type="number" name="andar" class="form-control " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" id="andar" value="<?php e($imovel->andar == "" ? "1" : $imovel->andar); ?>">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="quartos">Quarto(s)*</label>
                                                    <input type="number" name="quartos" class="form-control " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" id="quartos" value="<?php e(($imovel->quartos == "" || $imovel->quartos == "0") ? "1" : $imovel->quartos); ?>" min="0" max="36">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="suites">Suíte(s)*</label>
                                                    <input type="number" name="suites" class="form-control " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" id="suites" value="<?php e($imovel->suites == "" ? "1" : $imovel->suites); ?>" min="0" max="36">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="banheiros">Banheiro(s)*</label>
                                                    <input type="number" name="banheiros" class="form-control " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" id="banheiros" value="<?php e(($imovel->banheiros == "" || $imovel->banheiros == "0") ? "1" : $imovel->banheiros); ?>" min="0" max="36">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="vaga">Vaga(s)*</label>
                                                    <input type="number" name="vaga" class="form-control " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" id="vaga" value="<?php e($imovel->vaga == "" ? "1" : $imovel->vaga); ?>" min="0" max="10">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row card-body-100">
                                            <div class="col-4 pr-0">
                                                <div class="form-group">
                                                    <label>Seu imóvel é de canto?</label>
                                                    <div class="container-input-radio">
                                                        <div class="custom-control custom-radio custom-control-inline">
                                                            <input type="radio" id="imovel_canto_sim" name="imovel_canto" class="custom-control-input " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" value="Sim"<?php e($imovel->imovel_canto == "Sim" ? "checked" : ""); ?>>
                                                            <label class="custom-control-label" for="imovel_canto_sim">Sim</label>
                                                        </div>
                                                        <div class="custom-control custom-radio custom-control-inline">
                                                            <input type="radio" id="imovel_canto_nao" name="imovel_canto" class="custom-control-input " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" value="Não"<?php e($imovel->imovel_canto == "Não" ? "checked" : ""); ?>>
                                                            <label class="custom-control-label" for="imovel_canto_nao">Não</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="num_matricula">Número da matrícula registrada</label>
                                                    <input type="text" name="num_matricula" class="form-control " data-id_imovel="<?php e($imovel->id_imovel);?>" data-name="" id="num_matricula" value="<?php e($imovel->num_matricula); ?>">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row card-body-100">
                                            <div class="col">
                                                <div class="content-subtitle">
                                                    <h3 class="m-10">Informe os valores</h3>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row card-body-100">
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="val_pretendido">Imóvel*</label></label>
                                                    <input type="text" name="val_pretendido" class="form-control maskMoney val_pretendido" id="val_pretendido" value="<?php e($imovel->val_pretendido); ?>">
                                                </div>
                                            </div>
                                            <div class="col">
                                                 <div class="form-group">
                                                    <label for="val_condominio">Condomínio/mês</label></label>
                                                    <input type="text" name="val_condominio" class="form-control maskMoney" id="val_condominio" value="<?php e($imovel->val_condominio); ?>">
                                                </div>
                                            </div>
                                            <div class="col">
                                                 <div class="form-group">
                                                    <label for="val_iptu">IPTU/ano</label></label>
                                                    <input type="text" name="val_iptu" class="form-control maskMoney" id="val_iptu" value="<?php e($imovel->val_iptu); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        
                            
                        </div>
                        
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="content-subtitle">
                            <h3>Detalhes do imóvel</h3>
                        </div>
                    </div>
                </div>
                <div class="row container-detalhes-imovel">
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="cobertura_privativa" class="custom-control-input" id="cobertura_privativa" <?php e($imovel->cobertura_privativa == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="cobertura_privativa">Cobertura Privativa</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="ar_condicionado" class="custom-control-input" id="ar_condicionado" <?php e($imovel->ar_condicionado == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="ar_condicionado">Ar Condicionado</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="armarios_planejados" class="custom-control-input" id="armarios_planejados" <?php e($imovel->armarios_planejados == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="armarios_planejados">Armários Planejados</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="armarios_embutidos_quarto" class="custom-control-input" id="armarios_embutidos_quarto" <?php e($imovel->armarios_embutidos_quarto == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="armarios_embutidos_quarto">Armários Embutidos no Quarto</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="armarios_cozinha" class="custom-control-input" id="armarios_cozinha" <?php e($imovel->armarios_cozinha == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="armarios_cozinha">Armários de Cozinha</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="armarios_banheiro" class="custom-control-input" id="armarios_banheiro" <?php e($imovel->armarios_banheiro == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="armarios_banheiro">Armários no Banheiro</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="box_blindex" class="custom-control-input" id="box_blindex" <?php e($imovel->box_blindex == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="box_blindex">Box Blindex</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="quarto_servico" class="custom-control-input" id="quarto_servico" <?php e($imovel->quarto_servico == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="quarto_servico">Quarto de Serviço</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="quarto_extra_reversivel" class="custom-control-input" id="quarto_extra_reversivel" <?php e($imovel->quarto_extra_reversivel == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="quarto_extra_reversivel">Quarto Extra Reversível</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="varanda" class="custom-control-input" id="varanda" <?php e($imovel->varanda == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="varanda">Varanda Gourmet</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="dce" class="custom-control-input" id="dce" <?php e($imovel->dce == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="dce">DCE</label>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6"></div>
                </div>
            </div>
        </div>
    </div>
</div>