<input type="hidden" name="id_imovel" value="<?php e($imovel->id_imovel); ?>">

<?php e($config->h1_strong_font_link); ?>

<style type="text/css" data-type="custom-css">

.btn-primary, .btn-primary.disabled, .btn-primary:disabled {
    background-color: <?php e($config->primeira_cor); ?>;
    border-color: <?php e($config->primeira_cor); ?>;
}
.btn-primary:hover, .btn-primary:active, .btn-primary:focus, .btn-primary:not(:disabled):not(.disabled).active, .btn-primary:not(:disabled):not(.disabled):active, .show > .btn-primary.dropdown-toggle {
    background-color: <?php e($config->segunda_cor); ?>;
    border-color: <?php e($config->segunda_cor); ?>;
}

.btn.disabled, .btn:disabled {
    opacity: .65;
}

.owl-carousel .owl-nav button.owl-next, .owl-carousel .owl-nav button.owl-prev {
    color: <?php e($config->primeira_cor); ?>;
}

.container-carousel .owl-theme .owl-nav [class*=owl-]:hover {
    color: <?php e($config->primeira_cor); ?>;
}

h4, .box-tour, .box-tour a, #section-unidades h3 strong, .container-page-lp .title h2 strong, .container-page-lp .title h2 p strong, .box-diferenciais .box-title {
    color: <?php e($config->primeira_cor); ?>!important;
}
h4 strong {
    font-weight: 700!important;
    color: <?php e($config->primeira_cor); ?>!important;
}
h1 {
    color: <?php e($config->segunda_cor); ?>!important;
}

h1 strong {
    font-weight: 700!important;
    color: <?php e(empty($config->h1_strong_color)?$config->segunda_cor:$config->h1_strong_color); ?>!important;
    <?php if(empty($config->h1_strong_font)){ ?>
    font-family: 'Montserrat', sans-serif;
    <?php }else{ ?>
    <?php e($config->h1_strong_font) ?>
    <?php } ?>
}
h3 strong {
    font-weight: 700!important;
    color: <?php e(empty($config->h3_strong_color)?$config->segunda_cor:$config->h3_strong_color); ?>!important;
}
hr.hr_header {
    border-top: 1px solid <?php e($config->hr_header_color); ?>;
    margin: 0 0 30px;
}
.box-info-header .logo img {
    max-height: <?php e($config->max_height_logo == 0 ? "150px":$config->max_height_logo."px"); ?>;
}

.box-tour a:hover {
    color: <?php e($config->segunda_cor); ?>;
}
#section-cta {
    background: <?php e(!empty($config->bg_cta) ? $config->bg_cta : $config->primeira_cor); ?>
}
a.btn.btn-cta {
    background: <?php e($config->primeira_cor); ?>;
    border: 2px solid <?php e($config->primeira_cor); ?>;
}
.owl-theme .owl-dots .owl-dot.active span, .owl-theme .owl-dots .owl-dot:hover span {
    background: <?php e($config->primeira_cor); ?>;
}
.box-produto .box-fotos {
    border: 2px solid <?php e($config->primeira_cor); ?>;
    color: <?php e($config->primeira_cor); ?>;
}
.box-produto .box-info strong {
    color: <?php e($config->primeira_cor); ?>!important;
    font-weight: 700;
}
.box-diferenciais .box-info strong, .box-diferenciais .box-info p strong  {
    color: <?php e($config->primeira_cor); ?>!important;
}
#section-contato .btn-primary {
    background-color: <?php e($config->segunda_cor); ?>;
    border-color: <?php e($config->segunda_cor); ?>;
    width: auto!important;
    padding: 8px 20px!important;
}
.box-diferenciais .box-ico i.material-icons, .box-selecione .value-reserva {
    color: <?php e($config->segunda_cor); ?>!important;
}

.box-bancos .title img {
    max-width: 150px;
}

@media (max-width: 767px){
    .container-header-mobile {
        background: rgba(60, 60, 60, 0.<?php e($config->bg_mobile == 0 ? 8:$config->bg_mobile); ?>)!important;
    }
    #section-contato .btn-primary {
        top: 0;
        width: 100%!important;
    }
}


</style>

<?php $config->img_lp = ($config->img_lp != "" ? $config->img_lp : $empreendimento->emp_logo); ?>

<!-----------INI Visualizar como admin-------------->
<?php if ($navAdmin??false){ ?>
<div class="container-alert">
    <div class="row">
        <div class="col-12 p-0">
            <div class="alert <?php e(HImovel::getStatus($imovel->status_lancamento)->bg); ?> alert-effect">
                <strong>Status: <?php e(HImovel::getStatus($imovel->status_lancamento)->text); ?>.</strong> 
                Visualização apenas para o dono e administradores. 
                <a href="javascript:;" class="btn btn-danger btn-sm" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span> Fechar notificação</a>
            </div>
        </div>
    </div>
</div>
<?php } ?>
    <!-----------END Visualizar como admin-------------->   
<div id="toTop" class="container-page-lp">
    <div class="row" style="background: <?php e($config->bg_topo); ?>">
        <div class="col-md-6 col-lg-6 d-none-767">
            <div class="d-flex h-100 height-center">
                <div class="box-info-header text-<?php e(empty($config->posicao_header)?"center":$config->posicao_header); ?>">
                    <?php if(!empty($config->titulo_apresentacao)){ ?>
                    <div class="title mb-4">
                        <h3><?php e($config->titulo_apresentacao); ?></h3>
                    </div>
                    <?php } ?>
                    <div class="logo mt-0">
                        <img src="<?php e($config->img_lp); ?>">
                    </div>
                    <div class="title">
                        <h1><?php e($config->titulo_h1); ?></h1>
                        <?php if($config->hr_header == 1){ ?><hr class="hr_header"><?php } ?>
                        <h3><?php e($config->titulo_h3); ?></h3>
                        <h4><?php e($config->titulo_h4); ?></h4>
                        <?php if($config->btn_unidade <=1){ ?>
                            <a href="#section-unidades" class="btn btn-cta linkAnchor effect-pulse mb-5">
                                <?php e($config->btn_unidade_option_txt == 1 && !empty($config->btn_unidade_txt) ?$config->btn_unidade_txt:"Conheça as unidades") ?>
                            </a>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-6 col-lg-6 p-0">
            <?php if($config->bg_topo_video){ ?>
            <div class="container-banner p-0">
                <video width="100%" height="100%" playsinline autoplay loop muted><source src="<?php e($config->bg_topo_video);?>" type="video/mp4"></video>
            </div>
            <?php } else{ ?>
            <div class="container-banner p-0" style="background-image: url('<?php e($imgCapa); ?>');"></div>
            <?php } ?>
            <div class="box-tour">
                <ul class="list-inline">
                    <li class="list-inline-item">
                        <a href="javascript:;" class="act-passeio-lp">
                            <span class="material-icons">camera_enhance</span> Fotos
                        </a>
                    </li>
                    <?php if(!empty($config->video)){ ?>
                    <li class="list-inline-item"> | </li>
                    <li class="list-inline-item">
                       <a data-fancybox="" data-type="iframe" data-src="<?php e($config->video) ?>" href="javascript:;">
                           <span class="material-icons">movie</span> Vídeo
                       </a>
                    </li>
                    <?php } ?>
                    <?php if(!empty($config->tour_3d)){ ?>
                    <li class="list-inline-item"> | </li>
                    <li class="list-inline-item">
                       <a data-fancybox="" data-type="iframe" data-src="<?php e($config->tour_3d) ?>" href="javascript:;">
                       <span class="material-icons">3d_rotation</span> Tour 3D
                       </a>
                    </li>
                    <?php } ?>
                </ul>
            </div>
            <div class="container-header-mobile">
                <div class="d-flex h-100 height-center">
                    <div class="box-info-header text-<?php e(empty($config->posicao_header)?"center":$config->posicao_header); ?>">
                        <?php if(!empty($config->titulo_apresentacao)){ ?>
                        <div class="title mb-4">
                            <h3><strong><?php e($config->titulo_apresentacao); ?></strong> </h3>
                        </div>
                        <?php } ?>
                        <div class="logo mt-0">
                            <img src="<?php e(!empty($config->img_mobile)?$config->img_mobile:$config->img_lp); ?>">
                        </div>
                        <div class="title">
                            <h1><?php e($config->titulo_h1); ?></h1>
                            <h3><?php e($config->titulo_h3); ?></h3>
                            <h4><?php e($config->titulo_h4); ?></h4>
                            
                            <?php if($config->btn_unidade <=1 && $config->btn_premium == 0){ ?>
                            <a href="#section-unidades" class="btn btn-cta linkAnchor effect-pulse mb-5">
                                <?php e($config->btn_unidade_option_txt == 1 && !empty($config->btn_unidade_txt) ?$config->btn_unidade_txt:"Conheça as unidades") ?>
                            </a>
                            <?php } ?>
                            
                            <?php if($config->btn_premium == 1){ ?>
                            <a href="tel:+5561994483087" class="btn btn-cta btn-success effect-pulse mb-2 actLigar" target="_blank" data-action="Atendimento especializado">
                                <i class="fa fa-phone" aria-hidden="true"></i> Ligar
                            </a>
                            <h3 class="text-center">Atendimento especializado</h3>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div id="section-cta" class="row d-flex justify-content-center sticky-top">
        <div class="col-lg-12 p-0"><?php e(empty($config->cta_header) || $config->cta_header == "<br>" ? "":$config->cta_header); ?> <a href="#section-unidades" class="linkAnchor"><?php e($config->cta_option_text == 1 && !empty($config->cta_titulo_link) ?$config->cta_titulo_link:"Saiba mais") ?> <i class="fa fa-chevron-down"></i></a></div>
    </div>
    
    <?php if($config->unidades && $config->tipo_display_unidades == 0){ ?>
    <div id="section-unidades" class="row d-flex justify-content-center section-page">
        <div class="col-lg-9">
            
            <?php if($empreendimento->uuid_empreendimento == 'jbn_i_jbn_c_8x7wd3' || $empreendimento->uuid_empreendimento == 'jbn_i_jbn_c_h2p5rn'){?>
            <!--- programa --->
            <div class="pb-4">
            <div class="card mb-5">
                <div class="card-body p-5">
                    <div class="text-center">
                        <img src="<?php e(getenv('MEDIA_URL'));?>/modules/comdono/images/logo-casa-verde-e-amarela.jpg" class="img-fluid">                    
                    </div>
                    <div class="text-center my-5">
                        <p>O programa é o antigo Minha Casa Minha Vida e reúne iniciativas habitacionais do Governo Federal.</p>
                        <p>Saiba em qual banco você terá a melhor análise de crédito imobiliário.</p>
                    </div>
                    <div class="text-center box-bancos">
                        <ul class="list-inline m-0">
                            <li class="list-inline-item title">
                                <img src="<?php e(getenv('MEDIA_URL'));?>/modules/comdono/images/logo-banco-caixa.jpg" class="img-fluid">
                            </li>
                            <li class="list-inline-item title">
                                <img src="<?php e(getenv('MEDIA_URL'));?>/modules/comdono/images/logo-banco-bb.jpg" class="img-fluid">
                           </li>
                        </ul>
                    </div>
                </div>
            </div>
            </div>
            <?php } ?>
            
            
            <div class="title">
                <h2 class="mb-2"><?php e($config->unidades_titulo); ?></h2>
                <h3 class="text-center mb-4"><?php e($config->unidades_subtitulo); ?></h3>
            </div>
            
            <!--sem carousel-->
            <div class="<?php e(count($config->unidades) <= 3 ? "d-none-767":"d-none"); ?>">
                <div class="row d-flex justify-content-center">
                    <?php foreach ($config->unidades as $key => $unidade){ ?>
                    
                    <div class="col-md-4">
                        <div class="box-produto">
                            
                                <?php $count = 1; if($unidade->img_tipo !== 0){ ?>
                                
                                <?php if($unidade->img_tipo == 1){ ?>
                                <div class="box-img loading-img border-img"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
                                <div class="show-imgs">
                                    <div class="container-carousel">
                                        <div class="owl-carousel-imagens owl-carousel owl-theme">
                                            <?php $i=1; $count = count($unidade->imagens); foreach ($unidade->imagens as $img){ if($i > 3) break; ?>
                                            <a data-fancybox="images_<?php e($unidade->id_unidade) ?>" href="<?php e($img->uri.$img->imagem); ?>">
                                                <div class="box-img" style="background-image: url('<?php e($img->uri.$img->imagem); ?>');"></div>
                                            </a>
                                        <?php $i++; } ?>
                                        </div>
                                    </div>
                                </div>
                                <?php } elseif($unidade->img_tipo == 2){ ?>
                                <div class="d-block">
                                    <a data-fancybox="images_<?php e($unidade->id_unidade) ?>" href="<?php e($unidade->img_url);?>">
                                        <div class="box-img" style="background-image: url('<?php e($unidade->thumb);?>');"></div>
                                    </a>
                                </div>
                                <?php } ?>
                                
                                <?php }else{ ?>
                                <div class="show-imgs d-block">
                                <div class="box-img" style="background-image: url('<?php e(base_url("themes/comdono/img/no-image.png"));?>');"></div>
                                </div>
                                <?php } ?>
                            
                            
                            <?php if($unidade->img_tipo == 1){ ?>
                            <button type="button" data-unidade="<?php e($unidade->img);?>" class="box-fotos actVejaFotos cursor-pointer effect-pulse">Veja as fotos</button>
                            <?php } ?>
                            
                            <div class="box-title"><?php e($unidade->tipo); ?><?php if(!empty($unidade->metros)){ ?><span><?php e($unidade->metros); ?>m²</span><?php } ?></div>
                            <div class="box-icons">
                                <ul class="list-inline">
                                    <?php if(!empty($unidade->ambientes)){ ?> 
                                    <li class="list-inline-item">
                                        <span class="material-icons"></span>
                                        <?php e($unidade->ambientes); e($unidade->ambientes > 1 ? " Ambientes" : " Ambiente"); ?>
                                    </li>
                                    <?php } ?> 
                                    <?php if(!empty($unidade->quartos)){ ?> 
                                    <li class="list-inline-item">
                                        <span class="material-icons">local_hotel</span>
                                        <?php e($unidade->quartos); e($unidade->quartos > 1 ? " Quartos" : " Quarto"); ?>
                                    </li>
                                    <?php } ?> 
                                    <?php if(!empty($unidade->suites)){ ?> 
                                    <li class="list-inline-item">
                                        <span class="separator">|</span>
                                        <span class="material-icons">bathtub</span>
                                        <?php e($unidade->suites); e($unidade->suites > 1 ? " Suítes" : " Suíte"); ?> 
                                    </li>
                                    <?php } ?> 
                                    <?php if(!empty($unidade->banheiros)){ ?> 
                                    <li class="list-inline-item">
                                        <span class="separator">|</span>
                                        <span class="material-icons">bathtub</span>
                                        <?php e($unidade->banheiros); e($unidade->banheiros > 1 ? " Banheiros" : " Banheiro"); ?> 
                                    </li>
                                    <?php } ?> 
                                    <?php if(!empty($unidade->vagas)){ ?> 
                                    <li class="list-inline-item">
                                        <span class="separator">|</span>
                                        <span class="material-icons">directions_car</span>
                                        <?php e($unidade->vagas); e($unidade->vagas > 1 ? " Vagas" : " Vaga"); ?> 
                                    </li>
                                    <?php } ?> 
                                </ul>
                            </div>
                            
                            <?php if($unidade->tipo_valor == 0 || $unidade->tipo_valor == 1){ ?>
                            <div class="box-info height-auto"></div>
                            <?php } ?>
                            <?php if($unidade->tipo_valor == 2 ){ ?>
                            <div class="box-info height-auto"><strong><?php HValorFormat::exibe($unidade->valor); ?></strong></div>
                            <?php } ?>
                            <?php if($unidade->tipo_valor == 3 ){ ?>
                            <div class="box-info"><?php e($unidade->texto_valor); ?></div>
                            <?php } ?>
                            
                            <div class="box-cta">
                                <?php if($config->unidades_btn_option_txt != 2){ ?>
                                <?php if($unidade->status==1){ ?>
                                <button type="button" class="btn btn-primary w-auto actReservar addToCart" data-tipo="<?php e($unidade->tipo); e(!empty($unidade->metros)? " - ".$unidade->metros."m²":"") ?>" data-valor="<?php e($unidade->valor); ?>" data-txt_btn="<?php e($config->unidades_btn_option_txt == 1 && !empty($config->unidades_btn_txt) ?$config->unidades_btn_txt:"Gostei") ?>" >
                                    <?php e($config->unidades_btn_option_txt == 1 && !empty($config->unidades_btn_txt) ?$config->unidades_btn_txt:"Gostei") ?>
                                </button>
                                <?php }else{ ?>
                                <button type="button" class="btn btn-primary w-auto" disabled>Indisponível</button>
                                <?php } ?>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>
            
            <!--com carousel-->
            <div class="container-carousel <?php e(count($config->unidades) <= 3 ? "d-block-767":"d-block"); ?>">
                <div class="d-block">
                    <div class="owl-carousel-unidades owl-carousel owl-theme">
                        <?php foreach ($config->unidades as $key => $unidade){ ?>
                        <div class="box-produto">
                            <?php $count = 1; if($unidade->img_tipo !== 0){ ?>
                            <?php if($unidade->img_tipo == 1){ ?>
                            <div class="box-img loading-img border-img"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
                            <div class="show-imgs">
                                <div class="container-carousel">
                                    <div class="owl-carousel-imagens owl-carousel owl-theme">
                                        <?php $i=1; $count = count($unidade->imagens); foreach ($unidade->imagens as $img){ if($i > 3) break; ?>
                                        <a data-fancybox="images_2_<?php e($unidade->id_unidade) ?>" href="<?php e($img->uri.$img->imagem); ?>">
                                            <div class="box-img" style="background-image: url('<?php e($img->uri.$img->imagem); ?>');"></div>
                                        </a>
                                    <?php $i++; } ?>
                                    </div>
                                </div>
                            </div>
                            <?php } elseif($unidade->img_tipo == 2){ ?>
                            <div class="d-block">
                                <a data-fancybox="images_2_<?php e($unidade->id_unidade) ?>" href="<?php e($unidade->img_url);?>">
                                    <div class="box-img" style="background-image: url('<?php e($unidade->img_url);?>');"></div>
                                </a>
                            </div>
                            <?php } ?>
                            
                            <?php }else{ ?>
                            <div class="d-block">
                                <div class="box-img" style="background-image: url('<?php e(base_url("themes/comdono/img/no-image.png"));?>');"></div>
                            </div>
                            <?php } ?>
                            
                            <?php if($unidade->img_tipo == 1){ ?>
                            <button type="button" data-unidade="<?php e($unidade->img);?>" class="box-fotos actVejaFotos cursor-pointer effect-pulse">Veja as fotos</button>
                            <?php } ?>
                            
                            <div class="box-title"><?php e($unidade->tipo); ?><span><?php if(!empty($unidade->metros)){ ?><?php e($unidade->metros); ?>m²</span><?php } ?></div>
                            <div class="box-icons">
                                <ul class="list-inline">
                                    <?php if(!empty($unidade->ambientes)){ ?> 
                                    <li class="list-inline-item">
                                        <span class="material-icons"></span>
                                        <?php e($unidade->ambientes); e($unidade->ambientes > 1 ? " Ambientes" : " Ambiente"); ?>
                                    </li>
                                    <?php } ?> 
                                    <?php if(!empty($unidade->quartos)){ ?> 
                                    <li class="list-inline-item">
                                        <span class="material-icons">local_hotel</span>
                                        <?php e($unidade->quartos); e($unidade->quartos > 1 ? " Quartos" : " Quarto"); ?>
                                    </li>
                                    <?php } ?> 
                                    <?php if(!empty($unidade->suites)){ ?> 
                                    <li class="list-inline-item">
                                        <span class="separator">|</span>
                                        <span class="material-icons">bathtub</span>
                                        <?php e($unidade->suites); e($unidade->suites > 1 ? " Suítes" : " Suíte"); ?> 
                                    </li>
                                    <?php } ?> 
                                    <?php if(!empty($unidade->banheiros)){ ?> 
                                    <li class="list-inline-item">
                                        <span class="separator">|</span>
                                        <span class="material-icons">bathtub</span>
                                        <?php e($unidade->banheiros); e($unidade->banheiros > 1 ? " Banheiros" : " Banheiro"); ?> 
                                    </li>
                                    <?php } ?> 
                                    <?php if(!empty($unidade->vagas)){ ?> 
                                    <li class="list-inline-item">
                                        <span class="separator">|</span>
                                        <span class="material-icons">directions_car</span>
                                        <?php e($unidade->vagas); e($unidade->vagas > 1 ? " Vagas" : " Vaga"); ?> 
                                    </li>
                                    <?php } ?> 
                                </ul>
                            </div>
                            
                            <?php if($unidade->tipo_valor == 0 || $unidade->tipo_valor == 1){ ?>
                            <div class="box-info height-auto"></div>
                            <?php } ?>
                            <?php if($unidade->tipo_valor == 2 ){ ?>
                            <div class="box-info height-auto"><strong><?php HValorFormat::exibe($unidade->valor); ?></strong></div>
                            <?php } ?>
                            <?php if($unidade->tipo_valor == 3 ){ ?>
                            <div class="box-info"><?php e($unidade->texto_valor); ?></div>
                            <?php } ?>
                            
                            <div class="box-cta">
                                <?php if($config->unidades_btn_option_txt != 2){ ?>
                                <?php if($unidade->status==1){ ?>
                                <button type="button" class="btn btn-primary w-auto actReservar addToCart" data-tipo="<?php e($unidade->tipo); e(!empty($unidade->metros)? " - ".$unidade->metros."m²":"") ?>" data-valor="<?php e($unidade->valor); ?>" data-txt_btn="<?php e($config->unidades_btn_option_txt == 1 && !empty($config->unidades_btn_txt) ?$config->unidades_btn_txt:"Gostei") ?>" >
                                    <?php e($config->unidades_btn_option_txt == 1 && !empty($config->unidades_btn_txt) ?$config->unidades_btn_txt:"Gostei") ?>
                                </button>
                                <?php }else{ ?>
                                <button type="button" class="btn btn-primary w-auto" disabled>Indisponível</button>
                                <?php } ?>
                                <?php } ?>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
    
    <?php if($config->unidades && $config->tipo_display_unidades == 1){ ?>
    <div id="section-unidades" class="row d-flex justify-content-center section-page">
        <div class="col-lg-9">
            <div class="title">
                <h2 class="mb-2"><?php e($config->unidades_titulo); ?></h2>
                <h3 class="text-center mb-4"><?php e($config->unidades_subtitulo); ?></h3>
            </div>
            <div class="row d-flex justify-content-center container-display-antes-depois">
            <div class="col-lg-9">
            <div class="row">
                <div class="col-lg-12">
                    <div class="box-produto">
                        <div class="box-display mb-0">
                            <div class="container-carousel">
                                <div class="owl-carousel-imagens owl-carousel owl-theme">
                                    <div class="twentytwenty-container">
                                        <img src="<?php e(getenv('MEDIA_URL'));?>/modules/comdono/lp/liberty/images/antes_depois/1_a_sala_cozinha.jpg" />
                                        <img src="<?php e(getenv('MEDIA_URL'));?>/modules/comdono/lp/liberty/images/antes_depois/1_d_sala_cozinha.jpg" />
                                    </div>
                                    <div class="twentytwenty-container">
                                        <img src="<?php e(getenv('MEDIA_URL'));?>/modules/comdono/lp/liberty/images/antes_depois/1_a_sala_cozinha.jpg" />
                                        <img src="<?php e(getenv('MEDIA_URL'));?>/modules/comdono/lp/liberty/images/antes_depois/1_d_sala_cozinha.jpg" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row m-0">
                            <div class="col-lg-7">
                                <div class="box-title text-left mb-1 mt-3">Unidade 209 Torre 3 - Studio <strong>25,21m²</strong></div>
                                <div class="box-info text-left">
                                    entrada a partir de 20% + parcelas a partir de <strong>R$ 1.493,97</strong><br>
                                    à vista por <strong>R$ 226.890,00</strong>
                                </div>
                            </div>
                            <div class="col-lg-5 d-flex align-items-center">
                                <div class="box-cta mb-0 ml-auto">
                                    <button type="button" class="btn btn-primary w-auto actReservar addToCart m-0" data-tipo="" data-valor="">Saber mais</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php for($i=1;$i<=2;$i++){ ?>
                <div class="col-lg-6">
                    <div class="box-produto">
                        <div class="box-img mb-0" style="background-image: url('<?php e(getenv('MEDIA_URL'));?>/modules/comdono/lp/liberty/images/antes_depois/1_a_sala_cozinha.jpg');"></div>
                        
                        <div class="box-title text-left mb-1 mt-3 pt-0 p-2">Unidade 209 Torre 3 - Studio <strong>25,21m²</strong></div>
                        <div class="box-info text-left pt-0 p-2">
                            entrada a partir de 20%<br>
                            + parcelas a partir de <strong>R$ 1.493,97</strong><br>
                            à vista por <strong>R$ 226.890,00</strong>
                        </div>
                    
                        <div class="box-cta"><button type="button" class="btn btn-primary btn-display actReservar addToCart w-auto" data-tipo="" data-valor="">Saber mais</button></div>
                    </div>
                </div>
                <?php } ?>
            </div>
            </div>
            </div>
        </div>
    </div>
    <?php } ?>
    
    <?php if($empreendimento->uuid_empreendimento == 'rivie_base_0k921f' || $empreendimento->uuid_empreendimento == 'rivie_base_fvgpz6'){?>
    <!--- INFOGRAFICO --->
    <div class="row d-flex justify-content-center section-page">
        <div class="col-lg-9">
            <div class="title">
                <h2 class="mb-2">Acompanhe o progresso da obra</h2>
                <h3 class="text-center mb-4">Junho/2021</h3>
            </div>
            <?php 
                $projeto     = 72;
                $escavacao   = 100;
                $fundacao    = 92;
                $estrutura   = 40;
                $alvenaria   = 5;
                $instalacoes = 6;
                $acabamento  = 0;
                $urbanizacao = 0;
            ?>
            <div class="row">
                <div class="col-6 col-md-3 text-center">
                    <div class="single-chart-none">
                        <svg viewBox="0 0 36 36" class="circular-chart <?= $projeto > 0 ?'color-custom':''; ?>">
                        <path class="circle-bg"
                        d="M18 2.0845
                        a 15.9155 15.9155 0 0 1 0 31.831
                        a 15.9155 15.9155 0 0 1 0 -31.831"
                        />
                        <path class="circle"
                        stroke-dasharray="<?= $projeto; ?>, 100"
                        d="M18 2.0845
                        a 15.9155 15.9155 0 0 1 0 31.831
                        a 15.9155 15.9155 0 0 1 0 -31.831"
                        />
                        <text x="18" y="20.35" class="percentage"><?= $projeto; ?>%</text>
                        </svg>
                    </div>
                    <h4><strong>Projeto</strong></h4>
                </div>
                <div class="col-6 col-md-3 text-center">
                    <div class="single-chart-none">
                        <svg viewBox="0 0 36 36" class="circular-chart <?= $escavacao > 0 ?'color-custom':''; ?>">
                        <path class="circle-bg"
                        d="M18 2.0845
                        a 15.9155 15.9155 0 0 1 0 31.831
                        a 15.9155 15.9155 0 0 1 0 -31.831"
                        />
                        <path class="circle"
                        stroke-dasharray="<?= $escavacao; ?>, 100"
                        d="M18 2.0845
                        a 15.9155 15.9155 0 0 1 0 31.831
                        a 15.9155 15.9155 0 0 1 0 -31.831"
                        />
                        <text x="18" y="20.35" class="percentage"><?= $escavacao; ?>%</text>
                        </svg>
                    </div>
                    <h4><strong>Escavação</strong></h4>
                </div>
                <div class="col-6 col-md-3 text-center">
                    <div class="single-chart-none">
                        <svg viewBox="0 0 36 36" class="circular-chart <?= $fundacao > 0 ?'color-custom':''; ?>">
                        <path class="circle-bg"
                        d="M18 2.0845
                        a 15.9155 15.9155 0 0 1 0 31.831
                        a 15.9155 15.9155 0 0 1 0 -31.831"
                        />
                        <path class="circle"
                        stroke-dasharray="<?= $fundacao; ?>, 100"
                        d="M18 2.0845
                        a 15.9155 15.9155 0 0 1 0 31.831
                        a 15.9155 15.9155 0 0 1 0 -31.831"
                        />
                        <text x="18" y="20.35" class="percentage"><?= $fundacao; ?>%</text>
                        </svg>
                    </div>
                    <h4><strong>Fundação</strong></h4>
                </div>
                <div class="col-6 col-md-3 text-center">
                    <div class="single-chart-none">
                        <svg viewBox="0 0 36 36" class="circular-chart <?= $estrutura > 0 ?'color-custom':''; ?>">
                        <path class="circle-bg"
                        d="M18 2.0845
                        a 15.9155 15.9155 0 0 1 0 31.831
                        a 15.9155 15.9155 0 0 1 0 -31.831"
                        />
                        <path class="circle"
                        stroke-dasharray="<?= $estrutura; ?>, 100"
                        d="M18 2.0845
                        a 15.9155 15.9155 0 0 1 0 31.831
                        a 15.9155 15.9155 0 0 1 0 -31.831"
                        />
                        <text x="18" y="20.35" class="percentage"><?= $estrutura; ?>%</text>
                        </svg>
                    </div>
                    <h4><strong>Estrutura</strong></h4>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-6 col-md-3 text-center">
                    <div class="single-chart-none">
                        <svg viewBox="0 0 36 36" class="circular-chart <?= $alvenaria > 0 ?'color-custom':''; ?>">
                        <path class="circle-bg"
                        d="M18 2.0845
                        a 15.9155 15.9155 0 0 1 0 31.831
                        a 15.9155 15.9155 0 0 1 0 -31.831"
                        />
                        <path class="circle"
                        stroke-dasharray="<?= $alvenaria; ?>, 100"
                        d="M18 2.0845
                        a 15.9155 15.9155 0 0 1 0 31.831
                        a 15.9155 15.9155 0 0 1 0 -31.831"
                        />
                        <text x="18" y="20.35" class="percentage"><?= $alvenaria; ?>%</text>
                        </svg>
                    </div>
                    <h4><strong>Alvenaria</strong></h4>
                </div>
                <div class="col-6 col-md-3 text-center">
                    <div class="single-chart-none">
                        <svg viewBox="0 0 36 36" class="circular-chart <?= $instalacoes > 0 ?'color-custom':''; ?>">
                        <path class="circle-bg"
                        d="M18 2.0845
                        a 15.9155 15.9155 0 0 1 0 31.831
                        a 15.9155 15.9155 0 0 1 0 -31.831"
                        />
                        <path class="circle"
                        stroke-dasharray="<?= $instalacoes; ?>, 100"
                        d="M18 2.0845
                        a 15.9155 15.9155 0 0 1 0 31.831
                        a 15.9155 15.9155 0 0 1 0 -31.831"
                        />
                        <text x="18" y="20.35" class="percentage"><?= $instalacoes; ?>%</text>
                        </svg>
                    </div>
                    <h4><strong>Instalações</strong></h4>
                </div>
                <div class="col-6 col-md-3 text-center">
                    <div class="single-chart-none">
                        <svg viewBox="0 0 36 36" class="circular-chart <?= $acabamento > 0 ?'color-custom':''; ?>">
                        <path class="circle-bg"
                        d="M18 2.0845
                        a 15.9155 15.9155 0 0 1 0 31.831
                        a 15.9155 15.9155 0 0 1 0 -31.831"
                        />
                        <path class="circle"
                        stroke-dasharray="<?= $acabamento; ?>, 100"
                        d="M18 2.0845
                        a 15.9155 15.9155 0 0 1 0 31.831
                        a 15.9155 15.9155 0 0 1 0 -31.831"
                        />
                        <text x="18" y="20.35" class="percentage"><?= $acabamento; ?>%</text>
                        </svg>
                    </div>
                    <h4><strong>Acabamento</strong></h4>
                </div>
                <div class="col-6 col-md-3 text-center">
                    <div class="single-chart-none">
                        <svg viewBox="0 0 36 36" class="circular-chart <?= $urbanizacao > 0 ?'color-custom':''; ?>">
                        <path class="circle-bg"
                        d="M18 2.0845
                        a 15.9155 15.9155 0 0 1 0 31.831
                        a 15.9155 15.9155 0 0 1 0 -31.831"
                        />
                        <path class="circle"
                        stroke-dasharray="<?= $urbanizacao; ?>, 100"
                        d="M18 2.0845
                        a 15.9155 15.9155 0 0 1 0 31.831
                        a 15.9155 15.9155 0 0 1 0 -31.831"
                        />
                        <text x="18" y="20.35" class="percentage"><?= $urbanizacao; ?>%</text>
                        </svg>
                    </div>
                    <h4><strong>Urbanização</strong></h4>
                </div>
            </div>
        </div> 
    </div>
    <?php } ?>
    
    <div id="section-contato" class="row d-flex justify-content-center section-page">
        <div class="col-lg-12">
            <div class="row d-flex justify-content-center">
                <div class="col-lg-9">
                    <div class="row">
                        <div class="col-md-6 col-lg-7">
                            <div class="container-text mb-4">
                                <div class="title">
                                    <h2 class="mb-4"><?php e($config->form_titulo); ?></h2>
                                </div>
                                <?php e($config->form_descricao); ?>
                            </div>
                            <div class="row">
                                <div class="col-lg-8">
                                    <form id="<?php e('form_'.$empreendimento->uuid_empreendimento);?>" class="formCaptura" action="" method="post" autocomplete="off">
                                        <?php if($config->unidades_btn_option_txt != 2){ ?>
                                        <div class="form-group mb-4">
                                            <div class="box-selecione">
                                                <span class="selecionar selecionar-unidade">Selecione uma opção <i class="material-icons">arrow_upward</i></span>
                                                <span class="selecionado d-none">Selecionado: <span class="value-reserva"></span> <i class="material-icons icon-close">close</i></span>
                                            </div>
                                        </div>
                                        <div class="form-group mb-4">
                                            <label class="mb-2">Opção</label>
                                            <input type="text" name="tipo_imovel" class="form-control selecionar-unidade" placeholder="Sua opção preferida" required="required" readonly="readonly">
                                        </div>
                                        <?php } ?>
                                        <div class="form-group mb-4">
                                            <label class="mb-2">Nome completo</label>
                                            <input type="text" name="nome" class="form-control" placeholder="Nome" required="required">
                                            <input type="hidden" name="valor_avaliacao" value="">
                                            <input type="hidden" name="origem_captura" value="<?php e($empreendimento->uuid_empreendimento)?>">
                                            <input type="hidden" name="link" value="<?php e($link)?>">
                                        </div>
                                        <div class="form-group mb-4">
                                            <label class="mb-2">Seu melhor e-mail</label>
                                            <input type="email" name="email" class="form-control" placeholder="exemplo@email.com" required="required">
                                        </div>
                                        <div class="form-group mb-4">
                                            <label class="mb-2">Telefone/Whatsapp</label>
                                            <input type="text" name="telefone" class="form-control celular" placeholder="Seu whatsapp" required="required">
                                        </div>
                                        <div class="form-group mb-4">
                                            <label class="campos-obrigatorios">Todos os campos são obrigatórios</label>
                                            <div class="text-right">
                                                <?php if($empreendimento->uuid_empreendimento == 'jbn_i_jbn_c_8x7wd3' || $empreendimento->uuid_empreendimento == 'jbn_i_jbn_c_h2p5rn'){?>
                                                <button type="submit" class="btn btn-primary btn-enviar">Agendar consultoria</button>
                                                <?php }else{ ?>
                                                <button type="submit" class="btn btn-primary btn-enviar">Agendar visita</button>
                                                <?php } ?>
                                            </div>
                                            
                                        </div>
                                        <div class="content_result"></div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-5 text-center d-none-767">
                            <div class="h-100 d-flex align-items-center">
                            <?php if($config->form_imagem != ""){ ?>
                            <img src="<?php e($config->form_imagem); ?>" class="img-fluid m-auto">
                            <?php }else{ ?>
                            <img src="<?php e(getenv('MEDIA_URL'));?>/modules/comdono/lp/images/cartao-vip-comdono.png" class="img-fluid m-auto">
                            <?php } ?>
                            </div> 
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php if($config->diferenciais){ ?>
    <div id="section-diferenciais" class="row d-flex justify-content-center section-page pb-5 bg-grey">
        <div class="col-md-12 col-lg-9 text-center">
            <div class="title">
                <h2><?php e($config->diferenciais_titulo); ?></h2>
            </div>
            <div class="row d-flex justify-content-center">
                <?php foreach ($config->diferenciais as $key => $diferenciais){ ?>
                <div class="col-6 col-md-4">
                    <div class="box-diferenciais">
                        <div class="box-ico d-flex align-items-center justify-content-center"><i class="material-icons"><?php e($diferenciais->icone); ?></i></div>
                        <div class="box-title d-flex align-items-center justify-content-center"><?php e($diferenciais->titulo); ?></div>
                        <div class="box-info"><?php e($diferenciais->descricao); ?></div>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <?php } ?>
    
    <?php $qtdC = 4; if($config->comodidades){ ?>
    <div id="section-comodidades" class="row d-flex justify-content-center section-page">
        <div class="col-md-12 col-lg-9 text-center">
            <div class="title">
                <h2 class="mb-2"><?php e($config->comodidades_titulo); ?></h2>
                <h3 class="text-center mb-4"><?php e($config->comodidades_subtitulo); ?></h3>
            </div>
            <div class="<?php e(count($config->comodidades) <= $qtdC ? "d-none-767":"d-none"); ?>">
                <div class="container-comodidade mt-5">
                    <div class="row d-flex justify-content-center align-items-center">
                        <?php foreach ($config->comodidades as $key => $comodidade){ ?>
                        <?php if($comodidade->status == 1){ ?>
                        <div class="col-md-3">
                            <?php if($comodidade->img_url){ ?>
                            <div class="box-logo d-flex align-items-center">
                                <img src="<?php e($comodidade->img_url); ?>" alt="" class="img-fluid align-self-center">
                            </div>
                            <?php }else{ ?>
                            <div class="box-logo">
                                <img src="<?php e(base_url("themes/comdono/img/no-image.png"));?>" alt="" class="img-fluid align-self-center">
                            </div>
                            <?php } ?>
                        </div>
                        <?php } } ?>
                    </div>
                </div>
            </div>
            
            <div class="container-carousel <?php e(count($config->comodidades) <= $qtdC ? "d-block-767":"d-block"); ?>">
                <div class="box-img loading-img border-img"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
                <div class="show-imgs">
                    <div class="owl-carousel-comodidades owl-carousel owl-theme container-comodidade mt-5">
                        <?php foreach ($config->comodidades as $key => $comodidade){ ?>
                        <?php if($comodidade->status == 1){ ?>
                            <?php if($comodidade->img_url){ ?>
                            <div class="box-logo d-flex align-items-center">
                                <img src="<?php e($comodidade->img_url); ?>" alt="" class="img-fluid align-self-center">
                            </div>
                            <?php }else{ ?>
                            <div class="box-logo">
                                <img src="<?php e(base_url("themes/comdono/img/no-image.png"));?>" alt="" class="img-fluid align-self-center">
                            </div>
                            <?php } ?>
                        <?php } }?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
    
    <?php if($config->diferenciais || $config->comodidades){ ?>
    <div class="row d-flex justify-content-center mt-5">
        <div class="col-md-12 col-lg-9 text-center">
            <a href="#section-unidades" class="btn btn-cta linkAnchor"><?php e($config->btn_unidade_option_txt == 1 && !empty($config->btn_unidade_txt) ?$config->btn_unidade_txt:"Conheça as unidades") ?></a>
        </div>
    </div>
    <?php } ?>
    
    <?php $sobre=0; if($sobre==1){ ?>
    <div id="sobre" class="row d-flex justify-content-center section-page">
        <div class="col-md-12 col-lg-9">
            <div class="row">
                <div class="col-md-6 col-lg-6">
                    <div class="title">
                        <img src="<?php e($config->img_lp); ?>">
                        
                        <h2 class="text-left mt-5 mb-5 "><?php e($config->sobre_titulo); ?></h2>
                    </div> 
                    <p><?php e($config->sobre_descricao); ?></p>
                </div>
                <div class="col-md-6 offset-lg-1 col-lg-5">
                    <small>Imagens ilustrativas</small>
                    <div class="container-img d-none-767"><img src="<?php e($config->img_lp); ?>" class="img-fluid"></div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
    
    <?php if($empreendimento->uuid_empreendimento !== 'jbn_i_jbn_c_h2p5rn'){ //uuid_empreendimento da producao?>
    <?php if(!empty($parceirosSelecionados)){ ?>
    <div id="sobre-parceiros" class="row section-page">
        <div class="col-md-12 text-center">
            <h3 class="mb-5">Uma realização:</h3>
        </div>
        <div class="col-md-12">
            <div class="row d-flex justify-content-center <?php e(!empty($config->comodidades)?"py-5 bg-grey":"") ?>">
                <div class="col-md-12 col-lg-9">
                    
                    <?php if($parceirosInline == true){ ?>
                        <div class="row d-flex justify-content-center align-items-center">
                            <?php foreach ($parceirosSelecionados as $parc){ ?>
                            <div class="col-md-4 text-center">
                                <div class="title">
                                    <img src="<?php e($parc->incorporadora->logo); ?>" class="img-fluid">                    
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                    <?php }else{ ?>
                    
                    <?php $i=0; foreach ($parceirosSelecionados as $parc){ ?>
                    <?php e($i>0?'<hr class="my-4">':"") ?>
                    
                    <div class="row">
                        <div class="col-md-4 d-flex justify-content-center align-items-center">
                            <div class="title">
                                <img src="<?php e($parc->incorporadora->logo); ?>" class="img-fluid">                    
                            </div>
                        </div>
                        <div class="col-md-8">
                            <?php if(!empty($parc->incorporadora->lpconfig_titulo)){ ?>
                            <div class="title">
                                <h2 class="text-left mb-4"><?php e($parc->incorporadora->lpconfig_titulo); ?></h2>
                            </div>
                            <?php } ?>
                            <p><?php e($parc->incorporadora->lpconfig_descricao); ?></p>
                        </div>
                    </div>
                    <?php $i++; }} ?>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
    <?php } ?>
    
    <div id="localizacao" class="row d-flex justify-content-center section-page">
        <div class="col-md-12 col-lg-9">
            <div class="row">
                <div class="col-lg-12">
                    <div class="title mb-5">
                        <h2 class="text-left m-0">Localização</h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-12 p-0">
            
            <iframe src="https://maps.google.com/maps?q=<?php e($imovel->latitude); ?>,<?php e($imovel->longitude); ?>&hl=es;z=14&amp;output=embed" width="100%" height="600" frameborder="0" style="border:0;"  width="100%" height="600" frameborder="0" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
            
        </div>
    </div>
    
    <div id="section-footer" class="row d-flex justify-content-center">
        <div class="col-lg-12">
            <div class="row d-flex justify-content-center">
                <div class="col-lg-9 text-center">
                    <div class="item box-item">
                        <?php e($config->footer_titulo); ?>
                    </div>
                    <div class="item info my-4">
                        <?php if(!empty($config->footer_endereco)){ e($config->footer_endereco); ?>
                        
                        <?php }else{ ?>
                        
                        <?php e(!empty($imovel->dn_cpf_cnpj) ? "CNPJ: ".$imovel->dn_cpf_cnpj."  - ":"" ); ?> <?php e($imovel->endereco." ".$imovel->numero." ".$imovel->complemento." ".$imovel->bairro); ?>, Brasília-DF - <?php e($imovel->cep); ?> - <?php e($imovel->dn_nome_nomefantasia); ?>
                        
                        <?php } ?>
                    </div>   
                    <div>Powered by <a href="<?php e(base_url()); ?>"><img src="<?php e(base_url()); ?>assets/img/comdono/logo-white-full.png"></a></div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="box-whatsapp">
    <a href="https://api.whatsapp.com/send?phone=5561994483087&amp;text=Olá! Gostaria de receber mais informações sobre o empreendimento <?php e($empreendimento->emp_razao_social)?>." target="_blank">
        <img src="<?php e(getenv('MEDIA_URL').'/modules/comdono/icons/whatsapp.png');?>">     
    </a>
</div>