<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

include_once GROCERY_CRUD;

class Cliente extends Grocery{
		
	public function __construct()
	{
		parent::__construct();
			$this->load->model('conversao_model');
	}
	
	public function index()
	{
		try{
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			$state = $crud->getState();	
			
			if($state == 'read1')
			{
			    $stateInfo = $crud->getStateInfo();
				$this->visualizar_cadastro($stateInfo->primary_key,3);
			}
			else 
			{
			    $this->grocery_clientes($crud,$state);
			}
	
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	public function grocery_clientes($crud,$state)
	{
	    $crud->set_table('cad_cliente')
		->set_subject('Cliente')
		->columns('id_cadastro','id_empresa', 'status')
		->display_as('id_cadastro','Cliente')
		->display_as('id_empresa','Agência');
		;
		
		//$crud->set_model('Agencia_crud_model');
		
		$crud->where('cad_cliente.status',1);
        //$crud->unset_texteditor('obs');
        
        /*$crud->set_fields_abas('Dados da Agência',array(
            'Dados' => array('id_empresa')
        ));*/
        
        
        $crud->callback_column('status',array($this,'_callback_status_column'));
		
        
        
		$crud->set_relation('id_cadastro','cad_cadastro','{nome} - {email}',array('status' => '1'));
        
        $crud->set_relation('id_empresa','cad_empresa','{nome} - {cnpj}',array('agencia' => '1')); // somente agencias
        
	    $stateInfo = $crud->getStateInfo();
	    $pk = $stateInfo->primary_key??0;
	    
	    /*$id_cadastro = $this->conversao_model->get_cliente($pk)->id_cadastro??0;
        
        $crud->set_rules('email', "'E-mail'", 'trim|required|valid_email|callback_valida_email['.$id_cadastro.']');*/
        
		$crud->required_fields('id_empresa','id_cadastro');
		
        /*$crud->callback_add_field('login_email',array($this,'field_add_login_email'));
        $crud->callback_add_field('estado_civil',array($this,'add_field_estado_civil'));
        $crud->callback_add_field('sexo',array($this,'add_field_sexo'));
        
        $crud->callback_edit_field('sexo',array($this,'edit_field_sexo'));
        $crud->callback_edit_field('estado_civil',array($this,'edit_field_estado_civil'));*/
		
        if($state == 'add' || $state == 'insert' || $state == 'insert_validation')
        {
            $crud->set_fields_abas(array(
                //'Status' => array('status'),
                'Dados Pessoais' => array('id_cadastro'),
                'Dados da Agência' => array('id_empresa')
            ));
    		$crud->field_type('status', 'hidden', 1);
    		$crud->field_type('data_hora_cadastro', 'hidden', date('Y-m-d H:i:s'));
    		$crud->field_type('historico', 'hidden', json_encode(['inserido_por'=>$this->session->user_id]));
        }
        else 
        {
            $crud->set_fields_abas(array(
                'Status' => array('status'),
                'Dados Pessoais' => array('id_cadastro'),
                'Dados da Agência' => array('id_empresa')
            ));
            
	    	$crud->callback_field('status',array($this,'field_status'));
        }
        
		$crud->field_type('ultima_atualizacao', 'hidden', date('Y-m-d H:i:s'));
        //$crud->callback_before_insert(array($this,'before_insert')); 
        //$crud->callback_before_update(array($this,'before_update'));
        
        // revisar !!! 
		//$crud->callback_delete(array($this,'callback_before_delete'));
		
		Assets::add_css('plugins/select2-4.0.6/select2.min');
		
		Assets::add_js(array(
		    'plugins/inputmask.3.3.11/inputmask-lib'
		));
		
	    Assets::add_module_js('conversao',array('cliente','modal_add')); // 'mascaras',
		
		$this->load_modal_iframe();
		
		$output = $crud->render();
		
		$this->_example_output($output);
	}
	
	
	public function _callback_status_column($value, $row)
    {
        return $value == 0 ? 'Inativo' : 'Ativo';
    } 
	
	private function load_modal_iframe()
	{
	    $data['modal'] = Template::get('modal');
        $fields = array(
            array(
                'name' => 'cadastro',
                'display' => 'Cadastro PF',
                'iframe' => 'conversao/cadastro/add_modal_default/index/add/',
            ),
            array(
                'name' => 'agencia',
                'display' => 'Agência',
                'iframe' => 'conversao/agencia/add_modal_default/index/add/',
            )
        );
        
        foreach($fields as $key=>$field)
        {
	        Template::load_view('modal/modal_add', $field, '', '', $data['modal'][]);
        }
        
        Template::set($data);
	}
	
	function field_status($value, $primary_key)
	{
	    return $this->callback_radio($value , 'status',0,1,'Inativo','Ativo');
	}
	
	/*function add_field_estado_civil()
	{    
        $html = '<select id="field-estado_civil" name="estado_civil" size="8" class="chosen-select" data-placeholder="Selecione Estado Civil" style="100%">';
        $html .= "<option value='Solteiro(a)'>Solteiro(a)</option>";
        $html .= "<option value='Casado(a)'>Casado(a)</option>";
        $html .= "<option value='Divorciado(a)'>Divorciado(a)</option>";
        $html .= "<option value='Viúvo(a)'>Viúvo(a)</option>";
        $html .= "</select>";
        
        return $html;
	}
	
	function edit_field_estado_civil($value, $primary_key)
	{    
        $html = '<select id="field-estado_civil" name="estado_civil" size="8" class="chosen-select" data-placeholder="Selecione Estado Civil" style="100%">';
        $selected = $value=="Solteiro"?"selected='selected'":"";
        $html .= "<option value='Solteiro(a)' ".$selected." >Solteiro(a)</option>";
        $selected = $value=="Casado(a)"?"selected='selected'":"";
        $html .= "<option value='Casado(a)' ".$selected.">Casado(a)</option>";
        $selected = $value=="Divorciado(a)"?"selected='selected'":"";
        $html .= "<option value='Divorciado(a)' ".$selected.">Divorciado(a)</option>";
        $selected = $value=="Viúvo(a)"?"selected='selected'":"";
        $html .= "<option value='Viúvo(a)' ".$selected.">Viúvo(a)</option>";
        $html .= "</select>";
        
        return $html;
	}
	
	function add_field_sexo()
	{    
        $html = '<select id="field-sexo" name="sexo" size="8" class="chosen-select" data-placeholder="Selecione Sexo">';
        $html .= "<option value='Masculino'>Masculino</option>";
        $html .= "<option value='Feminino'>Feminino</option>";
        $html .= "<option value='Outro'>Outro</option>";
        $html .= "</select>";
        
        return $html;
	}
	
	function edit_field_sexo($value, $primary_key)
	{    
        $html = '<select id="field-sexo" name="sexo" size="8" class="chosen-select" data-placeholder="Selecione Sexo">';
        $selected = $value=="Masculino"?"selected='selected'":"";
        $html .= "<option value='Masculino' ".$selected.">Masculino</option>";
        $selected = $value=="Feminino"?"selected='selected'":"";
        $html .= "<option value='Feminino' ".$selected.">Feminino</option>";
        $selected = $value=="Outro"?"selected='selected'":"";
        $html .= "<option value='Outro' ".$selected.">Outro</option>";
        $html .= "</select>";
        
        return $html;
	}
	
	function formata_password1()
	{
	    return '<input class="form-control" type="password" value="" name="senha" >';
	}
	
	function formata_passconf1()
	{
	    return '<input class="form-control" type="password" value="" name="conf_senha" >';
	}
	
	function field_add_login_email()
    {
        return '<input id="field-add-login_email" class="form-control" type="text" value="" name="login_email" readonly="readonly">';
    }
    
	function field_edit_login_email($value, $primary_key)
    {
        return '<input id="field-edit-login_email" class="form-control" type="text" value="'.$value.'" name="login_email" readonly="readonly">';
    }
    
    function formata_password($value, $primary_key)
	{
	    return '<input class="form-control" type="password" value="xxxxxx" name="senha" onBlur="password_blur(this)" onFocus="password_focus(this)" >';
	}
	
	function formata_passconf($value, $primary_key)
	{
	    return '<input class="form-control" type="password" value="xxxxxx" name="conf_senha" onBlur="password_blur(this)" onFocus="password_focus(this)" >';
	}
	
	public function valida_email($email,$id_cadastro)
	{
       if($this->conversao_model->check_email_is_unique($email,$id_cadastro))
       {
            return TRUE;
       }
       else
       {
            $this->form_validation->set_message('valida_email','E-mail já cadastrado! Informe outro e-mail.');
            return FALSE;
       }
	}*/
	
	/*public function before_insert($post_array) 
	{
	    // insert cad_cadastro
	    $this->create_new_cadastro($post_array);
	    
	    $this->trata_dados_cliente($post_array);
	    
	    return $post_array;
    }*/
    
    /*public function trata_dados_cliente(&$post_array)
    {*/
	    /*$post_array['nome']      = $post_array['nome_empresa'];
	    $post_array['email']     = $post_array['email_empresa'];
	    $post_array['telefone']  = $post_array['telefone_empresa'];
	    
	    unset($post_array['nome_empresa'],$post_array['email_empresa'],$post_array['telefone_empresa']);
	    */
       /* return $post_array;
    }*/
    
    /*private function create_new_cadastro(&$post_array)
    {
        $insert_cadastro = array(
            'nome' => $post_array['nome'],
            'telefone' => $post_array['telefone'],
            'email' => $post_array['email'],
            'data_nascimento' => $post_array['data_nascimento'],
            'estado_civil' => $post_array['estado_civil'],
            'cpf' => $post_array['cpf'],
            'rg' => $post_array['rg'],
            'orgao_exp' => $post_array['orgao_exp'],
            'data_exp' => $post_array['data_exp'],
            'sexo' => $post_array['sexo'],
            'naturalidade' => $post_array['naturalidade'],
            'nacionalidade' => $post_array['nacionalidade'],
            'profissao' => $post_array['profissao'],
            //'img_perfil' => $post_array[''],
            'end_cep' => $post_array['end_cep'],
            'end_endereco' => $post_array['end_endereco'],
            'end_numero' => $post_array['end_numero'],
            'end_complemento' => $post_array['end_complemento'],
            'end_bairro' => $post_array['end_bairro'],
            'end_cidade' => $post_array['end_cidade'],
            'end_estado' => $post_array['end_estado'],
            'facebook' => $post_array['facebook'],
            'instagram' => $post_array['instagram'],
            'linkedin' => $post_array['linkedin'],
            'aceita_termos' => 1,
            'status' => 1,
            'data_hora_cadastro' => date('Y-m-d H:i:s'),
            'ultima_atualizacao' => date('Y-m-d H:i:s'),
            'historico' => json_encode(['inserido_por'=>$this->session->user_id])
        );
        
        foreach ($insert_cadastro as $key=>$insert_cad)
        {
            //if(!in_array($key,['nome','email']))    
            unset($post_array[$key]);
        }
        
        $id_cadastro = $this->conversao_model->create_cadastro($insert_cadastro);
        
        $post_array['id_cadastro'] = $id_cadastro;
        
        return $post_array;
        
    }*/
    
    
    
    /*function before_update($post_array, $primary_key)
	{
	    $this->update_cadastro($post_array, $primary_key);
		
		$this->trata_dados_cliente($post_array);
	    
	    return $post_array;
	}*/
	
	/*private function update_cadastro(&$post_array,$primary_key)
    {
        $update_cadastro = array(
            'nome' => $post_array['nome'],
            'telefone' => $post_array['telefone'],
            'email' => $post_array['email'],
            'data_nascimento' => $post_array['data_nascimento'],
            'estado_civil' => $post_array['estado_civil'],
            'cpf' => $post_array['cpf'],
            'rg' => $post_array['rg'],
            'orgao_exp' => $post_array['orgao_exp'],
            'data_exp' => $post_array['data_exp'],
            'sexo' => $post_array['sexo'],
            'naturalidade' => $post_array['naturalidade'],
            'nacionalidade' => $post_array['nacionalidade'],
            'profissao' => $post_array['profissao'],
            //'img_perfil' => $post_array[''],
            'end_cep' => $post_array['end_cep'],
            'end_endereco' => $post_array['end_endereco'],
            'end_numero' => $post_array['end_numero'],
            'end_complemento' => $post_array['end_complemento'],
            'end_bairro' => $post_array['end_bairro'],
            'end_cidade' => $post_array['end_cidade'],
            'end_estado' => $post_array['end_estado'],
            'facebook' => $post_array['facebook'],
            'instagram' => $post_array['instagram'],
            'linkedin' => $post_array['linkedin'],
            'aceita_termos' => 1,
            'status' => 1,
            'ultima_atualizacao' => date('Y-m-d H:i:s'),
            'historico' => json_encode(['inserido_por'=>$this->session->user_id])
        );
        
        foreach ($update_cadastro as $key=>$update_cad)
        {
            if(!in_array($key,['nome','email']))    
                unset($post_array[$key]);
        }
        
        $empresa = $this->conversao_model->get_empresa($primary_key);
        
        $this->conversao_model->update_cadastro($empresa->id_cadastro,$update_cadastro);
        
        $post_array['id_cadastro'] = $empresa->id_cadastro;
        
        return $post_array;
        
    }*/
	
	
	
	
	//id_cadastro	uuid_cadastro	nome	telefone	email	cpf	rg	orgao_exp	
	//data_exp	sexo	nacionalidade	naturalidade	estado_civil	data_nascimento	
	//profissao	img_perfil	end_cep	end_endereco	end_numero	end_complemento	end_bairro	
	//end_cidade	end_estado	facebook	instagram	linkedin	push_alertjson	aceita_termos	
	//data_hora_cadastro	ultima_atualizacao	historico
	
	//agencia 0-empresa/1-agencia	uuid_empresa	uuid_cadastro
    //	nome_empresa	cnpj	telefone	email	site	status 0-inativa/1-ativa	
    //data_hora_cadastro	ultima_atualizacao	historico	

	
	public function callback_before_delete($primary_key)
    {
        $this->db->set('status','Inativo');
        $this->db->set('status',0);
        $this->db->where('id_cad_forn',$primary_key);
        $this->db->update('cad_empresa');
        return true;
    }
}