<?php 

class Conversao_model extends CI_Model {
    
    public function __construct()
	{
		parent::__construct();
	}
	
	function get_empresa($id_empresa)
	{
	    $this->db->where('id_empresa',$id_empresa);
	    $query = $this->db->get('cad_empresa');
		
		if ($query->num_rows() == 1 ) return $query->row();
		return [];
	}
	
	function get_empresa_campanha($id_empresa, $id_campanha)
	{
	    $this->db->where('id_empresa',$id_empresa);
	    $this->db->where('id_campanha',$id_campanha);
	    $query = $this->db->get('cad_campanha');
		
		if ($query->num_rows() == 1 ) return $query->row();
		return [];
	}
	
	function list_agencias()
	{
	    $this->db->where('agencia',1);
	    $query = $this->db->get('cad_empresa');
		
		if ($query->num_rows() > 0 ) return $query->result();
		return [];
	}
	
	function get_agencia($id_empresa)
	{
	    $this->db->where('id_empresa',$id_empresa);
	    $this->db->where('agencia',1);
	    $query = $this->db->get('cad_empresa');
		
		if ($query->num_rows() == 1 ) return $query->row();
		return [];
	}
	
	function list_perfis()
	{
	    $query = $this->db->get('sys_perfil');
		
		if ($query->num_rows() > 0 ) return $query->result();
		return [];
	}
	
	function list_empresas()
	{
	    $this->db->where('agencia',0);
	    $query = $this->db->get('cad_empresa');
		
		if ($query->num_rows() > 0 ) return $query->result();
		return [];
	}
	
	/**
	 * get pagina
	 *
	 * @param	$data
	 * @return	int id or null
	 */
	function get_pagina($id_pagina)
	{
        $this->db->where('id_pagina',$id_pagina);
    	$query = $this->db->get('cad_pagina');
		
		if ($query->num_rows() == 1) return $query->row();
		return [];
	}
	
	/**
	 * Get campanha by id
	 *
	 * @param	int
	 * @return	object or []
	 */
	function get_campanha($id_campanha)
	{
	    $this->db->where('id_campanha',$id_campanha);
	    $query = $this->db->get('cad_campanha');
		
		if ($query->num_rows() == 1 ) return $query->row();
		return [];
	}
	
	/**
	 * get campanha/pagina
	 *
	 * @param	$data
	 * @return	int id or null
	 */
	function get_campanha_pagina($id_campanha)
	{
        $this->db->where('id_campanha',$id_campanha);
    	$query = $this->db->get('cad_pagina');
		
		if ($query->num_rows() == 1) return $query->row();
		return [];
	}
	
	/**
	 * get metatag
	 *
	 * @param	$data
	 * @return	int id or null
	 */
	function get_metatag($id_metatag)
	{
        $this->db->where('id_metatag',$id_metatag);
    	$query = $this->db->get('cad_metatag');
		
		if ($query->num_rows() == 1) return $query->row();
		return [];
	}
	
	// revisar 
	
	function get_cliente($id_cliente)
	{
	    $this->db->where('id_cliente',$id_cliente);
	    $this->db->join('cad_cadastro as c', 'a.id_cadastro = c.id_cadastro');
	    $query = $this->db->get('cad_cliente as a');
		
		if ($query->num_rows() == 1 ) return $query->row();
		return [];
	}
	
	function check_email_is_unique($email,$id_cadastro = 0)
	{
		$this->db->where('email',$email);
		if($id_cadastro != 0)
		    $this->db->where ( 'id_cadastro !=', $id_cadastro );
		$query = $this->db->get('cad_cadastro');
		
		if ($query->num_rows() == 0 ) return TRUE;
		return FALSE;
	}
	
	/**
	 * Create new user record
	 *
	 * @param	array
	 * @return	int
	 */
	function create_user($data)
	{
		$data['created'] = date('Y-m-d H:i:s');

		if ($this->db->insert('sys_users', $data)) {
			return $this->db->insert_id();
		}
		return NULL;
	}
	
	function update_user($id_cadastro,$data) 
	{
        $this->db->where('id_cadastro',$id_cadastro);

        if ($this->db->update ('sys_users', $data ))
            return true;
        else
            return false;
    }
    
    /**
	 * Get user record by ID
	 *
	 * @param	int
	 * @return	object or []
	 */
	function get_usuario($id_user)
	{
        $this->db->where('id',$id_user);
    	$query = $this->db->get('sys_users');
		
		if ($query->num_rows() == 1) return $query->row();
		return [];
	}
	
	/**
	 * Get user record by ID
	 *
	 * @param	int
	 * @return	object or []
	 */
	function get_usuario_by_id_cadastro($id_cadastro)
	{
        $this->db->where('id_cadastro',$id_cadastro);
    	$query = $this->db->get('sys_users');
		
		if ($query->num_rows() == 1) return $query->row();
		return [];
	}
	
	/**
	 * Get perfil record by ID
	 *
	 * @param	int
	 * @return	object or []
	 */
	function get_perfil($id_perfil)
	{
        $this->db->where('id_perfil',$id_perfil);
    	$query = $this->db->get('sys_perfil');
		
		if ($query->num_rows() == 1) return $query->row();
		return [];
	}
	
    
	/**
	 * Create new cadastro record
	 *
	 * @param	array
	 * @return	int
	 */
	function create_cadastro($data)
	{
	    if ($this->db->insert('cad_cadastro', $data)) return $this->db->insert_id();
	    return NULL;
	}
	
	/**
	 * Create new cadastro record
	 *
	 * @param	array
	 * @return	int
	 */
	function list_cadastros()
	{
    	$query = $this->db->get('cad_cadastro');
		
		if ($query->num_rows() > 0) return $query->result();
		return [];
	}
	
	/**
	 * Get cadastro record by ID
	 *
	 * @param	int
	 * @return	int
	 */
	function get_cadastro($id_cadastro)
	{
        $this->db->where('id_cadastro',$id_cadastro);
    	$query = $this->db->get('cad_cadastro');
		
		if ($query->num_rows() == 1) return $query->row();
		return [];
	}
	
	
	function update_cadastro($id_cadastro,$data) 
	{
        $this->db->where('id_cadastro',$id_cadastro);

        if ($this->db->update ('cad_cadastro', $data )) return true;
        return false;
    }
    
    /**
	 * insert utm
	 *
	 * @param	$data
	 * @return	int id or null
	 */
	function insert_utm($data)
	{
        if ($this->db->insert('cad_pagina_utm', $data)) return $this->db->insert_id();
        return NULL;
	}
	
	/**
	 * insert scrpits
	 *
	 * @param	$data
	 * @return	int id or null
	 */
	function insert_scripts($data)
	{
        if ($this->db->insert('cad_pagina_scripts', $data)) return $this->db->insert_id();
        return NULL;
	}
	
	function get_scripts($id_pagina)
	{
        $this->db->where('id_pagina',$id_pagina);
    	$query = $this->db->get('cad_pagina_scripts');
		
		if ($query->num_rows() >= 1) return $query->result();
		return [];
	}
	
	/**
	 * get utm
	 *
	 * @param	$data
	 * @return	int id or null
	 */
	function get_utm($id_pagina)
	{
        $this->db->where('id_pagina',$id_pagina);
    	$query = $this->db->get('cad_pagina_utm');
		
		if ($query->num_rows() == 1) return $query->row();
		return [];
	}
	
	function update_utm_by_id_pagina($id_pagina,$utm)
	{
        $this->db->where('id_pagina',$id_pagina);

        if ($this->db->update ('cad_pagina_utm', $utm )) return true;
        return false;
    }
	
	
	
	/*function getEmpsCampsPaginas($where = []){
        $this->db->join('id_empresa as emp', 'cad_empresa.id_empresa = emp.id_empresa');
        $this->db->join('cad_cadastro as c', 'pf.id_cadastro = c.id_cadastro');
        return $this->getRow('inc_incorporadora', $where);
    }*/
	
}