<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Action extends Builder_Controller
{
    
    function __construct() 
    {
        parent::__construct();
        $this->load->model('newsletter_model');
    }
    
    public function notification_aws()
	{
	    // Fetch the raw POST body containing the message
        $postBody = file_get_contents('php://input');
        
        // JSON decode the body to an array of message data
        $postBody = json_decode($postBody, true);
        if(isset($postBody['SubscribeURL']) && !empty($postBody['SubscribeURL']))
        {
            file_get_contents($postBody['SubscribeURL']);
        }
        
        if (isset($postBody['Message'])) {
            $message = json_decode($postBody['Message']);
            
            if($message->notificationType == 'Bounce')
            {
                foreach($message->bounce->bouncedRecipients as $data)
                {
                    $insert = array(
                        'notificationType' => $message->notificationType,
                        'emailAddress' => $data->emailAddress,
                        'action' => $data->action,
                        'status' => $data->status,
                        'diagnosticCode' => $data->diagnosticCode,
                        );
                    $this->db->insert('nwl_notifications',$insert);
                }
            }
            elseif($message->notificationType == 'Complaint')
            { 
                foreach($message->complaint->complainedRecipients as $data)
                {
                    $insert = array(
                        'notificationType' => $message->notificationType,
                        'emailAddress' => $data->emailAddress,
                        );
                    $this->db->insert('nwl_notifications',$insert);
                }
            }
        }
    }
    
    public function desinscrever()//comdono
    {
        $key = $this->uri->segment(4);//key_log
        $row = $this->newsletter_model->confirma_email_campanha($key);
        
        if($row != null)
        {
            $this->session->set_userdata('key_desinscrever_email',$key);
            
            $cad_email = $this->newsletter_model->get_email_by_email($row->email); 
            if($cad_email == null) 
            {
                $data['email'] = $row->email;
                $this->newsletter_model->insere_news_email($data);
            }
            
            $this->newsletter_model->desativa_email($row->email);
            $this->session->set_flashdata('desinscricao', true);
            $clique['name'] = 'Desinscricao';
            $clique['url'] = 'Comdono';
            $this->set_historico_clique($row,$clique);
        }
        
        redirect(base_url());
    }
    
    public function desinscrever_copa()//comdono
    {
        $key = $this->uri->segment(4);//key_log
        $row = $this->newsletter_model->confirma_email_campanha($key);
        
        if($row != null)
        {
            $this->session->set_userdata('key_desinscrever_email',$key);
            
            $cad_email = $this->newsletter_model->get_email_by_email($row->email); 
            if($cad_email == null) 
            {
                $data['email'] = $row->email;
                $this->newsletter_model->insere_news_email($data);
            }
            
            $this->newsletter_model->desativa_email($row->email);
            $this->session->set_flashdata('desinscricao', true);
            $clique['name'] = 'Desinscricao';
            $clique['url'] = 'Copa';
            $this->set_historico_clique($row,$clique);
        }
        
        if(base_url() == 'https://dev.comdono.com/')
            redirect('https://dev.comdono.com/landingpage/copa_network');
        redirect('https://copanetwork.work');
    }
    
    public function desinscrever_motivo()
    {
        $link_redirect = base_url();
        $key = $this->session->key_desinscrever_email;
        
        if(!isset($key) || $key == NULL)
        {
            echo json_encode(['valid'=>false,'message'=>'Erro ao realizar desinscrição. Tente novamente mais tarde.']);
            die();
        }
        
        $this->load->library('form_validation');
        
        if ($this->input->post() == TRUE) 
        {
            $this->form_validation->set_rules('motivo', 'razão da sua desinscrição', 'required');
    		if($this->input->post('motivo') == "Outro")
    		    $this->form_validation->set_rules('obs', 'Texto', 'required|trim');
    		
    		if ($this->form_validation->run() != FALSE)
    		{
    		    $data['motivo'] = $this->input->post('motivo');
    		    $data['obs'] = $this->input->post('obs');
    		    $return = $this->desinscreve($key, $data);
    		    
    		    if($return === true)
    		    {
    		        $this->session->unset_userdata('key_desinscrever_email');
    		        echo json_encode(['valid'=>true,'message'=>'Desinscrição realizada com sucesso']);
    		    }
    		    else
    		    {
    		        echo json_encode(['valid'=>false,'message'=>'Erro ao salvar o motivo.']);
    		    }
    		}
    		else
    		{
    		    echo json_encode(['valid'=>false,'message'=>validation_errors()]);
    		}
    		
        }
        
    }
    
    public function desinscreve($key, $data)
    {
        $row = $this->newsletter_model->confirma_email_campanha($key);
        if ($row != NULL) 
        {
            $cad_email = $this->newsletter_model->get_email_by_email($row->email); 
             
            if($cad_email == null) 
            {
                $insert['email'] = $row->email;
                $data['id_email'] = $this->newsletter_model->insere_news_email($insert);
            }
            else
                $data['id_email'] = $cad_email->id;
                
            $this->newsletter_model->desativa_email($row->email);
            
            if($this->newsletter_model->insere_desinscricao($data))
                return TRUE;
            else
                return FALSE;
        } 
        else
            return FALSE;
    }
    
    public function desescrever()//blog
    {
        $key = $this->uri->segment(4);//key_log
        $row = $this->newsletter_model->confirma_email_campanha($key);
        
        if($row != null)
        {
            $this->newsletter_model->desativa_email($row->email);
            $this->session->set_flashdata('modal_msg', array('msg' => 'Desinscrição efetuada.','desinscricao' => true));
        }
        
        $config = $this->newsletter_model->get_config_campanha();
        if(isset($config->redirect_desiscricao) && $config->redirect_desiscricao != '')
        {
            $clique['name'] = 'DESISCRICAO';
            $clique['url'] = $config->redirect_desiscricao;
            $this->set_historico_clique($row,$clique);
            redirect($config->redirect_desiscricao);
        }
            
        redirect(base_url('blog'));
    }
    
    //abriu email da campanha
    public function k8j6gf5563_img()
	{
	    $key = $this->uri->segment(4);//key_log
        $row = $this->newsletter_model->abriu_email_campanha($key);
        $config = $this->newsletter_model->get_config_campanha();  
        $this->load->library('easyphpthumbnail');
		$thumb = new easyphpthumbnail;
		$thumb->Thumbwidth = 1;//562;
		$thumb->Createthumb('img/'.$config->img_cont_view);
		
    }
    
     //clicou  email da campanha
     public function jhu68fkj4087a7d99s7s8g8f()
    {
        $key = $this->uri->segment(4);//key_log
        $k_link = $this->uri->segment(5);//key_log
        $row = $this->newsletter_model->clicou_email_campanha($key);
        
        if(isset($row->id_campanha)){
            $camp = $this->newsletter_model->get_campanha($row->id_campanha);
            if(isset($camp->link_destino) && $camp->link_destino != '')
            {
                $pos = strripos($camp->link_destino, ',');
                if (!($pos === false))
                {
                    $links = explode(',',$camp->link_destino);
                    if($k_link == null || $k_link == 0)
                    {
                        $clique['name'] = 'Link-1';
                        $redrect = $links[0];
                    }
                    else
                    {
                        $clique['name'] = 'Link-'.($k_link+1);
                        $redrect = $links[$k_link];
                    }
                }
                else
                {
                    $clique['name'] = 'Link-1';
                    $redrect = $camp->link_destino;
                }
                $clique['url'] = $redrect;
                $this->set_historico_clique($row,$clique);
                
                
                redirect($redrect);
            }
        }
        redirect(base_url());
    }
    
    //clicou no site
    public function jhuhsgdgvb87a7d99s7s8g8f()
    {
        $key = $this->uri->segment(4);//key_log
        $row = $this->newsletter_model->clicou_email_campanha_site($key);
        
        $config = $this->newsletter_model->get_config_campanha();
        if(isset($config->base_url) && $config->base_url != '')
        {
            $clique['name'] = 'SITE';
            $clique['url'] = $config->base_url;
            $this->set_historico_clique($row,$clique);
            redirect($config->base_url);
        }
            
        
        redirect(base_url());
    }
    
    private function set_historico_clique($row,$clique)
    {
        $clique['datetime'] = date("Y-m-d H:i:s");
        if($row->historico_clique == '')
        {
            $historico = json_encode(array($clique));
        }
        else
        {
            $array_historico = json_decode($row->historico_clique);
            $array_historico[] = $clique;
            $historico = json_encode($array_historico);
        }
        $this->newsletter_model->insert_historico_clique($row->id, $historico);
    }
    
    
    
    
    
    
    
    
    /*//ver email da campanha
    public function dc52a5ada774d48be845b4() 
    {
        $this->load->library('parser');
        
        $key = $this->uri->segment(4);
        $log = $this->newsletter_model->select_log_email($key);
        if($log != null)
        {
            $email = $log->email;
            $campanha = $this->newsletter_model->get_campanha($log->id_campanha);
            $config = $this->newsletter_model->get_config_campanha();
            if($campanha->view_html == "")
            {
                $view = 'campanha/email_default_html';
            }
            else
            {
                $view = $campanha->view_html;
            }
            $data = array(
                'campanha'      => $campanha->campanha,
                'base_url'      => base_url(),
                'email'         => $email,
                'key_log'       => $log->key_log,
                'mensagem'      => $campanha->mensagem,
                'view_html'     => $view,
                'link'          => $campanha->link_destino,
                'web'           => true,
                'from_email'    => $config->from_email,
                'from_titulo'   => $config->from_titulo,
                'config'        => (array)$config,
            );
            
            $this->parser->parse($view, $data);
        }else
        {
            redirect(base_url());
        }
        
        
        //$this->load->view($view, $data);
    }*/
    
    
    
   
   
    
    
    
    #################################################################### 
  
    function index() 
    {
        $this->load->model('newsletter_model');
       
        $nova_data_hora = mktime(date("H"), date("i"), date("s"), date("m") , date("d") - 1, date("Y")); 
		$datetime = date('Y-m-d H:i:s', $nova_data_hora);
		
		$result = $this->newsletter_model->select_emails_expired($datetime);
		if($result != NULL)
		{
		    foreach($result as $data)
		    {  
                $data['key_concat'] =  $data['id'].$data['activation_key'];
		        $r_email = $this->envia_confirmacao($data);
		        if($r_email == true)
		        {
		            $this->newsletter_model->enviou_email_2($data['id']);
		        }
		     }
		}
		
        
    }
    
    public function envia_confirmacao($data) 
    {
        
        $this->load->library('email');
        
        $data['url'] = base_url() . "leadpg/confirmacao/" . $data['id'] . $data['activation_key'];
       
        //$data = array('nome'=>$new_nome,'url'=>$url);
        
        $config['protocol'] = 'mail';
        $config['mailpath'] = '/usr/sbin/sendmail';
        $config['charset'] = 'utf-8';
        $config['wordwrap'] = TRUE;
        
        $this->load->library('email');
        $this->email->from('contato@viewbrasil.com.br', "View Brasil - Mkt Digital");
        $this->email->to($data['email']);
        $this->email->subject("View Brasil - Marketing Digital | Ativação");
        $this->email->message($this->load->view('email-nao-ativacao-html', $data, TRUE));
        
        /*$message = "<p>Uma mensagem de confirmação está sendo enviada para o e-mail <b>".$email."</b>.
        Por favor, clique no link de confirmação da mensagem para confirmar seu cadastro.
        Se depois de 24 horas você não tiver recebido, entre em contato conosco.</p>";
        */
        if ($this->email->send()) 
        {
            return true;
            
        } 
        else
        {
            return $this->email->print_debugger();
        }
    }
    
    
    // abriu email 1 de confirmação
    public function h6ku7fds31_img()
	{
	    $key = $this->uri->segment(4);//key_concat
	        
        
        $this->load->model('newsletter_model');
        $this->newsletter_model->abriu_email_1($key);
        
        $this->load->library('easyphpthumbnail');
		$thumb = new easyphpthumbnail;
		$thumb->Thumbwidth = 562;
		$thumb->Createthumb('modules/newsletter/img/logo_emkt.png');
    }
    
    //abriu email 2 de nao confirmação
    public function j8h6gf4562_img()
	{
	    
	    $key = $this->uri->segment(4);//key_concat
	        
        
        $this->load->model('newsletter_model');
        $this->newsletter_model->abriu_email_2($key);
        
        $this->load->library('easyphpthumbnail');
		$thumb = new easyphpthumbnail;
		$thumb->Thumbwidth = 562;
		$thumb->Createthumb('modules/newsletter/img/logo_emkt.png');
    }
    
    
    
    
    //clicou no maps email de confirmação
    public function hnd99fkj405kfj76sh485jf056k4()
    {
        $key = $this->uri->segment(4);//key_concat
        $this->load->model('newsletter_model');
        $this->newsletter_model->clicou_email_conf_maps($key);
        
        
        
        $link = 'https://www.google.com.br/maps/place/View+Brasil+-+Marketing+Digital/@-15.8325727,-48.0572571,17z/data=!4m2!3m1!1s0x935a3b2019c05a19:0x6a58e799d7d4a558';
        redirect($link);
    }
    
   
    
    public function infografico()
    {
          $file = 'modules/leadpg/img/infograph.pdf';
          $filename = 'infografico-view-brasil-metodologia-de-sucesso.pdf';
          header('Content-type: application/pdf');
          header('Content-Disposition: inline; filename="' . $filename . '"');
          header('Content-Transfer-Encoding: binary');
          header('Accept-Ranges: bytes');
          @readfile($file);
    }
    
    
    //teste
    public function f79a705eac0b35b3860b0d661c769874()
    {
        $key = $this->uri->segment(4);
        $clique = $this->uri->segment(5);
        $url = $this->uri->segment(6)."/";
        
        for ($i = 7; $i <= $this->uri->total_segments(); $i++) {
             $url .= "/".$this->uri->segment($i);
        }
        echo "cq = $clique <br>";
        echo $url;
        $this->load->model('newsletter_model');
        $this->newsletter_model->clicou_email_campanha($key);
        //redirect($url);
    }






//########################################################### PMDB ##########################################################################################################################################
    
     private function array_presidentes() {
		$str = "1º - PRESIDENTE;
				4º - PRESIDENTE;
				PRESIDENTE - EXECUTIVA;
				PRESIDENTE - DIRETÓRIO;
				PRESIDENTE - COMISSAO EXECUTIVA;
				PRESIDENTE - COMISSÃO PROVISÓRIA;
				PRESIDENTE - E LÍDER DA BANCADA;
				PRESIDENTE - COMISSÃO DIRETORA REGIONAL PROVISÓRIA;
				PRESIDENTE - DA COMISSAO INTERVENTORA;
				PRESIDENTE - DA COMISSÃO PROVISÓRIA;
				PRESIDENTE - DA COMISSÃO INTERVENTORA;
				PRESIDENTE -  EM EXERCÍCIO;
				PRESIDENTE - EM EXERCICIO;
				PRESIDENTE - EXECUTIVA MUNICIPAL;
				PRESIDENTE COMISSÃO EXECUTIVA;
				PRESIDENTE - COMISSÃO EXECUTIVA;
				1º - PRESIDENTE - DA COMISSÃO PROVISÓRIA;
				1º - PRESIDENTE - DA COMISSÃO PROVISORIA;
				1º - PRESIDENTE - DA COMISSAO PROVISÓRIA;
				PRESIDENTE - COMISSÃO  EXECUTIVA;
				PRESIDENTE - DA COMISSÃO EXECUTIVA;
				PRESIDENTE - COMISSAO EXECUTIVA MUNICIPAL;
				1º - PRESIDENTE COMISSÃO EXECUTIVA;
				1º - PRESIDENTE - DA COMISSÃO PROVIÓRIA;
				1º - PRESIDENTE - DA COMISSAO PROVISORIA;
				1º - PRESIDENTE - DA COMISSÃO PROCISÓRIA;
				1º - PRESIDENTE - COMISSAO EXECUTIVA;
				1º - PRESIDENTE -  DA COMISSAO PROVISORIA;
				PRESIDENTE - DA COMMISSÃO EXECUTIVA;
				1º - PRESIDENTE - DA COMISSÃO EXECUTIVA;
				PRESIDENTE - COMISSAO PROVISORIA;
				PRESIDENTE - COMISSÃO PROVISORIA;
				PRESIDENTE - PROVISORIA;
				PRESIDENTE - E DELEGADO À CONVENÇÃO REGIONAL;
				PRESIDENTE - DELEGADO À CONVENÇÃO REGIONAL;
				PRESIDENTE -  E DELEGADO À CONVENÇÃO REGIONAL;
				PRESIDENTE - E SUPLENTE DE DELEGADO À CONVENÇÃO REGIONAL;
				PRESIDENTE - E DELEGADA À CONVENÇÃO REGIONAL;
				PRESIDENTE - E LIDER DA BANCADA;
				PRES. DE HONRA;
				2º - PRESIDENTE;
				PRESIDENTE - COMISSÃO PROVISÓRIA MUNICIPAL;
				PRESIDENTE - COMISSÃO EXECUTIVA MUNICIPAL;
				PRESIDENTE - COMISSÃ PROVISÓRIA MUNICIPAL;
				PRESIDENTE DE FORMAÇÃO POLITICA;
				PRESIDENTE - DA COMISSÃO PROVISORIA;
				PRESIDENTE - DA COMISSÃO PROVISSÓRIA;
				PRESIDENTE - DA COMISSÃO  EXECUTIVA;
				PRESIDENTE - PRESIDENTE EM EXERCICIO;
				PRESIDENTE - PRESIDENTE EM EXERCÍCIO;
				PRESIDENTE - EM EXERCÍCIO;
				PRESIDENTE - EM EXERCICO;
				PRESIDENTE - 3º DELEGADO;
				2º - PRESIDENTE - SUPLENTE DE DELEGADO;
				MEMBRO - PRESIDENTE;
				DIRETORIO - PRESIDENTE DA COMISSÃO EXECUTIVA;
				PRESIDENTE;
				4º - SECRETÁRIO-PRESIDENTE - COMISSÃO EXECUTIVA;
				PRESIDENTE - LICENCIADO;
				PRESIDENTE DA COMISSAO EXECUTIVA;
				PRESIDENTE - DO DIRETÓRIO MUNICIPAL;
				PRESIDENTE (COM. EXEC.);
				DIRETORIO - PRESIDENTE DA COMISSAO EXECUTIVA;
				PRESIDENTE DE HONRA;
				PRESIDENTE - PRESIDENTE EM LICENÇA ATÉ 15/10/2014";
		
		$array1 = explode ( ';', $str );
		
		foreach ( $array1 as $key => $value ) {
			$array1 [$key] = trim ( $value );
		}
		
		return $array1;
	}
   
   public function relatorio_presidentes() {
		
		$this->load->model ( 'newsletter_model' );
	
		$municipios = $this->newsletter_model->lista_municipios_pmdb();
		//$municipios = $this->newsletter_model->lista_municipios_pmdb_sem_email ();
		/*foreach($municipios as $municipio)
		{
		    //SELECT * FROM `tb_municipio_composicao` WHERE `id_municipio` = 5382  OR `id_municipio`  = 5383 OR `id_municipio` = 5384
		    echo "`id_municipio` = ".$municipio->id_municipio.' OR ';
		}
	    break;*/
		// $array_presidentes = $this->array_presidentes();
		$array_presidentes = $this->array_presidentes ();
	
		if ($municipios !== NULL) {
			$array_retorno = array ();
				
			foreach ( $municipios as $key => $municipio ) {
				//if ($municipio->uf == 'PE'){
				$obj_municipio = new stdClass ();
	
				$obj_municipio->uf = $municipio->uf;
				$obj_municipio->municipio = $municipio->municipio;
				$obj_municipio->orgao = ($municipio->tipo_orgao == 1) ? "Diretório" : "Comissão Provisória";
				$obj_municipio->vigencia_ini = $municipio->vigencia_ini;
				$obj_municipio->vigencia_fim = $municipio->vigencia_fim;
				$obj_municipio->logradouro = $municipio->logradouro;
				$obj_municipio->bairro = $municipio->bairro;
				$obj_municipio->cep = $municipio->cep;
				$obj_municipio->telefone_1 = $municipio->telefone_1;
				$obj_municipio->telefone_2 = $municipio->telefone_2;
				$obj_municipio->celular_1 = $municipio->celular_1;
				$obj_municipio->celular_2 = $municipio->celular_2;
				$obj_municipio->email_1 = $municipio->email_1;
	
				
				$array_retorno [$key] = array (
						$obj_municipio
				);
	
				$where = '';
	
				$result = $this->newsletter_model->lista_composicao_municipio ( $municipio->id_municipio );
	
				if ($result !== NULL) {
					foreach ( $result as $value ) {
						if (array_search ( trim ( $value->cargo_1 ), $array_presidentes ) !== FALSE || array_search ( $value->cargo_2, $array_presidentes ) !== FALSE || array_search ( $value->cargo_3, $array_presidentes ) !== FALSE) 
						{
							$presidente = new stdClass ();
								
							$presidente->nome = $value->nome_completo;
							$presidente->cargo = '';
								
							if (array_search ( trim ( $value->cargo_1 ), $array_presidentes ) !== FALSE) {
								$presidente->cargo .= $value->cargo_1 . ' / ';
							}
							if (array_search ( trim ( $value->cargo_2 ), $array_presidentes ) !== FALSE) {
								$presidente->cargo .= $value->cargo_2 . ' / ';
							}
							if (array_search ( trim ( $value->cargo_3 ), $array_presidentes ) !== FALSE) {
								$presidente->cargo .= $value->cargo_3 . ' / ';
							}
							$presidente->cargo = substr ( $presidente->cargo, 0, - 2 );
								
							array_push ( $array_retorno [$key], $presidente );
						}
					}
				}
	
				 /*  if($key == 5)
					 {
					 break;
					 } 
				  */
			//}
			}
				
			 //var_dump($array_retorno);break;
				
			$this->_export_excel ( $array_retorno );
			//$this->_excel_novo ( $array_retorno );
		}
	}
   
   
   private function _export_excel($municipios) {
		
		$columns = array (
				'UF',
				'Município',
				'Órgão',
				'Início Vigência',
				'Fim Vigência',
				'Endereço',
				'Bairro',
				'CEP',
				'Telefone',
				'Telefone',
				'Celular',
				'Celular',
				'E-mail',
				'Cargo 1',
				'Nome 1',
				'Cargo 2',
				'Nome 2',
				'Cargo 3',
				'Nome 3' 
		);
		
		$string_to_export = "";
		foreach ( $columns as $column ) {
			$string_to_export .= $column . "\t";
		}
		$string_to_export .= "\n"; 
		
		 foreach ( $municipios as $municipio ) {
			
			$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $municipio [0]->uf ) ) . "\t"; // quebra de coluna
			$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $municipio [0]->municipio ) ) . "\t"; // quebra de coluna
			$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $municipio [0]->orgao ) ) . "\t"; // quebra de coluna
			$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $municipio [0]->vigencia_ini ) ) . "\t"; // quebra de coluna
			$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $municipio [0]->vigencia_fim ) ) . "\t"; // quebra de coluna
			$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $municipio [0]->logradouro ) ) . "\t"; // quebra de coluna
			$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $municipio [0]->bairro ) ) . "\t"; // quebra de coluna
			$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $municipio [0]->cep ) ) . "\t"; // quebra de coluna
			$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $municipio [0]->telefone_1 ) ) . "\t"; // quebra de coluna
			$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $municipio [0]->telefone_2 ) ) . "\t"; // quebra de coluna
			$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $municipio [0]->celular_1 ) ) . "\t"; // quebra de coluna
			$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $municipio [0]->celular_2 ) ) . "\t"; // quebra de coluna
			$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $municipio [0]->email_1 ) ) . "\t"; // quebra de coluna
			
			(isset ( $municipio [1] )) ? $presidente1 = $municipio [1] : $presidente1 = NULL;
			(isset ( $municipio [2] )) ? $presidente2 = $municipio [2] : $presidente2 = NULL;
			(isset ( $municipio [3] )) ? $presidente3 = $municipio [3] : $presidente3 = NULL;
			
			if ($presidente1 !== NULL) {
				$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $presidente1->cargo ) ) . "\t"; // quebra de coluna
				$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $presidente1->nome ) ) . "\t"; // quebra de coluna
			}
			if ($presidente2 !== NULL) {
				$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $presidente2->cargo ) ) . "\t"; // quebra de coluna
				$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $presidente2->nome ) ) . "\t"; // quebra de coluna
			}
			if ($presidente3 !== NULL) {
				$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $presidente3->cargo ) ) . "\t"; // quebra de coluna
				$string_to_export .= html_entity_decode ( $this->_trim_export_string ( $presidente3->nome ) ) . "\t"; // quebra de coluna
			}
			
			$string_to_export .= "\n"; // quebra de linha
		}  
		
		// var_dump($string_to_export);break;
		
		// Convert to UTF-16LE and Prepend BOM
		
		$string_to_export = "\xFF\xFE".mb_convert_encoding($string_to_export, 'UTF-16LE', 'UTF-8');
		
		
		// $string_to_export = "\xFF\xFE" .mb_convert_encoding($string_to_export, 'UTF-16LE', 'UTF-8');
		
		$filename = "municipios-".date("d/m/Y_H:i:s").".csv";
		
		header('Content-type: application/vnd.ms-excel;charset=UTF-16LE');
		
		header('Content-Disposition: attachment; filename='.$filename);
		header("Cache-Control: no-cache");
		echo $string_to_export;
		die();
	}
   
   
   
   private function _trim_export_string($value) {
		$value = str_replace ( array (
				"&nbsp;",
				"&amp;",
				"&gt;",
				"&lt;" 
		), array (
				" ",
				"&",
				">",
				"<" 
		), $value );
		return strip_tags ( str_replace ( array (
				"\t",
				"\n",
				"\r" 
		), "", $value ) );
	}
   
   
   
   
   
   






}