<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
include_once GROCERY_CRUD;

class Cadencia extends Grocery
{
    
    function __construct() 
    {
        parent::__construct();
        $this->load->model('painel_model');
        //$this->load->model('newsletter_model');
    }
    
    public function paginas()
    {
        try{		
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			
			$perfil = $this->session->perfil;
			$state = $crud->getState();
			$state_info = $crud->getStateInfo();
			
			
			//$crud->columns( 'id', 'nome','enviado', 'abriu', 'clicou', 'clicou_site', 'falhou','qnt','datetime');
			//$crud->set_model('newsletter/arquivo_crud_model');
			$crud->set_table('nwl_cadencia');
			$crud->set_subject('Cadencia');
			
			//$crud->display_as('qnt','Total de E-mails');
			//$crud->unset_add()->unset_edit()->unset_read()->unset_delete();
			
			//$crud->add_action('Informações', '', 'newsletter/painel/informacao_arquivo','fa-info-circle');
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    public function sequencia()
    {
        try{		
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			
			$perfil = $this->session->perfil;
			$state = $crud->getState();
			$state_info = $crud->getStateInfo();
			
			//$crud->set_relation_n_n('Tags', 'nwl_tags_rel', 'nwl_tags', 'id_sequencia', 'id_tag', 'tag');
			
			//$crud->set_relation_n_n('category', 'film_category', 'category', 'film_id', 'category_id', 'name');
			
			//$crud->set_relation('nwl_cadencia','id_cadencia','pagina');
			
			$crud->set_relation('email','nwl_campanha_email','nome',['tipo' => 'Cadencia']);
			
			$crud->set_relation('tag_get','nwl_tags','tag');
			$crud->set_relation('add_tag','nwl_tags','tag');
			$crud->set_relation('remove_tag','nwl_tags','tag');
			
			
			$crud->set_relation('email_false','nwl_campanha_email','nome',['tipo' => 'Cadencia']);
			$crud->set_relation('add_tag_false','nwl_tags','tag');
			$crud->set_relation('remove_tag_false','nwl_tags','tag');
			
			
			$crud->set_relation('email_true','nwl_campanha_email','nome',['tipo' => 'Cadencia']);
			$crud->set_relation('add_tag_true','nwl_tags','tag');
			$crud->set_relation('remove_tag_true','nwl_tags','tag');
			
			$crud->columns(['id_sequencia', 'id_cadencia', 'tag_get', 'intervalo', 'email', 'remove_tag', 'add_tag', 'condicao','remove_tag_true', 'add_tag_true', 'email_false', 'remove_tag_false', 'add_tag_false']);
			
			$crud->set_relation('id_cadencia','nwl_cadencia','pagina');
			
			$crud->set_table('nwl_sequencia');
			$crud->set_subject('Sequencia');
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    public function tags()
    {
        try{		
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			$perfil = $this->session->perfil;
			$state = $crud->getState();
			$state_info = $crud->getStateInfo();
			$crud->set_table('nwl_tags');
			$crud->set_subject('Tags');
			
			$crud->columns( 'id_tag', 'tag','tag_name');
			
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    
    
    
}