<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
include_once GROCERY_CRUD;

class Painel extends Grocery
{
    
    function __construct() 
    {
        parent::__construct();
        $this->load->model('painel_model');
        //$this->load->model('newsletter_model');
    }
    
    public function teste_email()
    {
        $this->load->library('newsletter/newsletter');
        $this->newsletter->enviar_email_campanha('ramon.marques@viewbrasil.com.br', 10);
    }
    public function insert_emails()
    {
        
    /*$emails = array(
        'vendabrasil21@gmail.com',
        'imperialconvites@gmail.com',
        'claudialins14@gmail.com',
        'contato@alugarcadeiras.com.br',
        'geane.borges@gmail.com',
        'eliene.marx.28@gmail.com',
        'contato@paspatur.com.br',
        'contato@anafestasdf.com.br',
        'docedocer@gmail.com',
        'marcosdemelo@gmail.com',
        'mhortencias@gmail.com',
        'clesiafernandes@yahoo.com',
        'contato@casaefesta.com.br',
        'contatosilvanacarvalho@gmail.com',
        'waleriagarcia@hotmail.com',
        'cris.tagino@gmail.com',
        'recdaspalmeiras@gmail.com',
        'flavionascimentofotoseproducoes@hotmail.com',
        'rosaameliadelicias@gmail.com',
        'diiiiegoalessandro@gmail.com',
        'cristianoborges.p@gmail.com',
        'dianamourasposa@hotmail.com',
        'contato@castrosbuffet.com.br',
        'recantooasis@hotmail.com',
        'salaoaquarios@gmail.com',
        'mariaflordecoracoes@gmail.com',
        'armecino@gmail.com',
        'igorborgesfotografia@gmail.com',
        'bellaprovencal@gmail.com',
        'alexandre@milfogos.com.br',
        'barretofotografias@gmail.com',
        'bauereventos@gmail.com',
        'ana.festass@gmail.com',
        'afrosbuffet@hotmail.com',
    );*/
    //$emails = explode(',',$this->emails);

        foreach($emails as $email)
        {
            if(!$this->validaEmail(trim($email)))
            {
                echo('INVALIDO - '.$email.' <br>');
            }
            //echo $this->db->insert('email', array('email'=>$email,'origem'=>'agencia'));
            echo ' - '.$email.'<br>';
        }

    }
    
    public function enviaTermo()
    {
        
        return false;
        
        $cads = $this->cad_model->getCadUsers([['b.termo_uso =',1],['a.banned =',0],['a.activated =',1]]);
        
        /*$cads=[
            (object)['nome'=>'Ricardo','email'=>'ricardo.luis@viewbrasil.com.br'],
            (object)['nome'=>'Filipe','email'=>'filipe@viewbrasil.com.br']
        ];*/
        
        e(count($cads).'<br>');
        
        foreach ($cads as $cad)
        {
            $cad->nome;
            $cad->email;
            
            $data['url'] = base_url('ajuda/39/termos-de-uso-e-relacionamento');
            $data['nome'] = primeiroNome($cad->nome);
            $campanha = 82;
            
            $this->load->library('newsletter/newsletter');
            if(base_url() == "https://comdono.com/")
                $this->newsletter->enviar_email_campanha($cad->email, $campanha, $data);
            
            e($cad->nome.' -------- '.$cad->email.'<br>');
        }
    }
    
   
    private function validaEmail($email) 
    {
        $array_invalidos = array(
            //'@mailinator.com',
            //'@harakirimail.com'
            );
        $syntaxe = '#^[\w.-]+@[\w.-]+\.[a-zA-Z]{2,6}$#';
        if (preg_match($syntaxe, $email))
        {
            foreach($array_invalidos as $invalido)
            {
                $result = strrpos($email, $invalido); //Resultado: 8
                if($result != null)
                {
                   return false;
                }
            }
                    
              return true;
        }
        else 
        {
            return false;
        }
    }
        
    public function enviar_email()
    {		
	    $this->ini_method();
	    
        Assets::add_module_css('newsletter',array(
            'select2',
			//'select2.mim',
			    ));
		Assets::add_module_js('newsletter',array(
            'plugin/multiselect.min',
            'plugin/multiselect',
            'plugin/select2.min',
			'plugin/select2',
			//'select2',
			'painel',
            'long_task',
        ));
        
        $data['campanhas'] = $this->painel_model->get_campanhas($this->session->perfil);
        $data['arquivos'] = $this->painel_model->get_arquivos($this->session->perfil);
        
        $emails_tb = $this->get_emails_tabelas();
        $listas = $this->get_emais_newsletter();
        $listas = array_merge($listas, $this->get_listas_custom());
        
        $data['listas'] = $listas;
        $data['emails_tb'] = $emails_tb;
        
        Template::load_view('newsletter/modal/add_arquivo', '', '', '', $data['modal_add_arquivo']);//echo na view newsletter/long_task_view
        
        Template::set($data);
        Template::set_view('newsletter/long_task_view');
        Template::render();
			
    }
    
    private function get_emails_tabelas()
    {
        $emails_tb = null;
        $conf_tabelas = $this->painel_model->get_config_tb($this->session->perfil);
        if($conf_tabelas != null)
        {
            foreach($conf_tabelas as $key=>$tb)
            {
                $emails = array();
                $campo = $tb->campo;
                $emails_tb[$key]['dt'] =  $tb;
                $emails_get = $this->painel_model->get_emais($tb);
                if($emails_get != null){
                    foreach($emails_get as $email){
                        $emails[] = $email->$campo;
                    }
                }
                
                $emails_tb[$key]['emails'] =  $emails;
            }
        }
        return $emails_tb;
    }
    
    private function get_emais_newsletter()
    {
        $listas = array();
        $origens_db = $this->db->select('DISTINCT`origem`',false)->order_by('origem','asc')->get('nwl_emails')->result();
        if($origens_db != null){
            foreach($origens_db as $dt){
                //--------------------------------------------  
                $array_emails = array();
                $emails = @$this->db->select('DISTINCT`email`',false)
                                    ->where('status !=',2)
                                    ->where('origem',$dt->origem)
                                    ->where('email not in ( select emailAddress from nwl_notifications)')
                                    ->order_by('email','asc')
                                    ->get('nwl_emails')
                                    ->result();
                if($emails !=null)
                    foreach($emails as $dm)
                        $array_emails[] = $dm->email;
                        
                    $listas[] = array(
                        'dt' => (object)array('nome' => 'Newsletter '.$dt->origem),
                        'emails' => $array_emails
                    );
                //--------------------------------------------  
                
                /*$array_emails = array();  
                $emails = @$this->db->select('nwl_log_emails.email email',false)
                                    ->where('status !=',2)
                                    ->where('origem',$dt->origem)
                                    ->where('abriu >',0)
                                    ->where('nwl_log_emails.email not in ( select emailAddress from nwl_notifications)')
                                    ->join('nwl_emails ','nwl_emails.email = nwl_log_emails.email')
                                    ->group_by('nwl_log_emails.email')
                                    ->order_by('nwl_log_emails.email','asc')
                                    ->get('nwl_log_emails')
                                    ->result();  
                    
                if($emails !=null)
                    foreach($emails as $dm)
                        $array_emails[] = $dm->email;
                    
                    $listas[] = array(
                        'dt' => (object)array('nome' => 'Newsletter '.$dt->origem.' abriu'),
                        'emails' => $array_emails
                    );*/
                    
                //--------------------------------------------      
                    
                    /*$array_emails = array();
                    $emails = @$this->db->select('nwl_log_emails.email email',false)
                                        ->where('status !=',2)
                                        ->where('origem',$dt->origem)
                                        ->where('clicou >',0)
                                        ->where('nwl_log_emails.email not in ( select emailAddress from nwl_notifications)')
                                        ->join('nwl_emails ','nwl_emails.email = nwl_log_emails.email')
                                        ->group_by('nwl_log_emails.email')
                                        ->order_by('nwl_log_emails.email','asc')
                                        ->get('nwl_log_emails')
                                        ->result();    
                    
                if($emails !=null)
                    foreach($emails as $dm)
                        $array_emails[] = $dm->email;
                    
                    $listas[] = array(
                        'dt' => (object)array('nome' => 'Newsletter '.$dt->origem.' clicou'),
                        'emails' => $array_emails
                    );*/
                //--------------------------------------------      
                    
            }
        }
        return $listas;
    }
    
    private function get_listas_custom()
    {
        $conf_listas[] = (object)array('tabela' => 'nwl_lista_custom');//<<----Tabela Defaut
        $config_listas_tb = $this->painel_model->get_config_listas();
        
        if($config_listas_tb != null)
            $conf_listas = array_merge($conf_listas, $config_listas_tb);
        $emails_tb = array();
        $sql_listas = array();
        if($conf_listas != null)
        {
            foreach($conf_listas as $db)
            {
                $rst = $this->painel_model->get_listas($db);
                if($rst != null)
                    $sql_listas = array_merge($sql_listas, $rst);
            }
            if(!empty($sql_listas))
            {
                foreach($sql_listas as $key=>$sql_lista)
                {
                    if(isset($sql_lista->nome) && isset($sql_lista->sql) && isset($sql_lista->campo_email) && isset($sql_lista->tipo) )
                    {
                        $results = $this->painel_model->get_sql_lista($sql_lista, $this->session->perfil);
                        if($results != null)
                        {
                            $emails = array();
                            $campo = $sql_lista->campo_email;
                            
                            $emails_tb[$key]['dt'] =  $sql_lista;
                            foreach($results as $result){
                                    if($result->$campo != null)
                                        $emails[] = $result->$campo;
                                }
                            
                            if(empty($emails))
                                 unset($emails_tb[$key]);
                            else
                                $emails_tb[$key]['emails'] =  $emails;
                         }
                    }
                }
            }
        }
        return $emails_tb;
    }
    
    public function enviar_whatsapp($id_lista){
	    
	    //$this->ini_method('eventos');
	    
	    /*Assets::add_css(array(
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/config'
        ));*/
        $array_dev = [6,8];
        $array_prod = [5,6];
        
        if((in_array($id_lista,$array_dev) && base_url() == 'https://dev.comdono.com/') || (in_array($id_lista,$array_prod) && base_url() == 'https://comdono.com/'))
            redirect(base_url('newsletter/painel/enviar_whats_custom/'.$id_lista));
        
        
        $this->dataTables();
			    
		Assets::add_module_js('newsletter',array(
            'enviar_whats',
            
        ));
        
        Assets::add_module_js('atendimento', array(
            'atendimento_geral',
        ));
	    
	    
	    $data['id_lista'] = $id_lista;
	    
	    
	    $data['lista'] = $lista = $this->cad_model->getNewsletterLista(['id', $id_lista]);
	    $data['leads'] = $this->painel_model->get_sql_lista($lista);
	    if($data['leads'] != null)
	        $data['qtd_leads'] = count($data['leads']);
	    else
	        $data['qtd_leads'] = 0;
	        
	    
	    $logs = $this->cad_model->getLogsWhatsapp([['id_lista',$id_lista],['enviado',1]]);
	    foreach($logs as $l){
	        $l->captura = $this->cad_model->getCaptura(['id_captura', $l->id_captura]);
	        if($l->captura == null)
	            $l->captura = $this->cad_model->getCadastro(['id_cadastro', $l->id_cadastro]);
	        $l->config = $this->cad_model->getLogWhatsappConfig(['id_config', $l->id_config]);
	    }
	    $data['log_whats'] = $logs;
	    
	    $data['log_whats_config'] = $this->cad_model->getLogWhatsappConfig(['id_lista', $id_lista]);
	    
	    //dd($data['leads'],$data['log_whats']);
	    
	    /*$data['campanhas'] = $this->painel_model->get_campanhas($this->session->perfil);
	    
	    $data['log_whats'] = $this->cad_model->getLogsWhatsapp([['id_evento',$id_evento],['enviado',1]]);
	    
	    $data['evento'] = $this->cad_model->getEvento([['id_evento', $id_evento]]);
	    $id_emp = $data['evento']->id_empreendimento;
	    
	    $data['empreendimento'] = $this->cad_model->getEmpreendimento([['id_empreendimento', $id_emp]]);
	    $uuid_emp = $data['empreendimento']->uuid_empreendimento;
	    
	    $arquivo = $this->cad_model->getArquivo(['nome',$data['evento']->uuid_evento]);
	    $data['log_emails'] = [];
	    if($arquivo != null){
	        $data['log_emails'] = $this->admin_model->get_log_emails([['enviado',1],['id_arquivo',$arquivo->id_arquivo]]);
	    }*/
	    
        
	    Template::set($data);
        Template::set_view('enviar_whats_view');
        Template::render();
	}
	
	public function enviar_whats_custom($id_lista){
        
        $this->dataTables();
			    
		Assets::add_module_js('newsletter',array(
            'enviar_whats',
            
        ));
        
        Assets::add_module_js('atendimento', array(
            'atendimento_geral',
        ));
	    
	    
	    $data['id_lista'] = $id_lista;
	    
	    //$data['lista'] = $lista = $this->cad_model->getNewsletterLista(['id', $id_lista]);
	    //$this->cad_model->inArrayJson('id_empreendimentos', 50)->getEquipes(['status',1]);

        $this->load->library('newsletter/Lista_Custom');

	    //$data['leads'] = $this->painel_model->get_sql_lista($lista);
	    $leads = $this->lista_custom->get_leads_lista($id_lista);
	    
	    $data['leads'] = $leads;
	    
         
	    if($data['leads'] != null)
	        $data['qtd_leads'] = count($data['leads']);
	    else
	        $data['qtd_leads'] = 0;
	        
	    
	    $logs = $this->cad_model->getLogsWhatsapp([['id_lista',$id_lista],['enviado',1]]);
	    foreach($logs as $l){
	        $l->captura = $this->cad_model->getCaptura(['id_captura', $l->id_captura]);
	        if($l->captura == null)
	            $l->captura = $this->cad_model->getCadastro(['id_cadastro', $l->id_cadastro]);
	        $l->config = $this->cad_model->getLogWhatsappConfig(['id_config', $l->id_config]);
	    }
	    $data['log_whats'] = $logs;
	    
	    $data['log_whats_config'] = $this->cad_model->getLogWhatsappConfig(['id_lista', $id_lista]);

	    Template::set($data);
        Template::set_view('enviar_whats_view');
        Template::render();
	}
	
    public function arquivo()
    {
        try{		
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			
			$perfil = $this->session->perfil;
			$state = $crud->getState();
			$state_info = $crud->getStateInfo();
			
			
			$crud->columns( 'id', 'nome','enviado', 'abriu', 'clicou', 'clicou_site', 'falhou','qnt','datetime');
			$crud->set_model('newsletter/arquivo_crud_model');
			$crud->set_table('nwl_log_emails');
			$crud->set_subject('Arquivo');
			
			$crud->display_as('qnt','Total de E-mails');
			$crud->display_as('datetime','Criado em');
			$crud->unset_add()->unset_edit()->unset_read()->unset_delete();
			
			$crud->add_action('Informações', '', 'newsletter/painel/informacao_arquivo','fa-info-circle');
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    public function campanhas()
    {
        	try{		
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			
			$perfil = $this->session->perfil;
			$state = $crud->getState();
			$state_info = $crud->getStateInfo();
			
			$crud->set_table('nwl_campanha_email');
			$crud->set_subject('Emails');
			$crud->columns( 'id_campanha','UUID', 'nome','campanha', 'subject', 'enviados', 'abertos', 'clicados','clicou_site', 'falhou');
			$crud->add_action('Informações', '', 'newsletter/painel/informacao_campanha','fa-info-circle');
			
			$crud->set_relation('remetente','nwl_config_campanha','from_titulo');
			
			$crud->display_as('id_campanha','ID');
			$crud->display_as('campanha','Título no E-mail');
			$crud->display_as('subject','Assunto');
			$crud->unset_read()->unset_delete();
			
			/*if($perfil > 1)
			{*/
			    /*$crud->where('tipo', 'Externo');
			    $crud->fields('campanha','subject','mensagem','tipo','envio');
			    if($state == 'add' || $state == 'insert')
			    {
			        $crud->fields('campanha','subject','mensagem','envio','tipo','criado_em');
			        $crud->field_type('criado_em', 'hidden', date('Y-m-d H:i:s'));
			    }
			    
			    $crud->field_type('tipo', 'hidden', 'Externo');*/
			/*}
			else
			{
			    
			}*/
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	
    }
    
    
    
    public function config_campanha()
    {
        	try{		
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			$state = $crud->getState();
			$state_info = $crud->getStateInfo();
			
			//if(($state == 'list' || $state == 'success' || $this->uri->segment(5) != 1)  && $state !== 'upload_file' )
			//    redirect(base_url('newsletter/painel/config_campanha/edit/1'));
			
			$crud->unset_back_to_list();
			$crud->set_table('nwl_config_campanha');
			$crud->set_subject('Configurações');
			$crud->set_field_upload('img_cont_view','img');
			$crud->set_field_upload('img_logo_email','img');
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	
    }
    
    public function config_tabelas()
    {
        	try{		
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			
			$crud->set_table('nwl_config_tb_rel');
			$crud->set_subject('Tabelas de relacionamento');
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	public function config_views()
    {
        	try{		
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			
			$crud->set_table('nwl_config_views');
			$crud->set_subject('Views E-mail');
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	
    }
    
    public function config_listas()
    {
        	try{		
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			
			$crud->set_table('nwl_lista_custom');
			$crud->set_subject('Listas Custom');
			//$data['html_custom'] = '<div class="callout callout-info"><h4>Instrução</h4><p>A Tabela de lista adicionada aqui deve conter os seguintes campos: "nome", "sql", "campo_email"</p></div>';
			//Template::set($data);
			$crud->unset_texteditor('sql');
			
			$crud->add_action('Enviar Whatsapp','','newsletter/painel/enviar_whatsapp','fa fa-whatsapp');
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	
    }
    
    public function config_tabelas_listas()
    {
        	try{		
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			
			$crud->set_table('nwl_config_listas');
			$crud->set_subject('Tabelas de listas');
			$data['html_custom'] = '<div class="callout callout-info"><h4>Instrução</h4><p>A Tabela de lista adicionada aqui deve conter os seguintes campos: "nome", "sql", "campo_email"</p></div>';
			Template::set($data);
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	
    }
    
    public function informacao_campanha()
    {
        try{	
            $this->ini_method('campanhas');
            $id_campanha = $this->uri->segment(4);
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			$crud->unset_add()->unset_edit();
			$crud->where('id_campanha',$id_campanha);
			$crud->where('enviado',1);
			$crud->set_table('nwl_log_emails');
			$crud->set_subject('Campanha '.$id_campanha);
			
			$crud->columns('email', 'id_arquivo', 'enviado', 'abriu', 'clicou', 'clicou_site', 'abriu_em');
			//$crud->set_relation('id_email','nwl_emails','email');
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    public function informacao_arquivo()
    {
        try{	
            $this->ini_method('arquivo');
            $id_arquivo = $this->uri->segment(4);
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			$crud->unset_add()->unset_edit();
			$crud->where('id_arquivo',$id_arquivo);
			$crud->where('enviado',1);
			$crud->set_table('nwl_log_emails');
			$crud->set_subject('arquivo '.$id_arquivo);
		    $crud->columns('email', 'id_campanha', 'enviado', 'abriu', 'clicou', 'clicou_site', 'abriu_em');
			//$crud->set_relation('id_email','nwl_emails','email');
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    public function teste()
    {
       // var_dump($this->input->post('Toe0'));
	   var_dump($_POST);
    }
    
    
    public function emails()
    {
        try{		
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			
			
			$crud->set_table('nwl_emails');
			$crud->set_subject('Emails');
			$crud->columns('email', 'nome', 'sobrenome', 'sexo', 'origem', 'status', 'conf_1', 'abriu_conf_1', 'conf_2', 'abriu_conf_2');
			$crud->add_action('Informações', '', 'newsletter/painel/informacao_cadastro','fa-info-circle');
			
			//$crud->field_type('id_tipo_cad', 'hidden',1);
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	
    }
    
    public function contatos()
    {
        try{		
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			
			
			$crud->set_table('vb_contatos');
			$crud->set_subject('contatos');
			
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    public function informacao_cadastro()
    {
        try{	
            $this->ini_method('emails');
            $id_email = $this->uri->segment(4);
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			$crud->where('id_email',$id_email);
			$crud->set_table('nwl_local_cadastro');
			$crud->set_subject('Emails');
			$crud->columns('ip_address', 'http_referer', 'timestamp', 'country', 'region_code', 'city', 'isp');
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    
    public function relatorio_email()
    {
        $this->ini_method();
        if ($this->input->post() == true) 
        {
            $post = $this->input->post();
            if( isset($post['type']) && $post['type'] != null)
            {
                $data['type_search'] = $post['type'];
                $this->session->set_userdata($data);
            }
        }
        $type_search = $this->session->type_search;
		Assets::add_js(array( 'https://www.gstatic.com/charts/loader.js' ));
	    Assets::add_module_js('newsletter',array( "charts"));
	    
	    $emails = $this->painel_model->select_emails();
        $status = $this->painel_model->select_qnt_status();
	    $data = array(
		     'emails_totais'        => count($emails),
		     'emails_ativos'        => (int)$status[1],
		     'emails_pendentes'     => (int)$status[0],
		     'emails_desescritos'   => (int)$status[2],
		     );
		$data['encode'] = json_encode($data,true);
		$data['html_custom'] = $this->load->view('relatorio_email',$data,true);
		Template::set($data);
		
		try{		
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
		    $crud->set_table('nwl_emails');
			$crud->set_subject('E-mails');
			
			if($type_search != null && $type_search != 'false')
			{
			    $crud->where('status', $type_search);
			    if($type_search == 1)
			    {
			        $crud->order_by('ativado_em', 'ASC');
			    }
			}
			
            $crud->order_by('id','desc');
			$crud->columns('email', 'nome', 'sobrenome', 'sexo', 'origem', 'conf_1', 'abriu_conf_1', 'conf_2', 'abriu_conf_2','ativado_em');
			$crud->add_action('Informações', '', 'newsletter/painel/informacao_cadastro','fa-info-circle');
			
			//$crud->field_type('id_tipo_cad', 'hidden',1);
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
		
		
		 
        //$categorias_id = $this->session->cad_categorias;
       // $this->session->unset_userdata('cad_tags');
		//$data['cad_categorias'] = $id_categorias_rel;
        //$this->session->set_userdata($data);
		
		
		//Template::set_view('relatorio_email');
		//Template::render();
	}
    
    public function dataTables(){
	    Assets::add_css(array(
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/dataTables.buttons.min.js',
            '../comdono/plugins/dataTables/js/buttons.flash.min.js',
            '../comdono/plugins/dataTables/js/jszip.min.js',
            '../comdono/plugins/dataTables/js/vfs_fonts.js',
            '../comdono/plugins/dataTables/js/buttons.html5.min.js',
            '../comdono/plugins/dataTables/js/config'
        ));
	}
    
    
    
    
}