<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


class Lista_Custom {
    
    private $CI;
    private static $CIs; 
    
    function __construct() 
    {
        $this->CI =& get_instance();
        self::$CIs =& get_instance();
        //self::$CIs->load->model('newsletter/newsletter_model');
        $this->CI->load->model('administrativo/admin_model');
    } 
    
    public function get_leads_lista($id_lista)
	{
	    // lista custom Le Premier - Gerentes e Corretores ativos em equipes com ao menos 1 acesso
	    if((base_url() == 'https://dev.comdono.com/' && $id_lista == 6) || (base_url() == 'https://comdono.com/' && $id_lista == 5))
	    {
	        $id_empreendimento = 50;
    	    if(base_url() == 'https://comdono.com/')
    	        $id_empreendimento = 16;
    	    
    	    $equipes_db = $this->CI->cad_model->inArrayJson('id_empreendimentos', $id_empreendimento)->getEquipes(['status',1]);// le premier no dev 50, na prod 16 

    	    $leads = [];
            if($equipes_db != null){
                foreach($equipes_db as $equipe){
                    if(isset($equipe->id_cadastros) && !empty($equipe->id_cadastros))
                        foreach($equipe->id_cadastros as $id){
                        $result = $this->CI->db
                                        ->where('a.acessos_sistema >',0) // parceiro
                                        ->where('a.id_cadastro', $id)
                                        ->group_by('a.id_cadastro')
                                        ->join('cad_cadastro as c','c.id_cadastro = a.id_cadastro')
                                        ->get('sys_users as a')
                                        ->row();
                        if(!empty($result) && !isset($leads[$result->email]))
                            $leads[$result->email] = $result;
                    }
                }
                return $leads;
            }
            else return [];
	    }
	    elseif((base_url() == 'https://dev.comdono.com/' && $id_lista == 8) || (base_url() == 'https://comdono.com/' && $id_lista == 6)){// lista custom Le Premier - Pesquisa casa ou apartamento
	        
	        $capturas = $this->CI->db
                            ->where('a.origem_captura','questionario_001')
                            ->where('a.pesquisa !=', '')
                            ->where('a.email NOT LIKE', '%@comdono.com%')
                            //->join('cad_cadastro as c','c.id_cadastro = a.id_cadastro')
                            ->get('cad_captura as a')
                            ->result();
            
	        $leads = [];
	        foreach ($capturas as $k=>$cap)
            {
                //$cadastro = $this->CI->cad_model->getCadastro(['id_cadastro', $cap->id_cadastro]);
                $cap->pesquisa = json_decode($cap->pesquisa);
                $nRespondido  = 13;
                $casa         = 0;
                $apartamento  = 0;
                
                foreach ($cap->pesquisa as $res)
                {
                    if($res->gabarito == 'casa'){
                        $casa++; $nRespondido--;
                    }
                    if($res->gabarito == 'apartamento'){
                        $apartamento++; $nRespondido--;
                    }
                }
                if($casa > $apartamento && $nRespondido <= 0)
                {
                    $leads[] = $cap;
                }
                
            }
            
            if(!empty($leads))
                return $leads;
            else
                return [];
	    }
	    else // lista custom vindo do SQL do banco
	    {
	        $lista = $this->CI->cad_model->getNewsletterLista(['id', $id_lista]);
	        
	        $leads = $this->CI->painel_model->get_sql_lista($lista);
	        
	        return $leads;
	    }
	}
    
}