<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

include 'Pagina.php';

class Captura extends Pagina {

	function __construct()
	{
		parent::__construct();
		$this->load->model('conversao/conversao_model');
	}
	
	public function index($id_pagina = 1)
	{
	    
	    //dd($id_pagina);
	    
	    $proxy = $this->checaProxy();
       
        //$data['pagina'] = $pagina = $this->conversao_model->getPagina([['id_pagina',$id_pagina]]);
        //$id_emp = $pagina->id_empresa;
        $id_emp = 1;
        $id_camp = 1;
	    
	    if($proxy == FALSE){
	        $this->config->set_item('base_site', base_url());
	        $link = base_url(uri_string().'/');
	    }
	    else{
	        $this->config->set_item('base_site', 'https://conversao.viewbrasil.com.br/');
	        $link = base_site('pagina/'.$id_pagina);
	    }
	    $data['link'] = $link;
	    
	    //$this->set_origem_utm($empresa, $link);
        
        Assets::add_module_css('pagina', array(
            "emps/emp_$id_emp/camp_$id_camp/theme",
            "emps/emp_$id_emp/camp_$id_camp/page_a",
            "emps/emp_$id_emp/camp_$id_camp/page_b",
        ));
        
        Assets::add_js(array(
            'plugins/inputmask/inputmask',
            'plugins/inputmask/mascaras'
        ));
        
        $pagina_view = 'page_a';
        if($this->input->get('utm_medium', TRUE) !== NULL && $this->input->get('utm_medium', TRUE) == 'page_b')
            $pagina_view = 'page_b';
        
        if($pagina_view !== 'page_b'){
            Assets::add_css(array(
                'plugins/fancyBox-v3.5.7/jquery.fancybox.min',
            ));
            
            Assets::add_js(array(
                'plugins/fancyBox-v3.5.7/jquery.fancybox.min',
            ));
        }
       
        $data['meta'] = $this->metaTags();
        $this->load_cookie();
        
        Template::set($data);
	    Template::set_view("emps/emp_$id_emp/camp_$id_emp/$pagina_view");
        Template::render();
	}
	
	public function resultado()
    {
        $id_emp = 1;
        $id_camp = 1;
        
        Assets::add_module_css('pagina', array(
            "emps/emp_$id_emp/camp_$id_camp/theme",
            "emps/emp_$id_emp/camp_$id_camp/page_a",
            "emps/emp_$id_emp/camp_$id_camp/page_b",
        ));
        
        $data['pixelFaceLead'] = true;
        $data['meta'] = $this->metaTags();
        
        Template::set($data);
	    Template::set_view("emps/emp_$id_emp/camp_$id_emp/resultado");
        Template::render();
    }
	
	public function metaTags(){
	    return [
	        'keywords' => "Riviera Park Sul, Park Sul, apartamento, lançamento, Park Sul, Brasília-DF, Park Sul - Brasília-DF",
            'site_name' => base_url("empreendimento/riviera-park-sul"),
            'url' => base_url("empreendimento/riviera-park-sul"),
            'title' => "Riviera Park Sul - O Condomínio Mais Seguro e Exclusivo do Park Sul",
            'description' => "Segurança, elegância e conforto. Conheça o Riviera do Park Sul, a elegância da Itália no bairro que mais valoriza no DF. 45% de vendas no lançamento.",
            'image' => (getenv('MEDIA_URL'))."/modules/emps/assets/images/emp/riviera/seo-riviera.jpg",
            'favicon' => (base_url('themes/comdono/img/favicon-comdono.png')),
        ];
	}
}