<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

include 'Pagina.php';

class Captura extends Pagina {

	function __construct()
	{
		parent::__construct();
		$this->load->model('conversao/conversao_model');
	}
	
	public function index($id_pagina=1)
	{
	    $proxy = $this->checaProxy();
       
        $pagina = $this->conversao_model->get_pagina($id_pagina);
        
        $metas = NULL;
        if(!empty($pagina)){
            $campanha        = $this->conversao_model->get_campanha($pagina->id_campanha);
            $id_camp         = $pagina->id_campanha;
            $empresa         = $this->conversao_model->get_empresa($campanha->id_empresa);
            $id_emp          = $campanha->id_empresa;
            $data['scripts'] = $this->conversao_model->get_scripts($id_pagina);
            //dd($data['scripts']);
            $metatag         = $this->conversao_model->get_metatag($pagina->id_metatag);
            if(!empty($metatag)){
                $metas = [
                    'keywords'    => $metatag->keywords,
                    'site_name'   => $metatag->site_name,
                    'url'         => $metatag->url,
                    'title'       => $metatag->title,
                    'description' => $metatag->description,
                    'image'       => base_url("assets/uploads/empresas/$metatag->image"),
                    'favicon'     => base_url("assets/uploads/empresas/$pagina->favicon"),
                ];
            }
            
            if($proxy == FALSE){
    	        $this->config->set_item('base_site', base_url());
    	        $link = base_url(uri_string().'/');
    	    }
    	    else{
    	        $this->config->set_item('base_site', 'https://conversao.viewbrasil.com.br/');
    	        $link = base_site("pagina/$id_pagina");
    	    }
    	    $data['link'] = $link;
    	    //$this->set_origem_utm($empresa, $link);
            
            Assets::add_module_css('pagina', array(
                "emps/emp_$id_emp/camp_$id_camp/theme",
                "emps/emp_$id_emp/camp_$id_camp/page_$id_pagina",
            ));
            // força o método ser sempre index para gerar css e js único
            $this->router->method = "pagina_$id_pagina";
            
            Assets::add_css(array(
                'plugins/animateCss-4.1.1/animate.min'
            ));
            
            Assets::add_js(array(
                'plugins/inputmask/inputmask',
                'plugins/inputmask/mascaras',
            ));
            
            $pagina_view = "emps/emp_$id_emp/camp_$id_camp/page_$id_pagina";
            
            $this->load_cookie($pagina_view,$pagina_view);
           
        }else{
            $pagina_view = "theme/page_not_found";
        }
        
        $data['meta'] = $this->metaTags($metas);
        
        Template::set($data);
	    Template::set_view($pagina_view);
        Template::render();
	}
	
	public function resultado()
    {
        $id_emp = 1;
        $id_camp = 1;
        
        Assets::add_module_css('pagina', array(
            "emps/emp_$id_emp/camp_$id_camp/theme",
            "emps/emp_$id_emp/camp_$id_camp/page_a",
            "emps/emp_$id_emp/camp_$id_camp/page_b",
        ));
        
        // força o método ser sempre index para gerar css e js único
        $this->router->method = "pagina_emp_$id_emp";
        
        $data['pixelFaceLead'] = true;
        
        $metas = [
            'keywords' => "Off Road, 4x4, diversão, aventura, Aula online, ao vivo, Off Road Brasília-DF, Diversão Brasília-DF",
            'site_name' => 'Marcos Gontijo',
            'url' => $link,
            'title' => 'Praticar Off Road com total segurança',
            'description' => 'O que você precisa para iniciar no mundo OFF ROAD.',
            'image' => base_url("assets/img/pagina/emp_2/camp_1/logo_rs.jpg"),
            'favicon' => base_url("assets/img/pagina/emp_2/camp_1/favicon.png"),
        ];
        
        $data['meta'] = $this->metaTags($metas);
        
        Template::set($data);
	    Template::set_view("emps/emp_$id_emp/camp_$id_emp/page_resultado");
        Template::render();
    }
	
	public function metaTags($data){
	    
	    if($data != NULL){
	        return [
    	        'keywords' => $data['keywords'],
                'site_name' => $data['site_name'],
                'url' => $data['url'],
                'title' => $data['title'],
                'description' => $data['description'],
                'image' => $data['image'],
                'favicon' => $data['favicon'],
            ];
	    }else{
	        return [
    	        'keywords' => "Página de conversão, site, landingpage, página rápida, Brasília-DF",
                'site_name' => base_url('pagina/captura/1/1'),
                'url' => base_url('pagina/captura/1/1'),
                'title' => "Conversão - Páginas rápidas",
                'description' => "Capture e engaje contatos de um jeito fácil!",
                'image' => base_url("assets/img/pagina/emp_1/camp_1/logo_rs.jpg"),
                'favicon' => base_url("assets/img/pagina/emp_1/camp_1/favicon.ico"),
            ];
	    }
	}
	
	public function check_file_exists($id_emp,$id_camp,$id_pagina)
    {
        $path = "modules/pagina/views/emps/emp_$id_emp/camp_$id_camp/page_$id_pagina.php";
        
        if(file_exists(APPPATH.$path))
            return TRUE;
        else
            return FALSE;
    }
}