<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Pagina extends CI_Controller {

	function __construct()
	{
		parent::__construct();
	    
		$this->load->library('template');
        $this->load->library('assets');
        $this->load->library('events');
        $this->load->library('newsletter/newsletter');
        $this->load->helper('comdono/comdono');
        
        Template::set_theme('pagina');
        
	    //$this->config->set_item('assets.css_combine',true);
	    
	    Assets::add_css(array(
            'plugins/bootstrap-4.5.3/bootstrap.min',
            '../conversao/plugins/animateCss-4.1.1/animate.min'
        ));
        
        Assets::add_module_js('pagina', array(
            'script_cookie',
            'script_get_form',
            'scripts'
        ));
	}
	
	protected function load_cookie($name = null,$link = null)
	{
    	$this->load->library('aceita_cookie/aceita_cookie');
    	if($name == null and $link == null)
    	    Aceita_cookie::ini('Conversão','conversao.viewbrasil.com.br');
    	else
    	    Aceita_cookie::ini($name,$link);
	}
	
	protected function set_origem_utm($empresa, $link)
	{
	    if($this->input->get('utm_source', TRUE) !== NULL || $this->input->get('fbclid', TRUE) !== NULL)
        {   
            $origem = [
                'origem'        => $empresa->nome,
                'link'          => $link,
                'utm_fbclid'    => $this->input->get('fbclid', TRUE),
                'utm_source'    => $this->input->get('utm_source', TRUE),
                'utm_medium'    => $this->input->get('utm_medium', TRUE),
                'utm_campaign'  => $this->input->get('utm_campaign', TRUE),
                'utm_term'      => $this->input->get('utm_term', TRUE),
                'utm_content'   => $this->input->get('utm_content', TRUE),
            ];
            $this->session->set_userdata('origem', $origem);
        }
	}
	
	public function checaProxy()
	{
	    $test_HTTP_proxy_headers = array(
        	'HTTP_VIA',
        	'VIA',
        	'Proxy-Connection',
        	'HTTP_X_FORWARDED_FOR',  
        	'HTTP_FORWARDED_FOR',
        	'HTTP_X_FORWARDED',
        	'HTTP_FORWARDED',
        	'HTTP_CLIENT_IP',
        	'HTTP_FORWARDED_FOR_IP',
        	'X-PROXY-ID',
        	'MT-PROXY-ID',
        	'X-TINYPROXY',
        	'X_FORWARDED_FOR',
        	'FORWARDED_FOR',
        	'X_FORWARDED',
        	'FORWARDED',
        	'CLIENT-IP',
        	'CLIENT_IP',
        	'PROXY-AGENT',
        	'HTTP_X_CLUSTER_CLIENT_IP',
        	'FORWARDED_FOR_IP',
        	'HTTP_PROXY_CONNECTION');
        	
        	foreach($test_HTTP_proxy_headers as $header){
        		if (isset($_SERVER[$header]) && !empty($_SERVER[$header])) {
        			return TRUE; //proxy detectado
        		}
        	}
        return FALSE;
	}
	
	public function header_scripts($pixelFaceLead = null){
	    $data = [];
	    if($pixelFaceLead != null)
	        $data['pixelFaceLead'] = $pixelFaceLead;
	        
	    $this->load->view('theme/header_scripts',$data);
	}
}