<?php defined('BASEPATH') || exit('No direct script access allowed');
/**
 * VBproject
 *
 * An open source project to allow developers to jumpstart their development of
 * CodeIgniter applications
 *
 * @package   VBproject
 * @author    ViewBrasil Dev Team
 * @copyright Copyright (c) 2013 - 2015, ViewBrasil Dev Team
 * @license   Proprietary software
 * @link      http://viewbrasil.com.br
 * @since     Version 1.0
 * @filesource
 */

/**
 * Menu Class
 *
 * This class helps in menu creation and treat their permissions
 *
 * @package Builder\Libraries\Menu
 * @author  ViewBrasil Dev Team
 * @link    ...
 */

 
class Menu_lib
{
    /** @var object The CodeIgniter core object. */
    protected static $ci;
    protected static $perfil;

    /**
     * Constructor
     *
     * Support for loading in CI. Gets the CI instance and calls the init() method.
     *
     * @return void
     */
    public function __construct()
    {
        self::$ci =& get_instance();
        self::init();
    }

    /**
     * Initialize the assets library
     *
     * Loads the config file and inserts the base css and js into the arrays for
     * later use. This ensures that the base files will be processed in the
     * order the user expects.
     *
     * @return void
     */
    public static function init()
    {	
        log_message('debug', 'Menu library loaded.');
        
        self::$ci->load->model('modulos_model');
        
        self::$ci->load->model('sistema/perfil_model');
        self::$ci->perfil = self::$ci->perfil_model->consultar_perfil(self::$ci->session->perfil);
        
        Template::set('tipo_menu', self::$ci->perfil->tipo_menu);
    }
    
    public static function list_active_modules()
    {
    	return self::$ci->modulos_model->list_active_modules();   	 
    }
    
    public static function list_all_sections_by_module_id($id_module)
    {
    	return self::$ci->modulos_model->list_sections_by_module($id_module,1,1,2);   	
    }
    
    public static function active($id_module)
    {
    	if(defined('MENU') && MENU == $id_module) return 'active';
    	return;
    }
    
    public static function generate_builder_menu($permissoes)
    {
        $permissoes['result'] = self::$ci->session->flashdata('menu_active');
        
	    if((int)self::$ci->perfil->tipo_menu === 1)
	    {
	        //Assets::add_js(array(Template::theme_url().'js/menu_modulo'));
	        return Menu_lib::generate_full_menu($permissoes);
	    }
	    else
	    {
	       return Menu_lib::generate_section_menu($permissoes); 
	    }
    }
    
    public static function generate_top_menu($permissoes)
    {
        $permissoes['result'] = self::$ci->session->flashdata('menu_active');
        
	    if((int)self::$ci->perfil->tipo_menu === 1)
	    {
	        return Menu_lib::generate_full_top_menu($permissoes);
	    }
	    else
	    {
	        return Menu_lib::generate_full_top_menu($permissoes);
	       // return Menu_lib::generate_section_top_menu($permissoes); 
	    }
    }
    
    public static function generate_full_menu($permissoes)
    {
	    $active_modules = Menu_lib::list_active_modules();
	    $html = '';
	    
	    if(!empty($active_modules))
	    {
	    	foreach ($active_modules as $module)
	    	{
	    		/*$module_sections = Menu_lib::list_all_sections_by_module_id($module->id_module);*/
	    		
	    		if(isset($permissoes) && array_key_exists($module->id_module, $permissoes) && $module->visible == 1 )
	    		{
	    			switch ($module->type)
	    			{
	    				case 1:    					
	    					$html .= '<li class="'.Menu_lib::active($module->id_module).'">';
    						$html .= '<a href="'.base_url().$module->nickname.'/'.$module->class.'/'.$module->method.'">';
    						$html .= '<i class="'.$module->icon.'"></i> <span>'.$module->name.'</span>';
    						$html .= '</a>';
    						$html .= '</li>';
    					break;
    					case 2:
    						$html .= '<li class="'.Menu_lib::active($module->id_module).'">';
    						$html .= '<a href="#" data-module="'.$module->id_module.'" class="link-menu-extends">';
    						$html .= '<i class="'.$module->icon.'"></i> <span>'.$module->name.'</span>';
    						$html .= '</a>';
    						$html .= '</li>';
    					break;
	    			}
	    		}
	    	}
	    }
	    return $html;
    }
    
    public static function generate_full_top_menu($permissoes)
    {
	    $active_modules = Menu_lib::list_active_modules();
	    $html = '';
	    
	    if(!empty($active_modules))
	    {
	    	foreach ($active_modules as $module)
	    	{
	    		if(isset($permissoes) && array_key_exists($module->id_module, $permissoes) && $module->visible == 1 )
	    		{
	    			switch ($module->type)
	    			{
    					case 1:    					
	    					$html .= '<li class="'.Menu_lib::active($module->id_module).'">';
	    					$html .= '<a href="'.base_url().$module->nickname.'/'.$module->class.'/'.$module->method.'">'.$module->name.'</a>';
    						$html .= '</li>';
    					break;
    					
    					case 2:    					
	    					$html .= Menu_lib::generate_modulo_menu($module->id_module,$permissoes,'top')['html'];
    					break;
	    			}
	    		}
	    	}
	    }
	    return $html;
    }
    
    public static function generate_section_menu($permissoes)
    {
	    $active_modules = Menu_lib::list_active_modules();
	    $html = '';
	    
	    if(!empty($active_modules))
	    {
	    	foreach ($active_modules as $module)
	    	{
	    		if(isset($permissoes) && array_key_exists($module->id_module, $permissoes) && $module->visible == 1 )
	    		{
	    			switch ($module->type)
	    			{
	    				/*case 1:    					
	    					$html .= '<li class="'.Menu_lib::active($module->id_module).'">';
    						$html .= '<a href="'.base_url().$module->nickname.'/'.$module->class.'/'.$module->method.'">';
    						$html .= '<i class="'.$module->icon.'"></i> <span>'.$module->name.'</span>';
    						$html .= '</a>';
    						$html .= '</li>';
    					break;*/
    					case 2:
    						$html .= Menu_lib::generate_modulo_menu($module->id_module,$permissoes)['html'];
    					break;
	    			}
	    		}
	    	}
	    }
	    return $html;
    }
    
    public static function generate_modulo_menu($id_module,$permissions,$position = 'left')
    {    	
	    if(!empty($id_module))
	    {	    
	    	$data['module'] = self::$ci->modulos_model->get_module_by_id($id_module);
	    
	    	if($data['module'] !== NULL && $data['module']->active == 1)
	    	{
	    		$perfil = self::$ci->session->userdata('perfil');
	    			
	    		$data['access'] = self::$ci->modulos_model->list_module_access($id_module,$perfil);
	    		
	    		if($data['access'] !== NULL)
	    		{
	    			$result['show'] = true;
	    			$result['modulo_icone'] = $data['module']->icon;
	    			
	    			if(isset($permissions['result']))
	    			{	    			
	    				$data['active'] = $permissions['result'];	    				
	    			}
	    
	    			$data['sections'] = self::$ci->modulos_model->list_sections_by_module($id_module,1,1,2);
	    
	    			$data['subsections'] = self::$ci->modulos_model->list_subsections_by_module($id_module,1,1,2);
	    
	                if($position === 'left')
	                {
	                    $result['html'] = Menu_lib::create_modulo_menu_html($data);
	                }
	                else
	                {
	                    $result['html'] = Menu_lib::create_modulo_menu_top_html($data);
	                }
	                
	    			return $result;
	    		}
	    	}
	    }
    }
    
    private static function array_search_by_position_value($array, $field, $value)
    {
    	foreach($array as $key => $arr)
    	{
    		if ( $arr->$field === $value )
    			return TRUE;
    	}
    	return false;
    }
    
    private static function array_search_by_two_position_values($array, $field1, $value1, $field2, $value2)
    {
    	foreach($array as $key => $arr)
    	{
    		if ( $arr->$field1 === $value1 && $arr->$field2 === $value2)
    			return TRUE;
    	}
    	return false;
    }
   
    private static function create_modulo_menu_top_html($params)
    {
        $html  = '<li class="dropdown mega-dropdown">';
        $html .= '<a href="#" class="dropdown-toggle" data-toggle="dropdown">'.$params['module']->name.' <span class="caret"></span></a>';
        $html .= '<ul class="dropdown-menu mega-dropdown-menu">';

        /*<li class="dropdown mega-dropdown">
    		
    		<a href="#" class="dropdown-toggle" data-toggle="dropdown">Módulo <span class="caret"></span></a>				
    		
    		<ul class="dropdown-menu mega-dropdown-menu">
    			<li class="col-sm-4">
    				<ul>
    					<li class="dropdown-header">Sessão</li>
    					<?php for($i = 1; $i <= 3; $i++ ){?>
    					<li><a href="#">Subsessão <?php echo $i ?></a></li>
    					<?php } ?>
    				</ul>
    			</li>
    		</ul>
       </li>*/
        
        $html1  = "";
        $html2  = "";
    	foreach ($params['sections'] as $section)
    	{
    		if(Menu_lib::array_search_by_position_value($params['access'], 'id_section', $section->id_section))
    		{
    			switch ($section->type)
    			{
    				case 1:
    					if(isset($params['active']) && $params['active']->id_section == $section->id_section)
    					{
    						$active = 'active';
    					}
    					else
    					{
    						$active = '';
    					}
    					if(empty($html1))
    					{
    					    $html1 .= '<ul class="col-sm-4">';
    					}
					    $html1 .= '<li class="dropdown-header '.$active.'"><a href="'.base_url().$params['module']->nickname.'/'.$section->class.'/'.$section->method.'">'.$section->name.'</a></li>';
                    break;
    				case 2:
    					if(isset($params['active']) && $params['active']->id_section == $section->id_section)
    					{
    						$active = 'active';					
    					}
    					else 
    					{
    						$active = '';
    					}
    					
    					$html2 .= '<ul class="col-sm-4">';
    					$html2 .= '<li class="dropdown-header title-menu-header">'.$section->name.'</li>';
                        $html2 .= '<ul>';
    					
    					foreach ($params['subsections'] as $subsection)
    					{
    						if (Menu_lib::array_search_by_two_position_values($params['access'], 'id_subsection', $subsection->id_subsection, 'id_section', $section->id_section))
    						{
    							if(isset($params['active']->id_subsection) && $params['active']->id_subsection == $subsection->id_subsection)
    							{
    								$active = 'active';	
    							}
    							else
    							{
    								$active = '';
    							}
                                $html2 .= '<li><a href="'.base_url().$params['module']->nickname.'/'.$subsection->class.'/'.$subsection->method.'">';
                                $html2 .= $subsection->name.'</a></li>';
    						}
    					}
                        $html2 .= '</ul>';
                        $html2 .= '</li>';
                        $html2 .= '</ul>';
					break;
    			}
    		}
    	}
    	if(!empty($html1))
    	{
    	    $html1 .= '</ul>';
    	}
    	$html .= $html1;
    	$html .= $html2;
    	$html .= '</ul>';
    	$html .= '</li>';
    
    	return $html;
       
    }
    
    private static function create_modulo_menu_html($params)
    {
        $html = '';
        
	    if((int)self::$ci->perfil->tipo_menu === 1)
	    {
	        $html .= '<h4 class="control-menu-heading ">'.$params['module']->name.'</h4>';
	    }
    	
    	$html .= '<ul class="sidebar-menu">';
    	foreach ($params['sections'] as $section)
    	{
    		if(Menu_lib::array_search_by_position_value($params['access'], 'id_section', $section->id_section))
    		{
    			switch ($section->type)
    			{
    				case 1:
    					if(isset($params['active']) && $params['active']->id_section == $section->id_section)
    					{
    						$html .= '<li class="active">';
    					}
    					else
    					{
    						$html .= '<li>';
    					}
    					$html .= '<a href="'.base_url().$params['module']->nickname.'/'.$section->class.'/'.$section->method.'">';
    					$html .= '<i class="'.$section->icon.'"></i> <span>'.$section->name.'</span>';
    					$html .= '</a>';
    					$html .= '</li>';
    					break;
    				case 2:
    					if(isset($params['active']) && $params['active']->id_section == $section->id_section)
    					{
    						$html .= '<li class="treeview active">';    						
    					}
    					else 
    					{
    						$html .= '<li class="treeview 1">';
    					}
    					$html .= '<a href="#">';
    					$html .= '<i class="'.$section->icon.'"></i> <span>'.$section->name.'</span>';
    					$html .= '<i class="fa fa-angle-left pull-right"></i>';
    					$html .= '</a>';
    					$html .= '<ul class="treeview-menu">';
    					foreach ($params['subsections'] as $subsection)
    					{
    						if (Menu_lib::array_search_by_two_position_values($params['access'], 'id_subsection', $subsection->id_subsection, 'id_section', $section->id_section))
    						{
    							if(isset($params['active']->id_subsection) && $params['active']->id_subsection == $subsection->id_subsection)
    							{
    								$html .= '<li class="active">';
    							}
    							else
    							{
    								$html .= '<li>';
    							}
    							$html .= '<a href="'.base_url().$params['module']->nickname.'/'.$subsection->class.'/'.$subsection->method.'">';
    							$html .= '<i class="fa fa-caret-right"></i>'.$subsection->name;
    							$html .= '</a>';
    							$html .= '</li>';
    						}
    					}
    					$html .= '</ul>';
    					$html .= '</li>';
    					break;
    			}
    		}
    	}
    	$html .= '</ul>';
    
    	return $html;
    }

}
/* End /libraries/menu.php */