<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Area_restrita extends Admin_Controller {

	private $anexo;
	private $anexo_path = 'tmp';
	
    function __construct() 
    {
        parent::__construct();
    }
    
    public function index() 
    { 
        $data = $this->session->all_userdata();
        
        $this->load->helper(array('form'));
		$this->load->library('form_validation');
		$this->form_validation->set_rules('mensagem', 'Mensagem', 'required');
		if (isset($_FILES['file']['name']) && !empty($_FILES['file']['name'])) {
			$this->form_validation->set_rules('file', 'Anexo', 'callback_realiza_upload');		
		}
		
		if ($this->input->post() == TRUE)
        { 
            if ($this->form_validation->run() != FALSE)
            {   
                $msg = $this->input->post('mensagem');
                $file = $this->anexo;
                $this->envia_suporte($msg,$file,$data);
                $this->delete_file($file);
            }
            else 
            { 
                $this->session->set_flashdata('message', 'error::'.validation_errors()); 
            	//$data['errors'] = validation_errors();
            }
		}

        
    	$data['sessao'] = $this->session->all_userdata();
    	
    	Assets::add_module_css('auth',array( 'jquery.rateyo.min','area_restrita','custom','progress-bar'));
	    //Assets::add_module_js('auth',array( 'jquery.rateyo.min','tour','progress-bar','area_restrita' ));
	    //Assets::add_module_js('financeiro',array('statusPagseguro','pagamento'));
    	
    	$data['first_view'] = $this->session->first_view; 
    	if($data['n_acessos_sistema'] == 1 && $data['first_view'] === NULL)
    	{
    	    $this->session->set_userdata('first_view', FALSE); 
    	    $data['first_view'] = 1;
    	}
    	else
    	{
    	    $data['first_view'] = 0;
    	}
    	    
    	Assets::add_css(array( 'plugins/jasny-bootstrap-3.1.3/css/jasny-bootstrap.min' ));
    	Assets::add_js(array( 'plugins/jasny-bootstrap-3.1.3/js/jasny-bootstrap.min' ));
    	
    	//$data['vld_user'] = Financeiro::getStatusAssinatura();
    	//$data['fnc_assinatura'] = Financeiro::getAssinatura();
    	$data['display_pesquisa'] = FALSE;// $this->display_pesquisa();
    	
    	$flash_pesquisa = $this->session->flashdata('pesquisa');
    	
    	if($flash_pesquisa !== NULL)
    	{
    	    if($flash_pesquisa === TRUE)
    	    {
            	$data['showModal'] = array(
            	    'title'=>'Pesquisa Respondida com Sucesso',
            	    'content'=>'<p>Obrigado por responder à nossa pesquisa.</p><p>A sua opinião é muito importante para nós.</p><p>Aproveite mais 7 dias grátis e veja a oferta que temos para você no menu Assinatura.</p>',
            	    'class'=>'success',
                );
    	    }
    	    else
    	    {
    	        log_message('error','Falha de Comunicação - Erro ao gravar no banco.');
            	$data['showModal'] = array(
            	    'title'=>'Falha de Comunicação',
            	    'content'=>'<p>Não foi possível concluir a pesquisa, tente novamente mais tarde.</p>',
            	    'class'=>'danger',
                );
    	    }
    	}
    	
    	
    	
    	
    	
		Template::set($data);
		 
		Template::set_view('sistema/dashboard');
		
		Template::render();
    } 
    
    /*public function index() 
    { 
        $data = $this->session->all_userdata();
        
        $this->load->helper(array('form'));
		$this->load->library('form_validation');
		$this->form_validation->set_rules('mensagem', 'Mensagem', 'required');
		if (isset($_FILES['file']['name']) && !empty($_FILES['file']['name'])) {
			$this->form_validation->set_rules('file', 'Anexo', 'callback_realiza_upload');		
		}
		
		if ($this->input->post() == TRUE)
        { 
            if ($this->form_validation->run() != FALSE)
            {   
                $msg = $this->input->post('mensagem');
                $file = $this->anexo;
                $this->envia_suporte($msg,$file,$data);
                $this->delete_file($file);
            }
            else 
            { 
                $this->session->set_flashdata('message', 'error::'.validation_errors()); 
            	//$data['errors'] = validation_errors();
            }
		}

    	$data['sessao'] = $this->session->all_userdata();
    	
    	Assets::add_module_css('auth',array( 'jquery.rateyo.min','area_restrita','custom','progress-bar'));
	    Assets::add_module_js('auth',array( 'jquery.rateyo.min','tour','progress-bar','area_restrita' ));
	    Assets::add_module_js('financeiro',array('statusPagseguro','pagamento'));
    	
    	$data['first_view'] = $this->session->first_view; 
    	if($data['n_acessos_sistema'] == 1 && $data['first_view'] === NULL)
    	{
    	    $this->session->set_userdata('first_view', FALSE); 
    	    $data['first_view'] = 1;
    	}
    	else
    	{
    	    $data['first_view'] = 0;
    	}
    	    
    	Assets::add_css(array( 'plugins/jasny-bootstrap-3.1.3/css/jasny-bootstrap.min' ));
    	Assets::add_js(array( 'plugins/jasny-bootstrap-3.1.3/js/jasny-bootstrap.min' ));
    	
    	//$data['vld_user'] = Financeiro::getStatusAssinatura();
    	//$data['fnc_assinatura'] = Financeiro::getAssinatura();
    	$data['display_pesquisa'] = FALSE;// $this->display_pesquisa();
    	
    	$flash_pesquisa = $this->session->flashdata('pesquisa');
    	
    	if($flash_pesquisa !== NULL)
    	{
    	    if($flash_pesquisa === TRUE)
    	    {
            	$data['showModal'] = array(
            	    'title'=>'Pesquisa Respondida com Sucesso',
            	    'content'=>'<p>Obrigado por responder à nossa pesquisa.</p><p>A sua opinião é muito importante para nós.</p><p>Aproveite mais 7 dias grátis e veja a oferta que temos para você no menu Assinatura.</p>',
            	    'class'=>'success',
                );
    	    }
    	    else
    	    {
    	        log_message('error','Falha de Comunicação - Erro ao gravar no banco.');
            	$data['showModal'] = array(
            	    'title'=>'Falha de Comunicação',
            	    'content'=>'<p>Não foi possível concluir a pesquisa, tente novamente mais tarde.</p>',
            	    'class'=>'danger',
                );
    	    }
    	}
    	
    	
		Template::set($data);
		 
		Template::set_view('area_restrita_view');
		
		Template::render();
    }*/ 
    
    private function display_pesquisa()
    {
        $this->load->model('auth/users_model');
        $user = $this->users_model->get_user_by_id($this->session->user_id, 1);
        
        if($user == NULL)
            return NULL;
    
        $date_fim_teste = date("Y-m-d H:i:s", strtotime( $user->activated_in." +7 day" ) );
        if($date_fim_teste > date("Y-m-d H:i:s"))
        {
            return FALSE;
        }
        else
        {
            $assinaturas = @$this->db->where('id_user',$user->id)->order_by('id_assinatura', 'desc')->get('fnc_assinatura')->result();
            if($assinaturas == null)
                return TRUE;
            else
                return FALSE;
        }
        return TRUE;
    }
    
    public function pesquisa() 
    {
        $post = $this->input->post();
        
        if(!is_array($post) || count($post) !== 6 )
        {
            echo('erro');
        }
        else
        {
            $insert['id_pesquisa'] = $post['pesquisa'];
            $insert['id_user'] = $this->session->user_id;
            $insert['respostas'] = json_encode($post,JSON_UNESCAPED_UNICODE);
            $this->load->model('pesquisa_model');
            $inserted = $this->pesquisa_model->insert('fed_pesquisa',$insert);
            
            if($inserted !== NULL)
            {
                $dt = date("Y-m-d H:i:s");
                $assinatura = array(
                    'id_user'   => $this->session->user_id,
                    'code'      => 'bonus',
                    'status'    => 'ACTIVE',
                    'validade'  => date( "Y-m-d H:i:s", strtotime( "$dt +7 day" ) )
                );
                $inserted = $this->pesquisa_model->insert('fnc_assinatura',$assinatura);
                
                if($inserted)
                {
                    $this->session->set_flashdata('pesquisa',TRUE);
                    redirect('painel/area_restrita');
                }
                $this->session->set_flashdata('pesquisa',FALSE);
                redirect('painel/area_restrita');
            }
        }
    }
    
    function realiza_upload()
    {
        $config['upload_path'] =  $this->anexo_path;
        $config['allowed_types'] = 'jpg';
        $config['max_size']	= '100000';
    
        $this->load->library('upload', $config);
    
        $field_name = "file";
    
        if ($this->upload->do_upload($field_name))
        {
            $data_upload = array('upload_data' => $this->upload->data());
    
            $this->anexo = $data_upload['upload_data']['file_name'];
             
            return TRUE;
        }
        else
        {
            $this->form_validation->set_message('realiza_upload',$this->upload->display_errors());
    
            $this->anexo = '';
             
            return FALSE;
        }
    }
    
    private function envia_suporte($msg,$file,$user)
    {
        $this->load->library( 'Email' );
    
        $config ['protocol'] = 'sendmail';
        $config ['mailpath'] = '/usr/sbin/sendmail';
        $config ['charset'] = 'utf-8';
        $config ['wordwrap'] = TRUE;
        $this->email->initialize($config);
        
        if (!empty($file))
        {
            $anexo_file = $this->email->attach($this->anexo_path.'/'.$file);
        }
        else 
        {
            $anexo_file = "";
            $file = "Sem Anexo";
        }    
        
        $message = "Contato realizado através do Blog VB <br />
        Nome: ". $user['nome']."<br />
        Login: ". $user['username']."<br />
        E-mail: ". $user['email']."<br />
        Mensagem: $msg <br />
        Anexo: $file";
        
        $this->email->to ('filipe@viewbrasil.com.br');
        $this->email->reply_to($user['email'], $user['nome']);
        $this->email->from ('contato@dtecweb.com.br', $this->config->item('title_site'));
        $this->email->subject ('Suporte através do Blog VB');
        // $anexo_file;
        $this->email->message ($message);
    
        if ($this->email->send())
        {
            $this->delete_file($file);
            $this->session->set_flashdata('message', 'success::Mensagem enviada com sucesso'); 
            redirect('painel/area_restrita');
        }
        else
        {
            $this->delete_file($file);
            $this->session->set_flashdata('message', 'error::Erro ao enviar mensagem'); 
            redirect('painel/area_restrita');
        }
    }   
    
    private function delete_file($file)
    {
        if(file_exists($file))
        {
            unlink($file);
        }
    }
}