<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Security_key
 *
 * Security key library for Code Igniter.
 *
 * @package		Security_key
 * @author		Filipe F Freitas (http://viewbrasil.com.br/)
 * @version		1.0
 * @based on	RSA PHPSeclib (http://phpseclib.sourceforge.net)
 * @license		MIT License Copyright (c) 2008 Erick Hartanto
 */

class Security_key {

    private $CI;
    
	function __construct()
	{
		$this->CI =& get_instance();
		
	}
	
	final public function crete_key()
	{
	    $controle = 0;
	    $limite = 10;
	    while ($controle < $limite) {
	    
	    	$id_rsa = $this->generate_key();
	    	
	    	if ($id_rsa != NULL)
	    	{
	    		return $id_rsa;
	    	}
	    	else
	    	{
	    		$controle++;
	    	}
	    }
	    
	    return 'Erro ao criar chave RSA. Tente novamente ou entre em contato com o suporte técnico.'; // $this->CI->lang->line('error_create_rsa')
	    
	}
	
	final private function generate_key()
	{
	    $this->CI->load->library('phpseclib/Crypt/RSA');
	
		$rsa = new RSA();
	
		$rsa->Crypt_RSA();
		 
		extract($rsa->createKey(1024));
		
		$id_rsa = $this->_set_public_key($publickey);
		
		if($id_rsa != NULL)
		{
		    $private_set = $this->_set_private_key($id_rsa,$privatekey);
		    
		    if ($private_set != NULL) {
		        
		        $this->save_id_rsa_on_session($id_rsa);
		        
		        return $id_rsa;
		    } 
		    
		}				
		return NULL;		
	}
	
	final private function save_id_rsa_on_session($id_rsa)
	{
	    $this->CI->session->set_userdata('id_rsa',$id_rsa);
	}
	
	final public function decrypt_str($str,$id_rsa)
	{
    	$this->CI->load->library('phpseclib/Crypt/RSA');
    
    	define("CRYPT_RSA_MODE", CRYPT_RSA_MODE_INTERNAL);
    
    	$rsa = new RSA();
    
    	$rsa->Crypt_RSA();
    
	    $private_key = $this->get_private_key($id_rsa);
	    
	    if(empty($private_key))
	    {
	        log_message('error','Class: Security_key | private_key not is set');
	    }
	    else
	    {
	        // log_message('debug','Class: Security_key | private_key is set: id:'.$id_rsa.' key: '.$private_key);
	    }
	    
    	$strBase64CipherText = $str;
	    
    	$strPrivateKey = preg_replace("/[ \t]/", "", $private_key);//this won't be necessary when loading from PEM
    
    	$rsa->loadKey($strPrivateKey);
    
    	$binaryCiphertext = base64_decode($strBase64CipherText);
    
    	$rsa->setEncryptionMode(CRYPT_RSA_ENCRYPTION_PKCS1);
    	$strBase64DecryptedData = $rsa->decrypt($binaryCiphertext);
    
    	return base64_decode($strBase64DecryptedData);
	    
	}
	
	final public function _set_public_key($public_key)
	{
	    $this->CI->load->model('seguranca_model');
	    return $this->CI->seguranca_model->set_public_key($public_key);
	}
	
	final public function _set_private_key($id_rsa,$private_key)
	{
		$this->CI->load->model('seguranca_model');
	    return $this->CI->seguranca_model->set_private_key($id_rsa,$private_key);
	}
	
	final public function get_public_key($id_rsa)
	{
	    $this->CI->load->model('seguranca_model');
		return $this->CI->seguranca_model->get_public_key($id_rsa);
	}
	
	final public function get_private_key($id_rsa)
	{
		$this->CI->load->model('seguranca_model');
		return $this->CI->seguranca_model->get_private_key($id_rsa);
	}
}

/* End of file security_key.php */
/* Location: ./application/libraries/security_key.php */