<?php

if ($this->config->item('use_username', 'tank_auth')) {
	$login_label = 'Login';
} else {
	$login_label = 'E-mail';
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><?php echo $this->config->item('title_site') ?></title>
	<link rel="shortcut icon" href="<?php echo base_url().'assets/painel/img/favicon.ico'?>" type="image/x-icon" />
	<meta name="robots" content="noindex, nofollow" />

	<!-- Global stylesheets -->
	<link href="<?php echo base_url()?>assets/painel/css/crown/common.css" rel="stylesheet" type="text/css">
	<link href="<?php echo base_url()?>assets/painel/css/crown/form.css" rel="stylesheet" type="text/css">
	<link href="<?php echo base_url()?>assets/painel/css/crown/standard.css" rel="stylesheet" type="text/css">
	<!-- <link href="<?php echo base_url()?>assets/painel/css/special-pages.css" rel="stylesheet" type="text/css"> -->
	
	<!-- Generic libs -->
	
	<script type="text/javascript" src="<?php echo base_url()?>assets/js_libraries/jquery-1.11.1.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url()?>assets/js_libraries/jquery-migrate-1.2.1.min.js"></script>
	
	<script type="text/javascript" src="<?php echo base_url()?>assets/painel/js/crown/html5.js"></script>
	<script type="text/javascript" src="<?php echo base_url()?>assets/painel/js/crown/common.js"></script>
	<script type="text/javascript" src="<?php echo base_url()?>assets/painel/js/crown/standard.js"></script>
	<!-- <script type="text/javascript" src="<?php echo base_url()?>assets/painel/js/jquery.tip.js"></script> -->
	
	<!--[if lte IE 8]><script type="text/javascript" src="assets/painel/js/standard.ie.js"></script><![endif]-->
	
	<script type="text/javascript" src="<?php echo base_url()?>assets/painel/js/login/login.js"></script>
	
</head>

<!-- the 'special-page' class is only an identifier for scripts -->
<body class="special-page login-bg dark" onload="document.forms['login-form'].login.focus();">
<!-- The template uses conditional comments to add wrappers div for ie8 and ie7 - just add .ie, .ie7 or .ie6 prefix to your css selectors when needed -->
<!--[if lt IE 9]><div class="ie"><![endif]-->
<!--[if lt IE 8]><div class="ie7"><![endif]-->

<div id="base_url" rel="<?php echo base_url()?>"></div>

<div id="login-center" align="center">
	<div id="login-content">

	<section id="message">
		<div class="block-border"><div class="block-content no-title dark-bg">
			<img src="<?php echo base_url().'assets/painel/img/logo-jkanuncios.jpg'?>" alt="" />
		</div></div>
	</section>
	
	<section id="login-block">
		<div class="block-border"><div class="block-content">
				
			<h1>Painel Administrativo</h1>
			<div class="block-header">Área Restrita</div>	
			
			<div class="block-padding">
			
			<?php if ($this->config->item('allow_registration', 'tank_auth')) echo anchor('/painel/auth/register/', 'Register'); ?>
			
			<form class="form with-margin" name="login-form" id="login-form" method="post" action="<?php echo base_url().'painel/auth/login'?>">
				<p class="inline-small-label">
					<label for="login"><span class="big"><?php echo $login_label;?></span></label>
					<input type="text" name="login" id="login" class="full-width" value="">
				</p>
				<p class="inline-small-label">
					<label for="pass"><span class="big">Senha</span></label>
					<input type="password" name="senha" id="pass" class="full-width" value="">
				</p>
				
				<div class="captcha" <?php if (!$show_captcha) echo 'style="display:none"'; ?>>
				<p class="inline-small-label">
					<?php echo $captcha_html; ?>
				</p>
				<p class="inline-small-label">
					<label for="pass"><span class="big">Captcha</span></label>
					<input type="text" name="captcha" id="captcha" class="full-width" value="">
				</p>
				</div>
				
				<button type="submit" class="float-right">Login</button>
				<p class="input-height">
					<input type="checkbox" name="remember" id="keep-logged" value="1" class="mini-switch" checked="checked">
					<label for="keep-logged" class="inline">Mantenha-me conectado</label>
				</p>
			</form>
			
			<form class="form" id="password-recovery" method="post" action="<?php echo base_url().'painel/esqueci_minha_senha'?>" align="left">
				<fieldset class="grey-bg no-margin collapse">
					<legend align="left"><a href="#">Esqueceu sua senha?</a></legend>
					<p class="input-with-button" align="left">
						<label for="recovery-mail">Insira o seu e-mail</label>
						<input type="text" name="recovery-mail" id="recovery-mail" value="" autocomplete="off">
						<button type="submit">Enviar</button>
					</p>
				</fieldset>
			</form>
			
			</div><!-- fim da div block-padding-->
			
		</div></div>
	</section>
	</div>	
</div>
<!--[if lt IE 8]></div><![endif]-->
<!--[if lt IE 9]></div><![endif]-->
</body>
</html>