<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Grocery extends Admin_Controller 
{
	
	function __construct()
	{
		parent::__construct();
		
		$this->load->library('grocery/Custom_Grocery_CRUD');
	}
	
	protected function _example_output($output = null)
	{		
		Assets::add_css($output->css_files);
		
		Assets::add_js($output->js_files);
		
		$data['output'] = $output->output;
		
		Template::set($data);
		 
		Template::set_view('grocery/grocery_view');
		
		Template::render();
	}
	
	protected function _output_custom($output = null)
	{			    
	    Template::set($output);
	    	
	    Template::set_view('grocery/grocery_custom_view');
	    
	    Template::render();
	}
	
	public function callback_radio($value = 0,$name,$v1,$v2,$n1,$n2)
	{
		$input = "<div class='pretty-radio-buttons'>";
		if(empty($value) && $value == '0' ) $input .= '<label><input type="radio" value="'.$v1.'" name="'.$name.'" class="radio-uniform"> '.$n1.'</label>
									 <label><input type="radio" value="'.$v2.'" name="'.$name.'" class="radio-uniform"> '.$n2.'</label>';
	
		elseif ($value==$v1) $input .= '<label><input type="radio" checked="checked" value="'.$v1.'" name="'.$name.'" class="radio-uniform"> '.$n1.'</label>
									  <label><input type="radio" value="'.$v2.'" name="'.$name.'" class="radio-uniform"> '.$n2.'</label>';
	
		elseif($value==$v2) $input .= '<label> <input type="radio" value="'.$v1.'" name="'.$name.'" class="radio-uniform"> '.$n1.'</label>
									 <label> <input type="radio" checked="checked" value="'.$v2.'" name="'.$name.'" class="radio-uniform"> '.$n2.'</label>';
		$input .= "</div>";
		return $input;
	}
	
	public function valida_cnpj($str = '')
	{
	    $this->load->helper('funcoes');
		if (empty($str)) return TRUE; //não necessita estar preenchido
		$this->form_validation->set_message('valida_cnpj','O campo CPNJ deve conter um CNPJ válido.');
		if(valida_cnpj($str) == TRUE)
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	
	protected function common_crud_clean($crud)
	{
	    Template::set_theme('clean');
            
	    Assets::add_css(array(
            '../painel/plugins/bootstrap-4.2.1/css/bootstrap.min',
            '../painel/plugins/jquery-ui-1.12.1/jquery-ui.min',
            '../painel/plugins/font-awesome-4.7.0/css/font-awesome.min',
            /*'fonts/ionicons/ionicons.min'*/
        ));
        
        Assets::add_js(array(
            '../painel/plugins/jquery/jquery-3.3.1.min',
            '../painel/plugins/bootstrap-4.2.1/js/bootstrap.min',
            '../painel/plugins/jquery-ui-1.12.1/jquery-ui',
            '../painel/plugins/maskedinput/jquery.maskedinput'
        ),  'external', true);
        
	}
	
	public function valida_acoes($crud,$table = NULL) 
    {
        
        
        if (!in_array(1, $this->acoes)) 
        {
            $crud->unset_add();
        }
        if (!in_array(2, $this->acoes)) 
        {
            $crud->unset_edit();
        }
        if (!in_array(3, $this->acoes)) 
        {
            $crud->unset_delete();
        }
        if (!in_array(4, $this->acoes)) 
        {
            $crud->unset_export();
        }
        if (!in_array(5, $this->acoes)) 
        {
            $crud->unset_print();
        }
        if (!in_array(6, $this->acoes)) 
        {
            $crud->unset_read();
        }
        if (in_array(7, $this->acoes)) 
        {
            $crud->add_action('Usuario', '', '', 'fa-user', array(
                $this,
                'usuario'
            ));
        }
        
		$state = $crud->getState();
        if(in_array($state, ['add','edit']))
            $this->breadcrumb($state);
        
        
        if($table !== NULL && ($state == 'edit' || $state == 'delete' || $state == 'read'))
		{
		    $state_info = $crud->getStateInfo();
		    $primary_key = $state_info->primary_key;
		    $this->load->model('blog_model');
            $this->blog_model->ini_profile(TRUE);
		    $valid = $this->blog_model->check_user_property($primary_key,$table);
		    
		    if($valid === FALSE)
		    {
		        $instance = parent::get_instance();
        		$module = $instance->router->fetch_module();
        		$class = $instance->router->fetch_class();
        		$method = $instance->router->fetch_method();
		        redirect($module.'/'.$class.'/'.$method);
		    } 
		}
    }
}