<?php
require_once '../builder/modules/grocery/models/Grocery_crud_model.php';

class Custom_CRUD_Model extends grocery_CRUD_Model  {
	
	protected $table1 = null;
	protected $join_on_table = null;
	protected $join_on_id_rel = null;
	protected $join_on_id_rel_2 = null;
	protected $id_rel = null;
	protected $join = null;
	
	function set_join_on()
	{
		$tb1 = $this->table_name; $tb2 = $this->join_on_table; $id = $this->join_on_id_rel; $id_2 = $this->join_on_id_rel_2;
		$this->db->select("$tb2.*");
		$this->db->join($tb2, "$tb2.$id_2  = $tb1.$id");
		$this->join = true;
		 
	}
	
	function set_basic_join_on_table($table_name = null,$join_on_id_rel, $join_on_id_rel_2)
	{
		if( !($this->db->table_exists($table_name)) )
			return false;
	
		$this->join_on_table = $table_name;
		$this->join_on_id_rel = $join_on_id_rel;
		$this->join_on_id_rel_2 = $join_on_id_rel_2;
		$this->join = TRUE;
		 
		return true;
	}
	
	function get_edit_values_join($join_on_id_rel_value)
	{
		$this->db->where($this->join_on_id_rel_2,$join_on_id_rel_value);
		$result = $this->db->get($this->join_on_table)->row();
		return $result;
	}
	
	function get_field_types_basic_table()
	{
		$db_field_types = array();
		$show_columns = $this->db->query("SHOW COLUMNS FROM `{$this->table_name}`")->result();
		 
		if ($this->join_on_table != null)
		{
			$tb2 = $this->join_on_table;
			$show_columns_join = $this->db->query("SHOW COLUMNS FROM `$tb2`")->result();
			unset($show_columns_join[0]);
			foreach($show_columns_join as $join)
			{
				$show_columns[] = $join;
			}
		}
		 
		 
		foreach($show_columns as $db_field_type)
		{
			$type = explode("(",$db_field_type->Type);
			$db_type = $type[0];
	
			if(isset($type[1]))
			{
				if(substr($type[1],-1) == ')')
				{
					$length = substr($type[1],0,-1);
				}
				else
				{
					list($length) = explode(" ",$type[1]);
					$length = substr($length,0,-1);
				}
			}
			else
			{
				$length = '';
			}
			$db_field_types[$db_field_type->Field]['db_max_length'] = $length;
			$db_field_types[$db_field_type->Field]['db_type'] = $db_type;
			$db_field_types[$db_field_type->Field]['db_null'] = $db_field_type->Null == 'YES' ? true : false;
			$db_field_types[$db_field_type->Field]['db_extra'] = $db_field_type->Extra;
		}
		 
		$results = $this->db->field_data($this->table_name);
		 
		if ($this->join_on_table != null)
		{
			$tb2 = $this->join_on_table;
	
			$results_fj = $this->db->field_data($tb2);
			unset($results_fj[0]);
			foreach($results_fj as $join)
			{
				$results[] = $join;
			}
		}
		foreach($results as $num => $row)
		{
			$row = (array)$row;
			$results[$num] = (object)( array_merge($row, $db_field_types[$row['name']])  );
		}
		 
		return $results;
	}
	
	function db_update_join($post_array, $id_join_name, $id_join_value)
	{
		$this->db->where($this->join_on_id_rel_2,$id_join_value);
		return $this->db->update($this->join_on_table,$post_array);
	}
	
	function db_insert_join($post_array)
	{
		$columns = $this->db->query("SHOW COLUMNS FROM `{$this->join_on_table}`")->result();
		
		//dd($post_array);
		
		for($i=1;$i<count($columns);$i++)
		{
		    $key = $columns[$i]->Field;
		    
		    if(isset($post_array[$key]))
		    {
		        $post_array_join[$key] = $post_array[$key];
		        
		        if(!$this->field_exists($key,$this->table_name))
				    unset($post_array[$key]);
		    }
		}
		
        //dd($post_array,$post_array_join);
		
		$insert_join = $this->insert_join_on_table($post_array_join);
		
		
		if ($insert_join != FALSE)
		{
			$post_array[$this->join_on_id_rel] = $insert_join;
			return $this->db_insert($post_array);
		}
		else
		{
			return false;
		}
		 
	}
	
	function insert_join_on_table($dados)
	{
	    //dd( $this->join_on_table, $dados);
	    
		if($this->db->insert ( $this->join_on_table, $dados ))
		{
			
			return $this->db->insert_id();
		}
			
		else
			return FALSE;
	}
	
	function db_delete_join($primary_key_value)
	{
		$primary_key_field = $this->get_primary_key();
		$id_join_value = $this->get_id_join($primary_key_value,$primary_key_field);
		if ($this->delete_join($id_join_value))
		{
			return $this->db_delete($primary_key_value);
		}
		return false;
	}
	
	function delete_join($primary_key_value)
	{
		$primary_key_field = $this->join_on_id_rel_2;
	
		return $this->db->delete($this->join_on_table,array( $primary_key_field => $primary_key_value));
	
	}
	
	function get_id_join($id_value,$id_name)
	{
		$primary_key_field = $this->get_primary_key();
		$select = $this->join_on_id_rel;
		$this->db->select($select);
		$this->db->where($id_name,$id_value);
	
		$query = $this->db->get($this->table_name);
		if($query->num_rows() ==1 ) return $query->row()->$select;
		return NULL;
	}
	
}