<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Toolbar {

    private static $CI;
    protected static $area;
    protected static $dados;
    protected static $orders = array();
    protected static $notes = array(
        'num' => 0,
        'notes' => array()
    );
    
    protected static $msgc = array(
        'num' => 0,
        'notes' => array()
    );
    
    public function __construct() {
        self::$CI =& get_instance();
    }
    
    public static function set_area($name)
    {
        self::$area = $name;
    }
    
    public static function add($id, $title, $msg, $link = null, $date = null, $button = null)
    {
        if(self::$area === 'mensagem')
        {
            $i = sizeof(self::$notes['notes']);
        
            self::$notes['notes'][$i] = array(
                'id'      => $id,
                'title'   => $title,
                'msg'     => $msg,
                'link'    => is_null($link) ? base_url('anunciante/conta') : $link,
                'button'  => is_null($button) ? 'ir' : $button
            );
            
            self::$notes['num'] = ++$i;
        } 
        else if(self::$area === 'contato')
        {
            $i = sizeof(self::$msgc['notes']);
        
            self::$msgc['notes'][$i] = array(
                'id'      => $id,
                'name'    => $title,
                'msg'     => $msg,
                'data'    => $date,
                'link'    => is_null($link) ? base_url('anunciante/conta/inbox') : $link,
            );
            
            self::$msgc['num'] = $i+1;
        }
    }
    
    public static function has_message()
    {
        if(self::$notes['num'] > 0)
        {
            return true;
        }
        
        return false;
    }
    
    public static function search($param ,$value)
    {
        $found = false;
        
        foreach(self::$notes['notes'] as $msg)
        {
            $search = array_search($value, $msg);
            
            if($search === $param)
            {
                $found = true;
            }
        }
        
        return $found;
    }
    
    public static function get_empty()
    {
        return self::$dados;
    }
    
    public static function get($id)
    {
        foreach(self::$notes['notes'] as $msg)
        {
            if($msg['id'] === $id)
            {
                return $msg;
            }
        }
        return null;
    }
    
    public static function contato()
    {
        return self::$msgc;
    }
    
    public static function notificacoes()
    {
        return self::$notes;
    }
    
}