//Mostrar modal de logout
$("body").on('click', '.btn-logout', function(e)
{
    $('.modal-logout').modal('show');
});

//Mostrar modal de limpar cache
$("body").on('click', '.clear-data-61', function(e)
{   
    cacheModalDefault();
    $('.modal-clear-cache').modal('show');
});

//Mostrar modal de limpar sessao
$("body").on('click', '.clear-data-62', function(e)
{
    sessionModalDefault();
    $('.modal-clear-session').modal('show');
});

//Ajax para limpar o cache
$("body").on('click', '#confirm-cache', function(e)
{
    $.ajax({
        url: base_url + 'sistema/clear/cache',
        type: "POST",
    }).done(function(resposta) { //Requisição feita com sucesso
            $('.modal-header').removeClass('bg-danger').addClass('bg-success')
            $('#cache-modal-cancel').removeClass('btn-default').addClass('btn-success')
            document.getElementById("cache-modal-title").innerHTML = "Concluído";
            document.getElementById("cache-modal-message").innerHTML = "O cache foi limpo com sucesso!";
            $('#confirm-cache').hide();
            document.getElementById("cache-modal-cancel").innerHTML = "Ok";
       }).fail(function(jqXHR, textStatus ) {
              document.getElementById("ses-modal-message").innerHTML = "Oops! Não pudemos concluir esta ação. Por favor, tente novamente!";
              $('#confirm-session').hide();
              document.getElementById("cache-modal-cancel").innerHTML = "Ok";
          });
});

//Ajax para limpar a sessao
$("body").on('click', '#confirm-session', function(e)
{
    $.ajax({
        url: base_url + 'sistema/clear/session',
        type: "POST",
    }).done(function(resposta) {
            document.getElementById("ses-modal-title").innerHTML = "Até Logo...";
            document.getElementById("ses-modal-message").innerHTML = "Sessão encerrada com sucesso! Até mais... ;)";
            $('#confirm-session').hide();
            document.getElementById("ses-modal-cancel").innerHTML = "Ok";
            window.location.href = '/auth/logout';
       }).fail(function(jqXHR, textStatus ) {
              document.getElementById("ses-modal-message").innerHTML = "Oops! Não pudemos concluir esta ação. Por favor, tente novamente!";
              $('#confirm-session').hide();
              document.getElementById("ses-modal-cancel").innerHTML = "Ok";
          });
});

//Retorna ao Default o modal de Clear Cache
function cacheModalDefault() {
    $('.modal-header').addClass('bg-danger').removeClass('bg-success')
    $('#cache-modal-cancel').addClass('btn-default').removeClass('btn-success')
    document.getElementById("cache-modal-title").innerHTML = "Confirmação";
    document.getElementById("cache-modal-message").innerHTML = "Você realmente quer limpar os dados temporários de navegação?";
    $('#confirm-cache').show();
    document.getElementById("cache-modal-cancel").innerHTML = "Cancelar";
}

//Retorna ao Default o modal de Clear Session
function sessionModalDefault() {
    document.getElementById("cache-modal-title").innerHTML = "Confirmação";
    document.getElementById("cache-modal-message").innerHTML = "Você realmente quer limpar esta sessão? Isto irá te deslogar.";
    $('#confirm-cache').show();
    document.getElementById("ses-modal-cancel").innerHTML = "Cancelar";
}

function showModal(title, content, type, buttonLabel = null, buttonClass = null)
{
    var obj = $('#modal');
    var buttons;
    
    if(type == 'danger')
    {
        obj.find('.modal-header').addClass('bg-red');
        obj.find('#continuar').addClass('bg-red');
    } 
    else if(type == 'success') {
        obj.find('.modal-header').addClass('bg-green');
        obj.find('#continuar').addClass('bg-green');
    } 
    else if(type == 'info') {
        obj.find('.modal-header').addClass('bg-aqua');
        obj.find('#continuar').addClass('bg-aqua');
    } 
    else if(type == 'warning') {
        obj.find('.modal-header').addClass('bg-yellow');
        obj.find('#continuar').addClass('bg-yellow');
    }

    if(title.length > 1)
    {
        obj.find('.modal-title').html(title);
    }
    
    if(content.length > 1)
    {
        obj.find('.modal-body').html(content);
    }

    if(buttonClass !== null && buttonLabel !== null)
    {
        buttons = '<button type="button" class="btn btn-flat btn-default pull-left" data-dismiss="modal">Fechar</button>'+
                  '<button type="button" id="btn_confirmar" class="btn btn-flat btn-'+buttonClass+'">'+buttonLabel+'</button>';
    }
    else 
    {
        buttons = '<button type="button" class="btn btn-default btn-flat" data-dismiss="modal">Fechar</button>';
    }

    obj.find('.modal-footer').html(buttons);
    
    obj.modal('show');
}

$('#modal').on('hidden.bs.modal', function (e) {
    
    var obj = $('#modal');
    
    if (obj.find('.modal-header').hasClass('bg-red')) 
    {
        obj.find('.modal-header').removeClass('bg-red');
    }  
    else if(obj.find('.modal-header').hasClass('bg-green')) 
    {
        obj.find('.modal-header').removeClass('bg-green');
    }

    else if(obj.find('.modal-header').hasClass('bg-aqua')) 
    {
        obj.find('.modal-header').removeClass('bg-aqua');
    }  
    else if(obj.find('.modal-header').hasClass('bg-yellow')) 
    {
        obj.find('.modal-header').removeClass('bg-yellow');
    }
});