$(document).ready(function(){

	var edit = false // variavel de controle que carrega as opções marcadas no banco
	
	$('.flexigrid').css('overflow','visible')
	
	$(".chosen-multiple-select").chosen({		
		allow_single_deselect:true	
	})
	
	// CRIA FUNÇÕES GENÉRICAS	
		
	$.fn.hideLoading = function()
	{
		$( "#loading" ).hide();
		$( "#perfil" ).show();
	}
	
	$.fn.exists = function() { // valida se um determinado elemento existe
      return $(this).length > 0;
	}
	
	$.fn.atualziaAltura = function() // altura da div perfil é alterada para melhor visualização das opções chosen
	{
		if($(".chzn-drop").exists())
		{
			$('#perfil').css("min-height", "")
			var hChosen = parseInt($(".chzn-drop").last().height())	
			var hPerfil = parseInt($('#perfil').height())
			var height  = hPerfil + hChosen - 40
			$('#perfil').css('min-height',height)	
		}
	}

	// CRIA FUNÇÕES DE SEÇÕES
	
	$.fn.arrayTotalSecoes = function() // cria um array com todas as secoes disponíveis
	{
		var secoes = new Array()
		$('select#field-secoes option').each(function(i){
			secoes[i] = $(this).val()
		})		
		return secoes
	}
	
	$.fn.removeSecoes = function(secoesAtivas) // remove as secoes não utilizadas ou não chamadas
	{			
		var numSecoesAtivas = secoesAtivas.length
		
		if(numSecoesAtivas > 0 && secoesAtivas[0] != 'null' )
		{		
			var arrayTodasSecoes = $(this).arrayTotalSecoes()
			
			for(i=0;i<arrayTodasSecoes.length;i++)
			{
				var controle = false
				for(j=0;j<secoesAtivas.length;j++)
				{
					if(parseInt(arrayTodasSecoes[i]) == parseInt(secoesAtivas[j]))
					{
						controle = true
					}
				}
				if(controle == false)
				{
					$('#box_secao_'+arrayTodasSecoes[i]).remove()
					$('#box_secao_pai_'+arrayTodasSecoes[i]).remove()
				}
			}
		}
		else
		{
			$('#secoes_content').html('')
			$('#sub_content').html('')
			$('#campos_content').html('')
			$('#sub-secoes').find('.tit-filtros').hide()	
			$('#acoes-campos').find('.tit-filtros').hide()
		}
	}
	
	$.fn.secaoAjax = function(secao) // gera um chosen com as determinadas sub-seções
	{
		var target = base_url + 'painel/perfil/subSecao_ajax'
		var data = {
			 secao: secao
		}	
		
		// consulta as sub-secoes e cria a opção de seleção		
		request = $.ajax({
			url: target,
			dataType: 'json',
			type: 'POST',
			data: data,
			success: function(result)
			{
				$.each(result.secao, function(key, value) {
					if(!$('#box_secao_'+key).exists())
					{
						$('#secoes_content').append(value)	
					}
				})
			}				
		})
		
		request.done(function() {
			$('.form-input-box').fadeIn()
			$(".chosen-multiple-select").chosen()
			if(edit == true)
			{
				$(this).carrega_sub_secoes_edit()
			}			
			$(this).atualziaAltura()
		})
	}
	
	$.fn.addTodos = function()
	{
		this.each(function(){
			$(this).find('option').attr('selected', 'selected');
		})
		this.trigger("liszt:updated");
	}
	
	$.fn.delTodos = function()
	{
		this.each(function(){
			$(this).find('option').removeAttr("selected");
		})
		this.trigger("liszt:updated");
	}
	
	// FIM DAS FUNÇÕES DE SEÇÕES	
	
	// CRIA FUNÇÕES DE SUB-SEÇÕES
	
	
	$.fn.arrayTotalSubSecoes = function() // cria um array com todas as secoes disponíveis
	{
		var subSecoes = new Array()
		$(this).find('option').each(function(i){
			subSecoes[i] = $(this).val()
		})		
		return subSecoes
	}
	
	$.fn.removeSubSecoes = function(secao,subSecoesAtivas) // remove as secoes não utilizadas ou não chamadas
	{		
		var numSubAtivas = subSecoesAtivas.length
		
		if(numSubAtivas > 0 && subSecoesAtivas[0] != 'null' )
		{
			var arrayTodasSubSecoes = $(this).arrayTotalSubSecoes()			

			for(i=0;i<arrayTodasSubSecoes.length;i++)
			{
				var controle = false
				for(j=0;j<subSecoesAtivas.length;j++)
				{
					if(parseInt(arrayTodasSubSecoes[i]) == parseInt(subSecoesAtivas[j]))
					{
						controle = true
					}
				}
				if(controle == false)
				{
					$('#box_acoes_'+arrayTodasSubSecoes[i]).remove()					
					if(arrayTodasSubSecoes[i] == 2)
					{
						$('#box_campos_pai').remove()
						$('#acoes-campos').find('.tit-filtros').hide()
					}
				}
			}
		}
		else
		{
			$('#box_secao_pai_'+secao).remove()
			if(secao == 1)
			{
				$('#box_campos_pai').remove()
				$('#acoes-campos').find('.tit-filtros').hide()
			}
		}	
	}
	
	$.fn.removeTitSubSecao = function() // remove as secoes não utilizadas ou não chamadas
	{		
		var subSecoesAtivas = new Array()
		var controle = false
		
		$(".chosen-sub-change").each(function(count){
			subSecoesAtivas[count] = new String($(this).val())
		})	
		
		for(i=0;i<subSecoesAtivas.length;i++)
		{
			var arraySecoes = subSecoesAtivas[i].split(',')
			for(j=0;j<arraySecoes.length;j++)
			{
				if(arraySecoes[j] != 'null' )
				{
					controle = true
				}
			}
		}
		
		if(controle != true)
		{
			$('#sub-secoes .tit-filtros').hide() // nao tendo seção ativa esconde o tit-filtros
		}	
	}
	
	$.fn.subSecaoAjax = function(secao,subSecao) // gera um chosen com as determinadas sub-seções
	{
		var target = base_url + 'painel/perfil/acoes_ajax'
		var data = {
			secao: secao,
			subsecao: subSecao			 
		}		
		// consulta as sub-secoes e cria a opção de seleção
		request = $.ajax({
			url: target,
			dataType: 'json',
			type: 'POST',
			data: data,
			success: function(result)
			{
				$.each(result.subSecao.content, function(key, value) {
					if(!$('#box_acoes_'+key).exists())
					{
						$('#box_secao_pai_'+secao).find('.tit_subsecao').html('Seção: '+result.subSecao.title[key])
						$('#box_secao_pai_'+secao).append(value)
					}
				})			
			}
		})
		
		request.done(function() {
			$('.form-input-box').fadeIn()			
			$(".chosen-multiple-select").chosen()		
			$(this).atualziaAltura()
		})		
	}
	
	$.fn.criaDivSecaoPai = function(secao) // gera um chosen com as determinadas sub-seções
	{
		if(!$('#box_secao_pai_'+secao).exists())
		{
			$('#sub_content').append('<div id="box_secao_pai_'+secao+'" class="secao_pai"><div class="tit_subsecao"></div></div>')
		}
	}
	
	//########################## FIM FUNÇÕES DE SUB-SEÇÕES ##########################//
	
	// Funcoes das Acoes dos Campos dos Eventos
	
	$.fn.removeTitAcoesCampos = function() // remove as secoes não utilizadas ou não chamadas
	{		
		var acoesAtivas = new Array()
		var controle = false
		
		$(".chosen-campos-change").each(function(count){
			acoesAtivas[count] = new String($(this).val())
		})	
		
		for(i=0;i<acoesAtivas.length;i++)
		{
			var arraySecoes = acoesAtivas[i].split(',')
			for(j=0;j<arraySecoes.length;j++)
			{
				if(arraySecoes[j] != 'null' )
				{
					controle = true
				}
			}
		}
		
		if(controle != true)
		{
			$('#acoes-campos .tit-filtros').hide() // nao tendo seção ativa esconde o tit-filtros
		}	
	}
	
	$.fn.trataArrayAcoes = function(arrayAcoes) // remove as acoes diferente de 1,2,6
	{	
		if(arrayAcoes == null) return null
		
		var acoesPermitidas = new Array("1","2","6")
		var arrayResult		= new Array()
		var j = 0
		
		for(i=0;i<arrayAcoes.length;i++)
		{
			if(arrayAcoes[i] == 1 || arrayAcoes[i] == 2 || arrayAcoes[i] == 6)
			{
				arrayResult[j] = arrayAcoes[i]
				j++
			}
		}
		
		if(arrayResult.length > 0) return arrayResult
		
		return null
		
	}
	
	$.fn.removeAcoesCampos = function(acoesAtivas) // remove as acoes não utilizadas ou não chamadas
	{
		var numSecoesAtivas = 0
		if(acoesAtivas != null)
		{
			for(i=0;i<acoesAtivas.length;i++)
			{
				if(acoesAtivas[i] == 1 || acoesAtivas[i] == 2 || acoesAtivas[i] == 6)
				{
					numSecoesAtivas++
				}
				else
				{
					acoesAtivas.splice(acoesAtivas[i], 1);
				}
			}
		}		
		
		if(numSecoesAtivas > 0 && acoesAtivas[0] != 'null' )
		{		
			
			var arrayTodasAcoes = new Array("1","2","6")
			
			for(i=0;i<arrayTodasAcoes.length;i++)
			{
				var controle = false
				for(j=0;j<acoesAtivas.length;j++)
				{
					if(parseInt(arrayTodasAcoes[i]) == parseInt(acoesAtivas[j]))
					{
						controle = true
					}
				}
				if(controle == false)
				{
					$('#box_campos_acao_'+arrayTodasAcoes[i]).remove()
				}
			}
		}
		else
		{
			$('#box_campos_pai').remove()
		}
	}
	
	$.fn.criaDivCamposPai = function() // gera um chosen com as ações do gerenciador
	{
		if(!$('#box_campos_pai').exists())
		{
			$('#campos_content').append('<div id="box_campos_pai" class="campos_pai"><div class="tit_campos_evento">Subseção: Gerenciador</div></div>')
		}
	}
	
	
	$.fn.carregaCamposEventoAjax = function(arrayAcoes){
		
		var target = base_url + 'painel/perfil/acoesCamposEvento_ajax'
		var data = {
				arrayAcoes: arrayAcoes
		}	
		
		// consulta os campos do evento e cria a opção de seleção		
		request = $.ajax({
			url: target,
			dataType: 'json',
			type: 'POST',
			data: data,
			success: function(result)
			{
				$.each(result.camposEvento.content, function(key, value) {
					
					if(!$('#box_campos_acao_'+key).exists())
					{
						$('#box_campos_pai').append(value)
					}
				})
			}				
		})
		
		request.done(function() {
			$('.form-input-box').fadeIn()
			$(".chosen-multiple-select").chosen()		
			$(this).atualziaAltura()
		})
	}
	
	// FIM DAS FUNÇÕES DE AÇÕES DE CAMPOS DE EVENTO
	
	$('form[name=form-perfil]').submit(function(){
		if($('input[name=perfil]').val() == '')
		{
			alert('Nome do perfil em branco, favor preencher perfil')
			return false
		}
	})
	
	$("#field-secoes.chosen-multiple-select").change(function(){ // chamada das sub-seções
		
		valuesSecoes = new String($(this).val())
		var arraySecoes = valuesSecoes.split(',') // cria array de secoes	
		var numSecoes = arraySecoes.length	
		
		$(this).removeSecoes(arraySecoes) // chamada da função que remove as secoes não chamadas			
			
		if(arraySecoes.length > 0 && arraySecoes[0] != 'null'){			
			$('#secoes').find('.tit-filtros').fadeIn()					
			$(this).secaoAjax(arraySecoes)				
		}else{
			$('#secoes').find('.tit-filtros').hide() // nao tendo seção ativa esconde o tit-filtros
		}
		
	})	
	
	$( document ).on( "change", ".chosen-sub-change",function(event){ // chamada das acoes das sub-seções
		if(event.target == this){
			var valuesSubSecoes =   new String($(this).val())
			var secaoPai = $(this).attr('rel')
			var arraySubSecoes = valuesSubSecoes.split(',') // cria array de secoes		
			var numSubSecoes = arraySubSecoes.length
			
			$(this).removeSubSecoes(secaoPai,arraySubSecoes) // chamada da função que remove as secoes não chamadas				
			
			$(this).removeTitSubSecao()
			
			$(this).criaDivSecaoPai(secaoPai)
			
			if(numSubSecoes > 0 && arraySubSecoes[0] != 'null'){			
				$('#sub-secoes .tit-filtros').fadeIn()	
				$('#box_secao_pai_'+secaoPai+' .tit_subsecao').fadeIn()

				$(this).subSecaoAjax(secaoPai,arraySubSecoes) // cria um chosen com as opções vindo do banco
			}else{
				$('#box_secao_pai_'+secaoPai+' .tit_subsecao').hide()
			}			
		}		
	})
	
	$( document ).on( "change", "#box_acoes_2 select",function(event){ // chamada das acoes das sub-seções
		if(event.target == this){
			var arrayAcoes = $(this).val()
			arrayAcoes = $(this).trataArrayAcoes(arrayAcoes)

			$(this).removeAcoesCampos(arrayAcoes) // chamada da função que remove as secoes não chamadas				
			
			$(this).removeTitAcoesCampos()
			
			$(this).criaDivCamposPai() // Gerenciador
			
			if(arrayAcoes != null){
				$('#acoes-campos .tit-filtros').show()	
				$('.campos_pai .tit_campos_evento').fadeIn()
				
				$(this).carregaCamposEventoAjax(arrayAcoes) // cria um chosen com as opções vindo do banco
			}
			else
			{
				$('.campos_pai .tit_campos_evento').hide()
			}
		}
	})
	
	$( document ).on( "click", ".addSecao",function(){		
		var secao = $(this).parents('.form-input-box').find('.chosen-multiple-select')
		secao.addTodos()
		secao.trigger('change')
		return false
	})
	
	$( document ).on( "click", ".delSecao",function(){
		var secao = $(this).parents('.form-input-box').find('.chosen-multiple-select')
		secao.delTodos()
		secao.trigger('change')
		return false
	})	
	
	$(window).load(function(){
		$(this).atualziaAltura()
	})

});