<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Conta extends Admin_Controller
{
    function __construct() 
    {
        parent::__construct();
        $this->load->model('conta_model');
        $this->load->helper('url');
        $this->load->helper('form');
        $this->load->library("security");
        
        Assets::add_module_css('sistema', array(
            'painel'
        ));
        
        Assets::add_module_js('sistema', array('modal','contato'));         
    }
    
    /* ----------------------------- Métodos do cadstro de msg ----------------------------- */
    
    public function inbox()
    {
        //$this->ini_method();
         
        $data = $this->get_dados(array('contato', 'novos_qtd'));
        
        foreach($data['inbox'] as $msg) 
        {
            $msg->nome = ucwords($msg->nome);
            $msg->mensagem = substr($msg->mensagem, 0, 40).'...';
            $msg->data = calcula_qtd_dias_entre_datas($msg->data, date('Y-m-d H:i:s')).' dias atrás';
        }
        
        $data['class_inbox'] = 'active';
        $data['class_trash'] = '';
        $data['back_button'] = base_url('sistema/conta/lixo');
        
        Template::load_view('contato_partes/general', array('inbox' => $data['inbox']), '', '', $data['box_piece']);
        Template::set($data);
        Template::set_view('contato_view');
        Template::render();
    }
  
    public function lixo()
    {
        //$this->ini_method();
                 
        $data = $this->get_dados(array('excluidas', 'novos_qtd'));
        
        foreach($data['trashed'] as $msg)
        {
            $msg->nome = ucwords($msg->nome);
            //$msg->assunto = ucfirst(strtolower($msg->assunto));
            $msg->mensagem = substr($msg->mensagem, 0, 40).'...';
            $msg->data = calcula_qtd_dias_entre_datas($msg->data, date('Y-m-d H:i:s')).' dias atrás';
        }
        
        $data['class_inbox'] = '';
        $data['class_trash'] = 'active';
        $data['back_button'] = base_url('sistema/conta/lixo');
        
        Template::load_view('modal/modal_confirmacao', '', '', '', $data['modal'][]);
        
        Template::load_view('contato_partes/general', array('trashed' => $data['trashed']), '', '', $data['box_piece']);
        Template::set($data);
        Template::set_view('contato_view');
        Template::render();
    }
    
    public function mensagem()
    {
        //$this->ini_method('inbox');
                
        $msgID = $this->uri->segment(4);
        $data = $this->get_dados(array('mensagem' => $msgID, 'novos_qtd'));
        $data['mensagem']->nome = ucwords($data['mensagem']->nome);
        $data['mensagem']->assunto = ucfirst(strtolower($data['mensagem']->assunto));
        $data['mensagem']->data = converte_datahora($data['mensagem']->data, 1);
        
        if($data['mensagem']->status === '1')
        {
            $this->load->model('conta_model');
            $this->conta_model->update_read($msgID);
        }
        
        if($data['mensagem']->trashed === '1')
        {
            $data['class_inbox'] = '';
            $data['class_trash'] = 'active';
            $data['back_button'] = base_url('sistema/conta/lixo');
        } 
        else if($data['mensagem']->trashed === '0')
        {
            $data['class_inbox'] = 'active';
            $data['class_trash'] = '';
            $data['back_button'] = base_url('sistema/conta/inbox');
        }
        
        $view_data = array (
            'msg' => $data['mensagem'],
            'back_button' => $data['back_button']
        );
        
        Template::load_view('contato_partes/single', $view_data, '', '', $data['box_piece']);
        Template::set($data);
        Template::set_view('contato_view');
        Template::render();
    }
    
    private function get_dados($tipo = array())
    {        
        $this->load->model('conta_model');
        $data = array();
        
        if(in_array('novos_contatos', $tipo) || in_array('novos_qtd', $tipo))
        {
            $dbResult = $this->conta_model->get_novos_contatos();
            
            if(in_array('novos_contatos', $tipo)){
                $data['novos_contatos'] = $dbResult['result'];
            }
            
            if(in_array('novos_qtd', $tipo)){
                $data['novos_qtd'] = $dbResult['total'];
            }
        }
        
        
        if(in_array('contato', $tipo) || in_array('inbox_qtd', $tipo))
        {
            $dbResult = $this->conta_model->get_contatos();
            
            if(in_array('contato', $tipo)){
                $data['inbox'] = $dbResult['result'];
            }
            
            if(in_array('inbox_qtd', $tipo)){
                $data['inbox_qtd'] = $dbResult['total'];
            }
        }
        
        if(in_array('excluidas', $tipo))
        {
            $data['trashed'] = $this->conta_model->get_msgs_excluidas();
        }
        
        if(array_key_exists('mensagem', $tipo))
        {
            $msgID = $tipo['mensagem'];
            $data['mensagem'] = $this->conta_model->get_mensagem($msgID);
        }
        
        return $data;
    }
    
    public function get_message()
    {
        //$this->ini_method('inbox');
        
        $inbox = $this->conta_model->get_contatos();
        $view = '';       

        foreach($inbox['result'] as $msg){
            $msg->nome = ucwords($msg->nome);
            //$msg->assunto = ucfirst(strtolower($msg->assunto));
            $msg->mensagem = substr($msg->mensagem, 0, 20).'...';
            $msg->data = calcula_qtd_dias_entre_datas($msg->data, date('Y-m-d H:i:s')).' dias atrás';
            $assunto = (strlen($msg->assunto) > 0) ? $msg->assunto.'  &#149;  ': '';
            $class = ($msg->status === '1') ? 'class="text-strong"' : '';
            $view .= '<tr '.$class.'>
                <td>
                    <div class="icheckbox_flat-blue" aria-checked="false" aria-disabled="false" custom="position: relative;">
                        <input type="checkbox" class="checkbox" value="'.$msg->id.'" data-action="excluir"/>
                    </div>
                </td>
                <td class="mailbox-name"><a href="'.base_url('sistema/conta/mensagem').'/'.$msg->id.'">'.$msg->nome.'</a></td>
                <td class="mailbox-subject">'.$assunto.'<span class="text-muted">'.$msg->mensagem.'</span></td>
                <td class="mailbox-date">'.$msg->data.'</td>
            </tr>';
        }
        echo json_encode($view);
    }

    public function trash_message()
    {
        //$this->ini_method('lixo');
        
        $post = $this->security->xss_clean($this->input->post('mensagens'));
        $valid = array();
        if(sizeof($post) === 0)
        {
            echo json_encode(array(
                'valid' => false,
                'retorno' => 'A ação não pode ser concluída'
            ));
            die();
        }
        foreach($post as $id)
        {
            array_push($valid, $this->conta_model->trash_message($id));
        }

        if (in_array(null, $valid)) {
            echo json_encode(array(
                'valid' => false,
                'retorno' => 'A ação não pode ser concluída'
            ));
        }
        else 
        {
            echo json_encode(array(
                'valid' => true
            ));
        }
    }

    public function restaurar_mensagem()
    {
        //$this->ini_method('lixo');
        
        $post = $this->security->xss_clean($this->input->post('mensagens'));
        $valid = array();        

        if(sizeof($post) === 0)
        {
            echo json_encode(array(
                'valid' => false,
                'retorno' => 'A ação não pode ser concluída'
            ));
            die();
        }
    
        foreach($post as $id)
        {
            array_push($valid, $this->conta_model->restore_message($id));
        }
        
        if (in_array(null, $valid)) {
            echo json_encode(array(
                'valid' => false,
                'retorno' => 'A ação não pode ser concluída'
            ));
        }
        else 
        {
            echo json_encode(array(
                'valid' => true
            ));
        }
    }
    
    public function remove_message()
    {
        //$this->ini_method('inbox');
        
        $post = $this->security->xss_clean($this->input->post('mensagens'));
        $valid = array();
        
        if(sizeof($post) === 0)
        {
            echo json_encode(array(
                'valid' => false,
                'retorno' => 'A ação não pode ser concluída'
            ));
            die();
        }
        
        foreach($post as $id)
        {
            array_push($valid, $this->conta_model->remove_message($id));
        }
        
        if (in_array(false, $valid)) {
            echo json_encode(array(
                'valid' => false,
                'retorno' => 'A ação não pode ser concluída'
            ));
        }
        else 
        {
            echo json_encode(array(
                'valid' => true
            ));
        }
    }
    
}