<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

include_once GROCERY_CRUD;

class Perfil extends Grocery{
		
	function __construct()
	{
		parent::__construct();
	}
	
	function index()
	{
		try{
			$this->ini_method();
		
			$crud = new grocery_CRUD();
			
			$this->valida_acoes($crud);
			
			$state = $crud->getState();
			$state_info = $crud->getStateInfo();
			
			$crud->callback_column('tipo_menu',array($this,'_callback_column_tipo_menu'));
		
			if ($state == 'add')
			{
				$this->add();
			}
			elseif ($state == 'edit')
			{
				$pk = $state_info->primary_key;
				$this->edit($pk);
			}
			else
			{
				$this->list_perfil($crud);
			}
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	public function _callback_column_tipo_menu($value, $row)
	{
		if($value == 1) return 'Módulo';
		return 'Seção';
	}
	
	public function list_perfil($crud) 
    {
        $crud->set_theme('bootstrap');
        $crud->set_table('sys_perfil');
        $crud->set_subject('Perfil');
        $state = $crud->getState();
        $state_info = $crud->getStateInfo();
        
        $perfil = $this->session->userdata('perfil');
        
        if ($perfil != 1) 
        {
            $crud->where('id_perfil != ', '1');
            $crud->where('id_perfil != ', '2');
        }
        $crud->callback_before_delete(array($this,'before_delete'));
        
        Assets::add_module_js('sistema',array(
				'perfil_list.js'
		));
        
        $output = $crud->render();
        
        $this->_example_output($output);
    }
	
	public function before_delete($primary_key)
    {
        $perfil = $this->session->userdata('perfil');
        if($primary_key == 1 || $primary_key == 2 || $primary_key == $perfil)
        {
            return false;
        }
        $this->load->model('sistema/perfil_model');
		$this->perfil_model->delete_perfil_rel_perfil($primary_key);
        return true;
    }
  
	private function add()
	{
	    $this->router->method = 'add';
		if($this->input->post() == TRUE)
		{				
			$this->inserir_perfil($this->input->post());
			die();
		}
	
		Assets::add_module_css('sistema',array(
				'checkbox-x.min.css',
				'theme-krajee-flatblue.min.css',
				'custom.css',
				'add_perfil.css'
		));
	
		Assets::add_css('plugins/chosen-1.6.2/chosen.min.css');
		
		Assets::add_js(array(
				'plugins/jquery/jquery-migrate-1.2.1.min.js',
				'plugins/chosen-1.6.2/chosen.jquery.min.js',
				'plugins/chosen-1.6.2/config.js'
		));
	
		Assets::add_module_js('sistema',array(
				'perfil.js'
		));
		
	    $result = $this->list_modules();
	
		$data = array('result'=>$result);
	
		Template::set($data);
	
		Template::set_view('add_perfil_view');
	
		Template::render();
	}
	
	private function edit($id_perfil)
	{
	    $this->router->method = 'edit';
	    $user_perfil = $this->session->userdata('perfil');
	    
	    if($this->session->userdata('perfil') != 1 && ($id_perfil == 1 || $id_perfil == 2))
		{
			header("Location: javascript:history.back(1)");
		}
		
		if($this->input->post() == TRUE)
		{
			$this->editar_perfil($this->input->post());
			die();
		}
		
		Assets::add_module_css('sistema',array(
			'checkbox-x.min',
			'theme-krajee-flatblue.min',
			'custom',
			'perfil',
			'edit_perfil'
		));
		
		Assets::add_css('plugins/chosen-1.6.2/chosen.min.css');
		
		Assets::add_js(array(
				'plugins/jquery/jquery-migrate-1.2.1.min.js',
				'plugins/chosen-1.6.2/chosen.jquery.min.js',
				'plugins/chosen-1.6.2/config.js',
				'perfil'
		));
		
		Assets::add_module_js('sistema',array(
				'perfil.js',
				'perfil-edit.js'
		));
		
		$result = $this->list_modules();
		
		$this->load->model('perfil_model');
			
		$perfil = $this->perfil_model->consultar_perfil($id_perfil);
		
		$data = array(
				'result'=>$result,
				'id_perfil'=>$id_perfil,
				'perfil'=>$perfil
		);
		
		Template::set($data);
		
		Template::set_view('edit_perfil_view');
		
		Template::render();
	}
	
	private function list_modules()
	{
		$this->load->model('sistema/modulos_model');
		$perfil = $this->session->userdata('perfil');
		//$modulos_ativos = $this->modulos_model->list_active_modules();
		
	    if($perfil != 1){
		    $modulos_ativos = $this->modulos_model->list_active_modules_by_perfil($perfil);
		}else{
		    $modulos_ativos = $this->modulos_model->list_active_modules();
		}
		$result = array();
		if($modulos_ativos !== NULL)
		{
			foreach ($modulos_ativos as $keym => $modulo) {
				$result[$keym] = $modulo;
				if($perfil != 1){
				    $secoes_ativas = $this->modulos_model->list_sections_by_module_and_perfil($modulo->id_module,'',1,$perfil);
		        }else{
        		    $secoes_ativas = $this->modulos_model->list_sections_by_module($modulo->id_module,'',1);
        		}
				
				if($secoes_ativas !== NULL)
				{
					$result[$keym]->secoes = array();
					foreach ($secoes_ativas as $keys => $secao) {
		
						$result[$keym]->secoes[$keys] = $secao;
						if($secao->type == 1)
						{
							$acoes = $this->modulos_model->list_actions_by_section($secao->id_section,$perfil,$modulo->id_module);
							
							if($acoes != NULL)
							{
								$result[$keym]->secoes[$keys]->acoes = array();
								foreach ($acoes as $acao)
								{
									$result[$keym]->secoes[$keys]->acoes[] = $acao;
								}
							}
						}
						else
						{
						    
						    if($perfil != 1){
            				    $subsecoes_ativas = $this->modulos_model->list_subsections_by_section_and_perfil($secao->id_section,'',1,$perfil,$modulo->id_module);
            		        }else{
                    		    $subsecoes_ativas = $this->modulos_model->list_subsections_by_section($secao->id_section,'',1);
                    		}
							if($subsecoes_ativas !== NULL)
							{
								$result[$keym]->secoes[$keys]->subsecoes = array();
								foreach ($subsecoes_ativas as $keyb => $subsecao) {
									$result[$keym]->secoes[$keys]->subsecoes[$keyb] = $subsecao;
									$acoes = $this->modulos_model->list_actions_by_subsection($subsecao->id_subsection,$perfil,$modulo->id_module,$secao->id_section);
									if($acoes != NULL)
									{
										$result[$keym]->secoes[$keys]->subsecoes[$keyb]->acoes = array();
										foreach ($acoes as $keya => $acao)
										{
											$result[$keym]->secoes[$keys]->subsecoes[$keyb]->acoes[] = $acao;
										}
									}
								}
							}
						}
					}
				}
			}
		}		
		return $result;
	}
	
	private function inserir_perfil($post)
	{
		if(!empty($post['perfil']))
		{
			$this->load->model('sistema/perfil_model');
			$id_perfil = $this->perfil_model->inserir_perfil($post['perfil'],$post['tipo_menu']);
	
			if(!empty($id_perfil))
			{
				$this->insert_db($post['modulo'],$id_perfil);
			}
			redirect('/sistema/perfil/index/success/'.$id_perfil);
		}
	}
	
	private function editar_perfil($post)
	{
		if(!empty($post['perfil']))
		{
			$this->load->model('sistema/perfil_model');
			
			$update_perfil = array('perfil'=>$post['perfil'], 'tipo_menu'=>$post['tipo_menu']);
				
			$this->perfil_model->update_perfil($post['id_perfil'],$update_perfil);
				
			$delete = $this->perfil_model->excluir_prefil_rel($post['id_perfil']);
				
			if($delete)
			{
				$id_perfil = $post['id_perfil'];
				$this->insert_db($post['modulo'],$id_perfil);
			}
			redirect('/sistema/perfil/index/success/'.$id_perfil);
		}
	}
	
	private function insert_db($modulos,$id_perfil)
	{		
		if(!empty($modulos))
		{
			foreach ($modulos as $id_module=>$modulo)
			{
				foreach ($modulo as $id_section=>$secao)
				{
					foreach ($secao as $key=>$value)
					{
						if (is_array($value))
						{
							foreach ($value as $acao)
							{
								if($acao != 0)
								{
									$insert = array(
											'id_perfil'=> $id_perfil,
											'id_module'=> $id_module,
											'id_section'=> $id_section,
											'id_subsection'=> $key,
											'id_action'=> (int)$acao
									);
									$this->perfil_model->inserir_perfil_rel($insert);
								}
							}
						}
						else
						{
							if($value != 0)
							{
								$insert = array(
										'id_perfil'=> $id_perfil,
										'id_module'=> $id_module,
										'id_section'=> $id_section,
										'id_subsection'=> NULL,
										'id_action'=> (int)$value
								);
								$this->perfil_model->inserir_perfil_rel($insert);
							}
						}
					}		
				}
			}
		}	
	}
	
	public function consulta_perfil_ajax()
	{
		if($this->input->post() == TRUE)
		{
			$id_perfil = $this->input->post('id_perfil');
	
			$this->load->model('sistema/perfil_model');
			$perfil = $this->perfil_model->get_perfil_rel($id_perfil);

			$return = array();
			if($perfil !== NULL)
			{
				foreach ($perfil as $value)
				{
					if($value->id_subsection !== NULL)
					{
						$return[] = array('key'=>'modulo['.$value->id_module.']['.$value->id_section.']['.$value->id_subsection.'][]',
									'value'=>$value->id_action
								);
					}
					else 
					{
						$return[] = array('key'=>'modulo['.$value->id_module.']['.$value->id_section.'][]','value'=>$value->id_action);
					}
				}
			}
			 
			if(!empty($return))
			{
				echo json_encode(array('result'=>true,'modulos'=>$return));
			}
			else 
			{
				echo json_encode(array('result'=>false));
			}
			
		}
	}
}