// Example starter JavaScript for disabling form submissions if there are invalid fields

(function() {

  'use strict';

  window.addEventListener('load', function() {

    // Fetch all the forms we want to apply custom Bootstrap validation styles to

    var forms = document.getElementsByClassName('needs-validation');

    // Loop over them and prevent submission

    var validation = Array.prototype.filter.call(forms, function(form) {

      form.addEventListener('submit', function(event) {

        if (form.checkValidity() === false) {

          event.preventDefault();

          event.stopPropagation();

        }

        form.classList.add('was-validated');

      }, false);

    });

  }, false);

})();

// using jQuery Mask Plugin v1.7.5

// http://jsfiddle.net/d29m6enx/2/

/*var maskBehavior = function (val) {

 return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';

},

options = {onKeyPress: function(val, e, field, options) {

 field.mask(maskBehavior.apply({}, arguments), options);

 }

};

 

$('.phone').mask(maskBehavior, options);*/