$(document).ready(function(){
	
	var loader = $('.box').find('.overlay');
    
    if(loader.length){
      loader.remove();
    }
	
	var date_expire = null;

	$.fn.atualiza_clock_logout = function(date_expire)
	{	
		// Request
		var data = {
			[csrf.name]: csrf.hash,
			post: true
		};
		
		var deferredDateExpire = $.Deferred();
		
		if(date_expire == undefined)
		{
			$.ajax({
				url: base_url + 'sistema/session/get_last_activity',
				dataType: 'json',
				type: 'POST',
				data: data,
				success: function(result)
				{				
					if (result.date_expire)
					{
						date_expire = result.date_expire;
						deferredDateExpire.resolve();
					}
					else
					{
						$(this).atualiza_clock_logout();
					}
				}
			})
		}
		else
		{
			deferredDateExpire.resolve();
		}
		
		deferredDateExpire.done(function(){
			$('.display-clock').countdown(date_expire)
			.on('update.countdown', function(event) {
				if(event.offset.hours == 0)
				{
					var format = '%M:%S';
				}
				else
				{
					var format = '%H:%M:%S';
				}
				$(this).html(event.strftime(format));
			})
			.on('finish.countdown', function(event) {
				$(this).html('encerrado');
				var $Cthis = $(this);
				setInterval(function(){$Cthis.append('.')},1000);		
				setTimeout(function(){
					   location.reload();
				},2000);
				
			});
		})
	}

	$(this).atualiza_clock_logout();
	
	$(".link-menu-extends").click(function(e) 
	{
		e.preventDefault();
		
		$('#control-menu-principal-tab ul li').removeClass("active");
		
		$(this).parent('li').addClass("active");
	
		var id_module = $(this).data( "module" );
		
		$(this).create_menu_ajax(id_module)
    });
	
	$.fn.create_menu_ajax = function(id_module)
	{		
		var target = base_url + 'sistema/menu/create_menu_ajax'
		var data = {
				id_module: id_module
		}
		
		// consulta os campos do evento e cria a opção de seleção		
		request = $.ajax({
			url: target,
			dataType: 'json',
			type: 'POST',
			data: data,
			success: function(result)
			{
				if(result.show == true)
				{	
				    $('#modulo-tab-icon').removeAttr('class');
					$('#modulo-tab-icon').addClass(result.modulo_icone);
					$('#control-menu-extends-tab').html(result.html);
					
					
					$("#menu-extends").removeClass("hide");
					$("#menu-principal").removeClass("active");
					$("#control-menu-principal-tab").removeClass("active");
					$("#menu-extends").addClass("active");
					$("#control-menu-extends-tab").addClass("active");
					
					
				}
				if(result.show == false)
				{					
					$('#id_section_input_box').html(result.html)
				}
				else if(result.error)
				{
					alert(result.error)
				}
			},
			error: function(error)
			{
				alert(error)
			}				
		})      
	}  
	
});

var isMobile = false; //initiate as false
// device detection
if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent) 
    || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(navigator.userAgent.substr(0,4))) isMobile = true;
$('.open-modal').modal('show');

$('.click_modal').click(function(){
    var target = $(this).data('target');
    var link = $(this).data('link');
    $(target).modal('show');
    $(".action_modal").attr('href', link);
});